/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.lang.reflect.Member;
import java.net.URL;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface WeldLogger
extends BasicLogger {
    public static final WeldLogger ROOT_LOGGER = (WeldLogger)Logger.getMessageLogger(WeldLogger.class, (String)"org.jboss.as.weld");
    public static final WeldLogger DEPLOYMENT_LOGGER = (WeldLogger)Logger.getMessageLogger(WeldLogger.class, (String)"org.jboss.weld.deployer");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to setup Weld contexts", id=16000)
    public void failedToSetupWeldContexts(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to tear down Weld contexts", id=16001)
    public void failedToTearDownWeldContexts(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Processing weld deployment %s", id=16002)
    public void processingWeldDeployment(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Found beans.xml file in non-standard location: %s, war deployments should place beans.xml files into WEB-INF/beans.xml", id=16003)
    public void beansXmlInNonStandardLocation(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not find BeanManager for deployment %s", id=16004)
    public void couldNotFindBeanManagerForDeployment(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting Services for CDI deployment: %s", id=16005)
    public void startingServicesForCDIDeployment(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not load portable extension class %s", id=16006)
    public void couldNotLoadPortableExceptionClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="@Resource injection of type %s is not supported for non-ejb components. Injection point: %s", id=16007)
    public void injectionTypeNotValue(Class<?> var1, Member var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting weld service for deployment %s", id=16008)
    public void startingWeldService(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Stopping weld service for deployment %s", id=16009)
    public void stoppingWeldService(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Warning while parsing %s:%s %s", id=16010)
    public void beansXmlValidationWarning(URL var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Warning while parsing %s:%s %s", id=16011)
    public void beansXmlValidationError(URL var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Deployment %s contains CDI annotations but beans.xml was not found.", id=16012)
    public void cdiAnnotationsButNoBeansXML(DeploymentUnit var1);
}

