/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.SecurityRealmChildAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildRemoveHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LdapAuthenticationResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition CONNECTION = new SimpleAttributeDefinitionBuilder("connection", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition BASE_DN = new SimpleAttributeDefinitionBuilder("base-dn", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition RECURSIVE = new SimpleAttributeDefinitionBuilder("recursive", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition USER_DN = new SimpleAttributeDefinitionBuilder("user-dn", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).setDefaultValue(new ModelNode("dn")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition USERNAME_FILTER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username-attribute", ModelType.STRING, false).setXmlName("attribute").setAlternatives(new String[]{"advanced-filter"}).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).setValidateNull(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition ADVANCED_FILTER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advanced-filter", ModelType.STRING, false).setXmlName("filter").setAlternatives(new String[]{"username-attribute"}).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).setValidateNull(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{CONNECTION, BASE_DN, RECURSIVE, USER_DN, USERNAME_FILTER, ADVANCED_FILTER};

    public LdapAuthenticationResourceDefinition() {
        super(PathElement.pathElement((String)"authentication", (String)"ldap"), ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.authentication.ldap"}), (OperationStepHandler)new LdapAuthenticationAddHandler(), (OperationStepHandler)new SecurityRealmChildRemoveHandler(true), OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        LdapAuthenticationWriteHandler handler = new LdapAuthenticationWriteHandler();
        handler.registerAttributes(resourceRegistration);
    }

    private static void validateAttributeCombination(ModelNode operation) throws OperationFailedException {
        boolean usernameFileDefined = operation.hasDefined("username-attribute");
        boolean advancedFilterDefined = operation.hasDefined("advanced-filter");
        if (usernameFileDefined && advancedFilterDefined) {
            throw DomainManagementMessages.MESSAGES.operationFailedOnlyOneOfRequired("username-attribute", "advanced-filter");
        }
        if (!(usernameFileDefined || advancedFilterDefined)) {
            throw DomainManagementMessages.MESSAGES.operationFailedOneOfRequired("username-attribute", "advanced-filter");
        }
    }

    private static class LdapAuthenticationAddHandler
    extends SecurityRealmChildAddHandler {
        private LdapAuthenticationAddHandler() {
            super(true, ATTRIBUTE_DEFINITIONS);
        }

        @Override
        protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
            LdapAuthenticationResourceDefinition.validateAttributeCombination(operation);
            super.updateModel(context, operation);
        }
    }

    private static class LdapAuthenticationWriteHandler
    extends SecurityRealmChildWriteAttributeHandler {
        private LdapAuthenticationWriteHandler() {
            super(ATTRIBUTE_DEFINITIONS);
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
                    Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                    ModelNode model = resource.getModel();
                    LdapAuthenticationResourceDefinition.validateAttributeCombination(model);
                    context.stepCompleted();
                }
            }, OperationContext.Stage.MODEL);
            super.execute(context, operation);
        }
    }
}

