/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.plugin.AuthenticationPlugIn;
import org.jboss.as.domain.management.plugin.Credential;
import org.jboss.as.domain.management.plugin.DigestCredential;
import org.jboss.as.domain.management.plugin.PasswordCredential;
import org.jboss.as.domain.management.plugin.PlugInConfigurationSupport;
import org.jboss.as.domain.management.plugin.ValidatePasswordCredential;
import org.jboss.as.domain.management.security.AbstractPlugInService;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.msc.service.Service;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class PlugInAuthenticationCallbackHandler
extends AbstractPlugInService
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    public static final String SERVICE_SUFFIX = "plug-in-authentication";
    private static UsernamePasswordHashUtil hashUtil = null;
    private final AuthenticationMechanism mechanism;

    PlugInAuthenticationCallbackHandler(String realmName, String pluginName, Map<String, String> properties, AuthenticationMechanism mechanism) {
        super(realmName, pluginName, properties);
        this.mechanism = mechanism;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static UsernamePasswordHashUtil getHashUtil() {
        if (hashUtil == null) {
            try {
                hashUtil = new UsernamePasswordHashUtil();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return hashUtil;
    }

    @Override
    public AuthenticationMechanism getPreferredMechanism() {
        return this.mechanism;
    }

    @Override
    public Set<AuthenticationMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        if (this.mechanism == AuthenticationMechanism.DIGEST) {
            return Collections.singletonMap("org.jboss.as.domain.management.digest.plain_text", Boolean.FALSE.toString());
        }
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        String name = this.getPlugInName();
        final AuthenticationPlugIn<Credential> ap = this.getPlugInLoader().loadAuthenticationPlugIn(name);
        if (ap instanceof PlugInConfigurationSupport) {
            PlugInConfigurationSupport pcf = (PlugInConfigurationSupport)((Object)ap);
            try {
                pcf.init(this.getConfiguration(), sharedState);
            }
            catch (IOException e) {
                throw DomainManagementMessages.MESSAGES.unableToInitialisePlugIn(name, e.getMessage());
            }
        }
        return new CallbackHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                String realm;
                UsernamePasswordHashUtil identity;
                String realmName = PlugInAuthenticationCallbackHandler.this.getRealmName();
                LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
                String userName = null;
                Object credential = null;
                for (Callback current : callbacks) {
                    if (current instanceof AuthorizeCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        userName = nameCallback.getDefaultName();
                        identity = ap.loadIdentity(userName, realmName);
                        if (identity == null) continue;
                        credential = identity.getCredential();
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof DigestHashCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        realm = ((RealmCallback)current).getDefaultText();
                        if (realmName.equals(realm)) continue;
                        throw DomainManagementMessages.MESSAGES.invalidRealm(realm, realmName);
                    }
                    throw new UnsupportedCallbackException(current);
                }
                for (Callback current : toRespondTo) {
                    if (current instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        if (credential == null) {
                            throw new UserNotFoundException(userName);
                        }
                        if (credential instanceof PasswordCredential) {
                            ((PasswordCallback)current).setPassword(((PasswordCredential)credential).getPassword());
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                    if (current instanceof DigestHashCallback) {
                        if (credential == null) {
                            throw new UserNotFoundException(userName);
                        }
                        if (credential instanceof DigestCredential) {
                            ((DigestHashCallback)current).setHexHash(((DigestCredential)credential).getHash());
                            continue;
                        }
                        if (credential instanceof PasswordCredential) {
                            String hash;
                            UsernamePasswordHashUtil hashUtil = PlugInAuthenticationCallbackHandler.getHashUtil();
                            realm = hashUtil;
                            synchronized (realm) {
                                hash = hashUtil.generateHashedHexURP(userName, realmName, ((PasswordCredential)credential).getPassword());
                            }
                            ((DigestHashCallback)current).setHexHash(hash);
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                    if (!(current instanceof VerifyPasswordCallback)) continue;
                    if (credential == null) {
                        throw new UserNotFoundException(userName);
                    }
                    VerifyPasswordCallback vpc = (VerifyPasswordCallback)current;
                    if (credential instanceof PasswordCredential) {
                        vpc.setVerified(Arrays.equals(((PasswordCredential)credential).getPassword(), vpc.getPassword().toCharArray()));
                        continue;
                    }
                    if (credential instanceof DigestCredential) {
                        String hash;
                        UsernamePasswordHashUtil hashUtil;
                        identity = hashUtil = PlugInAuthenticationCallbackHandler.getHashUtil();
                        synchronized (identity) {
                            hash = hashUtil.generateHashedHexURP(userName, realmName, vpc.getPassword().toCharArray());
                        }
                        String expected = ((DigestCredential)credential).getHash();
                        vpc.setVerified(expected.equals(hash));
                        continue;
                    }
                    if (!(credential instanceof ValidatePasswordCredential)) continue;
                    vpc.setVerified(((ValidatePasswordCredential)credential).validatePassword(vpc.getPassword().toCharArray()));
                }
            }
        };
    }
}

