/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PromptNewUserState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;
import org.jboss.as.domain.management.security.state.UserPropertiesFileHandler;
import org.jboss.msc.service.StartException;

public class PropertyFileFinder
implements State {
    private ConsoleWrapper theConsole;
    private final StateValues stateValues;

    public PropertyFileFinder(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        String fileName;
        this.stateValues.setKnownRoles(new HashMap<String, String>());
        String jbossHome = this.stateValues.getJBossHome();
        if (jbossHome == null) {
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.jbossHomeNotSet(), null, this.stateValues);
        }
        ArrayList<File> foundFiles = new ArrayList<File>(2);
        String string = fileName = this.stateValues.isManagement() ? "mgmt-users.properties" : "application-users.properties";
        if (!this.findFiles(jbossHome, foundFiles, fileName)) {
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.propertiesFileNotFound(fileName), null, this.stateValues);
        }
        if (!this.stateValues.isManagement()) {
            ArrayList<File> foundRoleFiles = new ArrayList<File>(2);
            if (!this.findFiles(jbossHome, foundRoleFiles, "application-roles.properties")) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.propertiesFileNotFound("application-roles.properties"), null, this.stateValues);
            }
            this.stateValues.setRoleFiles(foundRoleFiles);
            try {
                this.stateValues.setKnownRoles(this.loadAllRoles(foundRoleFiles));
            }
            catch (Exception e) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.propertiesFileNotFound("application-roles.properties"), null, this.stateValues);
            }
        }
        this.stateValues.setPropertiesFiles(foundFiles);
        HashSet<String> foundUsers = new HashSet<String>();
        for (File current : this.stateValues.getPropertiesFiles()) {
            try {
                foundUsers.addAll(this.loadUserNames(current));
            }
            catch (IOException e) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.unableToLoadUsers(current.getAbsolutePath(), e.getMessage()), null, this.stateValues);
            }
        }
        this.stateValues.setKnownUsers(foundUsers);
        return new PromptNewUserState(this.theConsole, this.stateValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadAllRoles(List<File> foundRoleFiles) throws StartException, IOException {
        HashMap<String, String> loadedRoles = new HashMap<String, String>();
        for (File file : foundRoleFiles) {
            UserPropertiesFileHandler propertiesLoad = null;
            try {
                propertiesLoad = new UserPropertiesFileHandler(file.getCanonicalPath());
                propertiesLoad.start(null);
                loadedRoles.putAll(propertiesLoad.getProperties());
            }
            finally {
                if (propertiesLoad == null) continue;
                propertiesLoad.stop(null);
            }
        }
        return loadedRoles;
    }

    private boolean findFiles(String jbossHome, List<File> foundFiles, String fileName) {
        File domainProps;
        File standaloneProps = this.buildFilePath(jbossHome, "jboss.server.config.user.dir", "jboss.server.config.dir", "jboss.server.base.dir", "standalone", fileName);
        if (standaloneProps.exists()) {
            foundFiles.add(standaloneProps);
        }
        if ((domainProps = this.buildFilePath(jbossHome, "jboss.domain.config.user.dir", "jboss.domain.config.dir", "jboss.domain.base.dir", "domain", fileName)).exists()) {
            foundFiles.add(domainProps);
        }
        return !foundFiles.isEmpty();
    }

    private File buildFilePath(String jbossHome, String serverCofigUserDirPropertyName, String serverConfigDirPropertyName, String serverBaseDirPropertyName, String defaultBaseDir, String fileName) {
        File configDir;
        String configUserDirConfiguredPath = System.getProperty(serverCofigUserDirPropertyName);
        String configDirConfiguredPath = configUserDirConfiguredPath != null ? configUserDirConfiguredPath : System.getProperty(serverConfigDirPropertyName);
        File file = configDir = configDirConfiguredPath != null ? new File(configDirConfiguredPath) : null;
        if (configDir == null) {
            String baseDirConfiguredPath = System.getProperty(serverBaseDirPropertyName);
            File baseDir = baseDirConfiguredPath != null ? new File(baseDirConfiguredPath) : new File(jbossHome, defaultBaseDir);
            configDir = new File(baseDir, "configuration");
        }
        return new File(configDir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadUserNames(File file) throws IOException {
        Set<String> set;
        InputStreamReader fis = null;
        try {
            fis = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
            Properties tempProps = new Properties();
            tempProps.load(fis);
            set = tempProps.stringPropertyNames();
        }
        catch (Throwable throwable) {
            PropertyFileFinder.safeClose(fis);
            throw throwable;
        }
        PropertyFileFinder.safeClose(fis);
        return set;
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

