/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.metric.impl;

import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.load.metric.impl.AbstractLoadMetric;

public class SystemMemoryUsageLoadMetric
extends AbstractLoadMetric {
    public static final String FREE_MEMORY = "FreePhysicalMemorySize";
    public static final String TOTAL_MEMORY = "TotalPhysicalMemorySize";
    private Logger logger = Logger.getLogger(this.getClass());
    private volatile MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public double getLoad(Engine engine) throws Exception {
        try {
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            double free = ((Number)this.server.getAttribute(name, FREE_MEMORY)).doubleValue();
            double total = ((Number)this.server.getAttribute(name, TOTAL_MEMORY)).doubleValue();
            return (total - free) / total;
        }
        catch (AttributeNotFoundException e) {
            this.logger.warn((Object)(this.getClass().getSimpleName() + " requires com.sun.management.OperatingSystemMXBean."));
            this.setWeight(0);
            return 0.0;
        }
    }
}

