/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

public class AbstractEnvironment
implements XEnvironment {
    private final AtomicLong resourceIndex = new AtomicLong();
    private final Map<CacheKey, Set<Capability>> capabilityCache = new ConcurrentHashMap<CacheKey, Set<Capability>>();
    private final Map<String, Set<XResource>> resourceTypeCache = new ConcurrentHashMap<String, Set<XResource>>();
    private final Map<Long, XResource> resourceIndexCache = new ConcurrentHashMap<Long, XResource>();
    private final Map<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextResourceIdentifier(Long value, String symbolicName) {
        AtomicLong atomicLong = this.resourceIndex;
        synchronized (atomicLong) {
            if (value != null) {
                this.resourceIndex.addAndGet(Math.max(0L, value - this.resourceIndex.get()));
                Long result = value;
                return result;
            }
            Long result = this.resourceIndex.incrementAndGet();
            ResolverLogger.LOGGER.tracef("Resource identifier for %s: [%d,%d]", symbolicName, value, result);
            return result;
        }
    }

    @Override
    public synchronized void installResources(XResource ... resources) {
        for (XResource res : resources) {
            Wiring wiring;
            XIdentityCapability icap = res.getIdentityCapability();
            if (this.getCachedCapabilities(CacheKey.create(icap)).contains(icap)) {
                throw ResolverMessages.MESSAGES.illegalStateResourceAlreadyInstalled(res);
            }
            ResolverLogger.LOGGER.debugf("Install resource: %s", res);
            Long index = this.nextResourceIdentifier(res.getAttachment(Long.class), icap.getSymbolicName());
            res.addAttachment(Long.class, index);
            this.resourceIndexCache.put(index, res);
            this.getCachedResources(icap.getType()).add(res);
            for (Capability cap : res.getCapabilities(null)) {
                this.getCachedCapabilities(CacheKey.create(cap)).add(cap);
                ResolverLogger.LOGGER.debugf("   %s", cap);
            }
            if (ResolverLogger.LOGGER.isDebugEnabled()) {
                for (Requirement req : res.getRequirements(null)) {
                    ResolverLogger.LOGGER.debugf("   %s", req);
                }
            }
            if ((wiring = res.getAttachment(Wiring.class)) == null) continue;
            this.wirings.put(res, wiring);
        }
    }

    @Override
    public synchronized void uninstallResources(XResource ... resources) {
        for (XResource res : resources) {
            Long index = res.getAttachment(Long.class);
            if (index == null || this.resourceIndexCache.remove(index) == null) {
                ResolverLogger.LOGGER.debugf("Unknown resource: %s", res);
                continue;
            }
            ResolverLogger.LOGGER.debugf("Uninstall resource: %s", res);
            XIdentityCapability icap = res.getIdentityCapability();
            this.getCachedResources(icap.getType()).remove(res);
            for (Capability cap : res.getCapabilities(null)) {
                CacheKey cachekey = CacheKey.create(cap);
                Set<Capability> capset = this.getCachedCapabilities(cachekey);
                capset.remove(cap);
                if (!capset.isEmpty()) continue;
                this.capabilityCache.remove(cachekey);
            }
            this.wirings.remove(res);
        }
    }

    @Override
    public void refreshResources(XResource ... resources) {
        for (XResource res : resources) {
            res.removeAttachment(Wiring.class);
            this.wirings.remove(res);
        }
    }

    @Override
    public synchronized Collection<XResource> getResources(String ... types) {
        HashSet<XResource> result = new HashSet<XResource>();
        for (String type : types != null ? types : ALL_IDENTITY_TYPES) {
            result.addAll(this.getCachedResources(type));
        }
        return result;
    }

    @Override
    public synchronized List<Capability> findProviders(Requirement req) {
        XRequirement xreq = (XRequirement)req;
        CacheKey cachekey = CacheKey.create(req);
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Capability cap : this.getCachedCapabilities(cachekey)) {
            if (!xreq.matches(cap)) continue;
            boolean ignoreCapability = false;
            XCapability xcap = (XCapability)cap;
            XResource res = (XResource)xcap.getResource();
            Wiring wiring = res.getAttachment(Wiring.class);
            if (wiring != null && xcap.adapt(XPackageCapability.class) != null) {
                String pkgname = xcap.adapt(XPackageCapability.class).getPackageName();
                for (Wire wire : wiring.getRequiredResourceWires(cap.getNamespace())) {
                    XRequirement wirereq = (XRequirement)wire.getRequirement();
                    XPackageRequirement preq = wirereq.adapt(XPackageRequirement.class);
                    if (!pkgname.equals(preq.getPackageName())) continue;
                    ignoreCapability = true;
                    break;
                }
            }
            List<Requirement> hostreqs = res.getRequirements("osgi.wiring.host");
            if (wiring == null && !hostreqs.isEmpty()) {
                XRequirement hostreq = (XRequirement)hostreqs.get(0);
                boolean unresolvedHost = false;
                for (Capability hostcap : this.capabilityCache.get(CacheKey.create(hostreq))) {
                    XResource host;
                    if (!hostreq.matches(hostcap) || (host = (XResource)hostcap.getResource()).getAttachment(Wiring.class) != null) continue;
                    unresolvedHost = true;
                    break;
                }
                boolean bl = ignoreCapability = !unresolvedHost;
            }
            if (ignoreCapability) continue;
            result.add(cap);
        }
        ResolverLogger.LOGGER.tracef("Env provides: %s => %s", req, result);
        return result;
    }

    @Override
    public synchronized Map<Resource, Wiring> updateWiring(Map<Resource, List<Wire>> wiremap) {
        HashMap<Resource, WireInfo> infos = new HashMap<Resource, WireInfo>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            WireInfo reqinfo = this.getWireInfo(infos, (XResource)entry.getKey());
            reqinfo.required.addAll((Collection<Wire>)entry.getValue());
            for (Wire wire : entry.getValue()) {
                XResource provider = (XResource)wire.getProvider();
                WireInfo provinfo = this.getWireInfo(infos, provider);
                provinfo.provided.add(wire);
            }
        }
        HashMap<XResource, Wiring> result = new HashMap<XResource, Wiring>();
        for (WireInfo info : infos.values()) {
            Wiring reswiring = this.updateResourceWiring(info);
            result.put(info.resource, reswiring);
        }
        return Collections.unmodifiableMap(result);
    }

    private WireInfo getWireInfo(Map<Resource, WireInfo> infos, XResource resource) {
        WireInfo info = infos.get(resource);
        if (info == null) {
            Wiring reswiring = resource.getAttachment(Wiring.class);
            info = new WireInfo(resource, reswiring);
            infos.put(resource, info);
        }
        return info;
    }

    private Wiring updateResourceWiring(WireInfo info) {
        Wiring wiring = this.createWiring(info.resource, info.required, info.provided);
        info.resource.addAttachment(Wiring.class, wiring);
        this.wirings.put(info.resource, wiring);
        return wiring;
    }

    @Override
    public Wiring createWiring(XResource res, List<Wire> required, List<Wire> provided) {
        return new AbstractWiring(res, required, provided);
    }

    @Override
    public synchronized Map<Resource, Wiring> getWirings() {
        return Collections.unmodifiableMap(this.wirings);
    }

    private synchronized Set<Capability> getCachedCapabilities(CacheKey key) {
        Set<Capability> capset = this.capabilityCache.get(key);
        if (capset == null) {
            capset = new LinkedHashSet<Capability>();
            this.capabilityCache.put(key, capset);
        }
        return capset;
    }

    private synchronized Set<XResource> getCachedResources(String type) {
        Set<XResource> typeset = this.resourceTypeCache.get(type);
        if (typeset == null) {
            typeset = new LinkedHashSet<XResource>();
            this.resourceTypeCache.put(type, typeset);
        }
        return typeset;
    }

    private static class CacheKey {
        private final String key;

        static CacheKey create(Capability cap) {
            String namespace = cap.getNamespace();
            return new CacheKey(namespace, (String)cap.getAttributes().get(namespace));
        }

        static CacheKey create(Requirement req) {
            String namespace = req.getNamespace();
            return new CacheKey(namespace, (String)req.getAttributes().get(namespace));
        }

        private CacheKey(String namespace, String value) {
            this.key = namespace + ":" + value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.key.equals(other.key);
        }

        public String toString() {
            return "[" + this.key + "]";
        }
    }

    private static class WireInfo {
        final XResource resource;
        final List<Wire> required = new ArrayList<Wire>();
        final List<Wire> provided = new ArrayList<Wire>();

        WireInfo(Resource resource, Wiring wiring) {
            this.resource = (XResource)resource;
            if (wiring != null) {
                this.required.addAll(wiring.getRequiredResourceWires(null));
                this.provided.addAll(wiring.getProvidedResourceWires(null));
            }
        }
    }
}

