/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.Serializable;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.utils.UUIDGenerator;

public class DiscoveryGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = -788378590243304842L;
    private String name;
    private long refreshTimeout;
    private long discoveryInitialWaitTimeout;
    private final BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration;

    public DiscoveryGroupConfiguration(String name, long refreshTimeout, long discoveryInitialWaitTimeout, BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration) {
        this.name = name;
        this.refreshTimeout = refreshTimeout;
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
        this.endpointFactoryConfiguration = endpointFactoryConfiguration;
    }

    public DiscoveryGroupConfiguration(long refreshTimeout, long discoveryInitialWaitTimeout, BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration) {
        this(UUIDGenerator.getInstance().generateStringUUID(), refreshTimeout, discoveryInitialWaitTimeout, endpointFactoryConfiguration);
    }

    public String getName() {
        return this.name;
    }

    public long getRefreshTimeout() {
        return this.refreshTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRefreshTimeout(long refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
    }

    public long getDiscoveryInitialWaitTimeout() {
        return this.discoveryInitialWaitTimeout;
    }

    public void setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
    }

    public BroadcastEndpointFactoryConfiguration getBroadcastEndpointFactoryConfiguration() {
        return this.endpointFactoryConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryGroupConfiguration that = (DiscoveryGroupConfiguration)o;
        if (this.discoveryInitialWaitTimeout != that.discoveryInitialWaitTimeout) {
            return false;
        }
        if (this.refreshTimeout != that.refreshTimeout) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (int)(this.refreshTimeout ^ this.refreshTimeout >>> 32);
        result = 31 * result + (int)(this.discoveryInitialWaitTimeout ^ this.discoveryInitialWaitTimeout >>> 32);
        return result;
    }

    public String toString() {
        return "DiscoveryGroupConfiguration{name='" + this.name + '\'' + ", refreshTimeout=" + this.refreshTimeout + ", discoveryInitialWaitTimeout=" + this.discoveryInitialWaitTimeout + '}';
    }
}

