/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.BroadcastEndpoint;
import org.hornetq.api.core.BroadcastEndpointFactory;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;

public class JGroupsBroadcastGroupConfiguration
implements BroadcastEndpointFactoryConfiguration {
    private static final long serialVersionUID = 8952238567248461285L;
    private final BroadcastEndpointFactory factory;

    public JGroupsBroadcastGroupConfiguration(final String jgroupsFile, final String channelName) {
        this.factory = new BroadcastEndpointFactory(){

            @Override
            public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
                return new JGroupsBroadcastEndpoint(jgroupsFile, channelName);
            }
        };
    }

    public JGroupsBroadcastGroupConfiguration(final JChannel channel, final String channelName) {
        this.factory = new BroadcastEndpointFactory(){

            @Override
            public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
                return new JGroupsBroadcastEndpoint(channel, channelName);
            }
        };
    }

    @Override
    public BroadcastEndpointFactory createBroadcastEndpointFactory() {
        return this.factory;
    }

    private static class JGroupsBroadcastEndpoint
    implements BroadcastEndpoint {
        private BlockingQueue<byte[]> dequeue = new LinkedBlockingDeque<byte[]>();
        private boolean clientOpened;
        private boolean broadcastOpened;
        private final String channelName;
        private final JChannel channel;

        public JGroupsBroadcastEndpoint(String fileName, String channelName) throws Exception {
            URL configURL = Thread.currentThread().getContextClassLoader().getResource(fileName);
            if (configURL == null) {
                throw new RuntimeException("couldn't find JGroups configuration " + fileName);
            }
            this.channel = new JChannel(configURL);
            this.channelName = channelName;
        }

        public JGroupsBroadcastEndpoint(JChannel channel, String channelName) {
            this.channel = channel;
            this.channelName = channelName;
        }

        @Override
        public void broadcast(byte[] data) throws Exception {
            if (this.broadcastOpened) {
                Message msg = new Message();
                msg.setBuffer(data);
                this.channel.send(msg);
            }
        }

        @Override
        public byte[] receiveBroadcast() throws Exception {
            if (this.clientOpened) {
                return this.dequeue.take();
            }
            return null;
        }

        @Override
        public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
            if (this.clientOpened) {
                return this.dequeue.poll(time, unit);
            }
            return null;
        }

        @Override
        public synchronized void openClient() throws Exception {
            if (this.clientOpened) {
                return;
            }
            this.internalOpen();
            this.channel.setReceiver((Receiver)new JGroupsReceiver());
            this.clientOpened = true;
        }

        @Override
        public synchronized void openBroadcaster() throws Exception {
            if (this.broadcastOpened) {
                return;
            }
            this.internalOpen();
            this.broadcastOpened = true;
        }

        protected void internalOpen() throws Exception {
            if (this.channel.isConnected()) {
                return;
            }
            this.channel.connect(this.channelName);
        }

        @Override
        public synchronized void close(boolean isBroadcast) throws Exception {
            if (isBroadcast) {
                this.broadcastOpened = false;
            } else {
                this.channel.setReceiver(null);
                this.clientOpened = false;
            }
            this.channel.close();
        }

        private class JGroupsReceiver
        extends ReceiverAdapter {
            private JGroupsReceiver() {
            }

            public void receive(Message msg) {
                JGroupsBroadcastEndpoint.this.dequeue.add(msg.getBuffer());
            }
        }
    }
}

