/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.BroadcastEndpoint;
import org.hornetq.api.core.BroadcastEndpointFactory;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.core.server.HornetQLogger;

public final class UDPBroadcastGroupConfiguration
implements BroadcastEndpointFactoryConfiguration {
    private static final long serialVersionUID = 1052413739064253955L;
    private final String localBindAddress;
    private final int localBindPort;
    private final String groupAddress;
    private final int groupPort;

    public UDPBroadcastGroupConfiguration(String groupAddress, int groupPort, String localBindAddress, int localBindPort) {
        this.groupAddress = groupAddress;
        this.groupPort = groupPort;
        this.localBindAddress = localBindAddress;
        this.localBindPort = localBindPort;
    }

    @Override
    public BroadcastEndpointFactory createBroadcastEndpointFactory() {
        return new BroadcastEndpointFactory(){

            @Override
            public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
                return new UDPBroadcastEndpoint(UDPBroadcastGroupConfiguration.this.groupAddress != null ? InetAddress.getByName(UDPBroadcastGroupConfiguration.this.groupAddress) : null, UDPBroadcastGroupConfiguration.this.groupPort, UDPBroadcastGroupConfiguration.this.localBindAddress != null ? InetAddress.getByName(UDPBroadcastGroupConfiguration.this.localBindAddress) : null, UDPBroadcastGroupConfiguration.this.localBindPort);
            }
        };
    }

    public String getGroupAddress() {
        return this.groupAddress;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public int getLocalBindPort() {
        return this.localBindPort;
    }

    public String getLocalBindAddress() {
        return this.localBindAddress;
    }

    private static class UDPBroadcastEndpoint
    implements BroadcastEndpoint {
        private static final int SOCKET_TIMEOUT = 500;
        private final InetAddress localAddress;
        private final int localBindPort;
        private final InetAddress groupAddress;
        private final int groupPort;
        private DatagramSocket broadcastingSocket;
        private MulticastSocket receivingSocket;
        private volatile boolean open;

        public UDPBroadcastEndpoint(InetAddress groupAddress, int groupPort, InetAddress localBindAddress, int localBindPort) throws UnknownHostException {
            this.groupAddress = groupAddress;
            this.groupPort = groupPort;
            this.localAddress = localBindAddress;
            this.localBindPort = localBindPort;
        }

        @Override
        public void broadcast(byte[] data) throws Exception {
            DatagramPacket packet = new DatagramPacket(data, data.length, this.groupAddress, this.groupPort);
            this.broadcastingSocket.send(packet);
        }

        @Override
        public byte[] receiveBroadcast() throws Exception {
            byte[] data = new byte[65535];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            while (this.open) {
                try {
                    this.receivingSocket.receive(packet);
                    break;
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    if (!this.open) break;
                    HornetQLogger.LOGGER.warn(this + " getting exception when receiving broadcasting.", e);
                    break;
                }
            }
            return data;
        }

        @Override
        public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
            return this.receiveBroadcast();
        }

        @Override
        public void openBroadcaster() throws Exception {
            if (this.localBindPort != -1) {
                this.broadcastingSocket = new DatagramSocket(this.localBindPort, this.localAddress);
            } else {
                if (this.localAddress != null) {
                    HornetQLogger.LOGGER.broadcastGroupBindError();
                }
                this.broadcastingSocket = new DatagramSocket();
            }
            this.open = true;
        }

        @Override
        public void openClient() throws Exception {
            if (UDPBroadcastEndpoint.checkForLinux() || UDPBroadcastEndpoint.checkForSolaris() || UDPBroadcastEndpoint.checkForHp()) {
                try {
                    this.receivingSocket = new MulticastSocket(new InetSocketAddress(this.groupAddress, this.groupPort));
                }
                catch (IOException e) {
                    HornetQLogger.LOGGER.ioDiscoveryError(this.groupAddress.getHostAddress(), this.groupAddress instanceof Inet4Address ? "IPv4" : "IPv6");
                    this.receivingSocket = new MulticastSocket(this.groupPort);
                }
            } else {
                this.receivingSocket = new MulticastSocket(this.groupPort);
            }
            if (this.localAddress != null) {
                this.receivingSocket.setInterface(this.localAddress);
            }
            this.receivingSocket.joinGroup(this.groupAddress);
            this.receivingSocket.setSoTimeout(500);
            this.open = true;
        }

        @Override
        public void close(boolean isBroadcast) throws Exception {
            this.open = false;
            if (this.broadcastingSocket != null) {
                this.broadcastingSocket.close();
            }
            if (this.receivingSocket != null) {
                this.receivingSocket.close();
            }
        }

        private static boolean checkForLinux() {
            return UDPBroadcastEndpoint.checkForPresence("os.name", "linux");
        }

        private static boolean checkForHp() {
            return UDPBroadcastEndpoint.checkForPresence("os.name", "hp");
        }

        private static boolean checkForSolaris() {
            return UDPBroadcastEndpoint.checkForPresence("os.name", "sun");
        }

        private static boolean checkForPresence(String key, String value) {
            try {
                String tmp = System.getProperty(key);
                return tmp != null && tmp.trim().toLowerCase().startsWith(value);
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

