/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.client;

import java.util.UUID;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.client.impl.ClientMessageImpl;

public class ClientRequestor {
    private final ClientSession queueSession;
    private final ClientProducer requestProducer;
    private final ClientConsumer replyConsumer;
    private final SimpleString replyQueue;

    public ClientRequestor(ClientSession session, SimpleString requestAddress) throws Exception {
        this.queueSession = session;
        this.requestProducer = this.queueSession.createProducer(requestAddress);
        this.replyQueue = new SimpleString(requestAddress + "." + UUID.randomUUID().toString());
        this.queueSession.createTemporaryQueue(this.replyQueue, this.replyQueue);
        this.replyConsumer = this.queueSession.createConsumer(this.replyQueue);
    }

    public ClientRequestor(ClientSession session, String requestAddress) throws Exception {
        this(session, SimpleString.toSimpleString(requestAddress));
    }

    public ClientMessage request(ClientMessage request) throws Exception {
        return this.request(request, 0L);
    }

    public ClientMessage request(ClientMessage request, long timeout) throws Exception {
        request.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, this.replyQueue);
        this.requestProducer.send(request);
        return this.replyConsumer.receive(timeout);
    }

    public void close() throws Exception {
        this.replyConsumer.close();
        this.requestProducer.close();
        this.queueSession.deleteQueue(this.replyQueue);
    }
}

