/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

public interface HornetQServerControl {
    public String getVersion();

    public int getConnectionCount();

    public boolean isStarted();

    public String[] getInterceptorClassNames();

    public boolean isClustered();

    public int getScheduledThreadPoolMaxSize();

    public int getThreadPoolMaxSize();

    public long getSecurityInvalidationInterval();

    public boolean isSecurityEnabled();

    public String getBindingsDirectory();

    public String getJournalDirectory();

    public String getJournalType();

    public boolean isJournalSyncTransactional();

    public boolean isJournalSyncNonTransactional();

    public int getJournalFileSize();

    public int getJournalMinFiles();

    public int getJournalMaxIO();

    public int getJournalBufferSize();

    public int getJournalBufferTimeout();

    public void setFailoverOnServerShutdown(boolean var1) throws Exception;

    public boolean isFailoverOnServerShutdown();

    public int getJournalCompactMinFiles();

    public int getJournalCompactPercentage();

    public boolean isPersistenceEnabled();

    public boolean isCreateBindingsDir();

    public boolean isCreateJournalDir();

    public boolean isMessageCounterEnabled();

    public int getMessageCounterMaxDayCount();

    public void setMessageCounterMaxDayCount(int var1) throws Exception;

    public long getMessageCounterSamplePeriod();

    public void setMessageCounterSamplePeriod(long var1) throws Exception;

    public boolean isBackup();

    public boolean isSharedStore();

    public String getPagingDirectory();

    public boolean isPersistDeliveryCountBeforeDelivery();

    public long getConnectionTTLOverride();

    public String getManagementAddress();

    public String getManagementNotificationAddress();

    public int getIDCacheSize();

    public boolean isPersistIDCache();

    public String getLargeMessagesDirectory();

    public boolean isWildcardRoutingEnabled();

    public long getTransactionTimeout();

    public long getTransactionTimeoutScanPeriod();

    public long getMessageExpiryScanPeriod();

    public long getMessageExpiryThreadPriority();

    public boolean isAsyncConnectionExecutionEnabled();

    public Object[] getConnectors() throws Exception;

    public String getConnectorsAsJSON() throws Exception;

    public String[] getAddressNames();

    public String[] getQueueNames();

    @Operation(desc="Create a queue with the specified address", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2) throws Exception;

    @Operation(desc="Create a queue", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Create a queue with the specified address, name and durability", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="durable", desc="Is the queue durable?") boolean var3) throws Exception;

    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3) throws Exception;

    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Enable message counters", impact=1)
    public void enableMessageCounters() throws Exception;

    @Operation(desc="Disable message counters", impact=1)
    public void disableMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters", impact=1)
    public void resetAllMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters history", impact=1)
    public void resetAllMessageCounterHistories() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first")
    public String[] listPreparedTransactions() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in JSON format")
    public String listPreparedTransactionDetailsAsJSON() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in HTML format")
    public String listPreparedTransactionDetailsAsHTML() throws Exception;

    public String[] listHeuristicCommittedTransactions() throws Exception;

    public String[] listHeuristicRolledBackTransactions() throws Exception;

    @Operation(desc="Commit a prepared transaction")
    public boolean commitPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="Rollback a prepared transaction")
    public boolean rollbackPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    public String listProducersInfoAsJSON() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    public void sendQueueInfoToQueue(String var1, String var2) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8) throws Exception;

    @Operation(desc="Remove security settings for an address", impact=1)
    public void removeSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="get roles for a specific address match", impact=0)
    public Object[] getRoles(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="get roles (as a JSON string) for a specific address match", impact=0)
    public String getRolesAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the ploicy to use when the address is full", name="addressFullMessagePolicy") String var21) throws Exception;

    public void removeAddressSettings(String var1) throws Exception;

    @Operation(desc="returns the address settings as a JSON string for an address match", impact=0)
    public String getAddressSettingsAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    public String[] getDivertNames();

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Adress to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7) throws Exception;

    @Operation(desc="Destroy a Divert", impact=1)
    public void destroyDivert(@Parameter(name="name", desc="Name of the divert") String var1) throws Exception;

    public String[] getBridgeNames();

    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the brdige") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="retryInterval", desc="Connection retry interval") long var6, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var8, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var10, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var11, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var12, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var13, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var15, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var16, @Parameter(name="ha", desc="Is it using HA") boolean var17, @Parameter(name="user", desc="User name") String var18, @Parameter(name="password", desc="User password") String var19) throws Exception;

    @Operation(desc="Destroy a bridge", impact=1)
    public void destroyBridge(@Parameter(name="name", desc="Name of the bridge") String var1) throws Exception;

    @Operation(desc="force the server to stop and notify clients to failover", impact=3)
    public void forceFailover() throws Exception;
}

