/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.FilterConstants;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterParser;
import org.hornetq.core.filter.impl.Identifier;
import org.hornetq.core.filter.impl.Operator;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.ServerMessage;

public class FilterImpl
implements Filter {
    private final SimpleString sfilterString;
    private final Map<SimpleString, Identifier> identifiers = new HashMap<SimpleString, Identifier>();
    private final FilterParser parser = new FilterParser();
    private final Object result;
    private final Class<? extends Object> resultType;

    public static Filter createFilter(String filterStr) throws HornetQException {
        return FilterImpl.createFilter(SimpleString.toSimpleString(filterStr == null ? null : filterStr.trim()));
    }

    public static Filter createFilter(SimpleString filterStr) throws HornetQException {
        if (filterStr == null || filterStr.length() == 0) {
            return null;
        }
        return new FilterImpl(filterStr);
    }

    private FilterImpl(SimpleString str) throws HornetQException {
        this.sfilterString = str;
        try {
            this.result = this.parser.parse(this.sfilterString, this.identifiers);
            this.resultType = this.result.getClass();
        }
        catch (Throwable e) {
            HornetQLogger.LOGGER.invalidFilter(e, str);
            throw HornetQMessageBundle.BUNDLE.invalidFilter(e, str);
        }
    }

    @Override
    public SimpleString getFilterString() {
        return this.sfilterString;
    }

    @Override
    public synchronized boolean match(ServerMessage message) {
        try {
            for (Identifier id : this.identifiers.values()) {
                Object val = null;
                if (id.getName().startsWith(FilterConstants.HORNETQ_PREFIX)) {
                    val = this.getHeaderFieldValue(message, id.getName());
                }
                if (val == null) {
                    val = message.getObjectProperty(id.getName());
                }
                id.setValue(val);
            }
            if (this.resultType.equals(Identifier.class)) {
                return (Boolean)((Identifier)this.result).getValue();
            }
            if (this.resultType.equals(Operator.class)) {
                Operator op = (Operator)this.result;
                return (Boolean)op.apply();
            }
            throw new Exception("Bad object type: " + this.result);
        }
        catch (Exception e) {
            HornetQLogger.LOGGER.invalidFilter(e, this.sfilterString);
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sfilterString == null ? 0 : this.sfilterString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterImpl other = (FilterImpl)obj;
        return !(this.sfilterString == null ? other.sfilterString != null : !this.sfilterString.equals(other.sfilterString));
    }

    public String toString() {
        return "FilterImpl [sfilterString=" + this.sfilterString + "]";
    }

    private Object getHeaderFieldValue(ServerMessage msg, SimpleString fieldName) {
        if (FilterConstants.HORNETQ_USERID.equals(fieldName)) {
            return new SimpleString("ID:" + msg.getUserID());
        }
        if (FilterConstants.HORNETQ_PRIORITY.equals(fieldName)) {
            return (int)msg.getPriority();
        }
        if (FilterConstants.HORNETQ_TIMESTAMP.equals(fieldName)) {
            return msg.getTimestamp();
        }
        if (FilterConstants.HORNETQ_DURABLE.equals(fieldName)) {
            return msg.isDurable() ? FilterConstants.DURABLE : FilterConstants.NON_DURABLE;
        }
        if (FilterConstants.HORNETQ_EXPIRATION.equals(fieldName)) {
            return msg.getExpiration();
        }
        if (FilterConstants.HORNETQ_SIZE.equals(fieldName)) {
            return msg.getEncodeSize();
        }
        return null;
    }
}

