/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.utils.Pair;

public class ClusterTopologyChangeMessage_V2
extends ClusterTopologyChangeMessage {
    private long uniqueEventID;
    private String nodeName;

    public ClusterTopologyChangeMessage_V2(long uniqueEventID, String nodeID, String nodeName, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super((byte)114);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
        this.uniqueEventID = uniqueEventID;
        this.nodeName = nodeName;
    }

    public ClusterTopologyChangeMessage_V2(long uniqueEventID, String nodeID) {
        super((byte)114);
        this.exit = true;
        this.nodeID = nodeID;
        this.uniqueEventID = uniqueEventID;
    }

    public ClusterTopologyChangeMessage_V2() {
        super((byte)114);
    }

    public long getUniqueEventID() {
        return this.uniqueEventID;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeBoolean(this.exit);
        buffer.writeString(this.nodeID);
        buffer.writeNullableString(this.nodeName);
        buffer.writeLong(this.uniqueEventID);
        if (!this.exit) {
            if (this.pair.getA() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getA()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.pair.getB() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getB()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(this.last);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.exit = buffer.readBoolean();
        this.nodeID = buffer.readString();
        this.nodeName = buffer.readNullableString();
        this.uniqueEventID = buffer.readLong();
        if (!this.exit) {
            TransportConfiguration b;
            TransportConfiguration a;
            boolean hasLive = buffer.readBoolean();
            if (hasLive) {
                a = new TransportConfiguration();
                a.decode(buffer);
            } else {
                a = null;
            }
            boolean hasBackup = buffer.readBoolean();
            if (hasBackup) {
                b = new TransportConfiguration();
                b.decode(buffer);
            } else {
                b = null;
            }
            this.pair = new Pair<TransportConfiguration, TransportConfiguration>(a, b);
            this.last = buffer.readBoolean();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exit ? 1231 : 1237);
        result = 31 * result + (this.last ? 1231 : 1237);
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.pair == null ? 0 : this.pair.hashCode());
        result = 31 * result + (int)(this.uniqueEventID ^ this.uniqueEventID >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClusterTopologyChangeMessage_V2)) {
            return false;
        }
        ClusterTopologyChangeMessage_V2 other = (ClusterTopologyChangeMessage_V2)obj;
        if (this.exit != other.exit) {
            return false;
        }
        if (this.last != other.last) {
            return false;
        }
        if (this.nodeID == null ? other.nodeID != null : !this.nodeID.equals(other.nodeID)) {
            return false;
        }
        if (this.pair == null ? other.pair != null : !this.pair.equals(other.pair)) {
            return false;
        }
        return this.uniqueEventID == other.uniqueEventID;
    }
}

