/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;

class HornetQChannelHandler
extends SimpleChannelHandler {
    private final ChannelGroup group;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    volatile boolean active;

    HornetQChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.group.add(e.getChannel());
        ctx.sendUpstream(e);
    }

    @Override
    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.listener.connectionReadyForWrites(e.getChannel().getId(), e.getChannel().isWritable());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        this.handler.bufferReceived(e.getChannel().getId(), new ChannelBufferWrapper(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HornetQChannelHandler hornetQChannelHandler = this;
        synchronized (hornetQChannelHandler) {
            if (this.active) {
                this.listener.connectionDestroyed(e.getChannel().getId());
                this.active = false;
            }
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.active) {
            return;
        }
        HornetQInternalErrorException me = HornetQMessageBundle.BUNDLE.nettyError();
        me.initCause(e.getCause());
        ConnectionLifeCycleListener connectionLifeCycleListener = this.listener;
        synchronized (connectionLifeCycleListener) {
            try {
                this.listener.connectionException(e.getChannel().getId(), me);
                this.active = false;
            }
            catch (Exception ex) {
                HornetQLogger.LOGGER.errorCallingLifeCycleListener(ex);
            }
        }
    }
}

