/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.hornetq.core.remoting.impl.netty.HttpAcceptorHandler;

public class HttpKeepAliveRunnable
implements Runnable {
    private final List<HttpAcceptorHandler> handlers = new ArrayList<HttpAcceptorHandler>();
    private boolean closed = false;
    private Future<?> future;

    @Override
    public synchronized void run() {
        if (this.closed) {
            return;
        }
        long time = System.currentTimeMillis();
        for (HttpAcceptorHandler handler : this.handlers) {
            handler.keepAlive(time);
        }
    }

    public synchronized void registerKeepAliveHandler(HttpAcceptorHandler httpAcceptorHandler) {
        this.handlers.add(httpAcceptorHandler);
    }

    public synchronized void unregisterKeepAliveHandler(HttpAcceptorHandler httpAcceptorHandler) {
        this.handlers.remove(httpAcceptorHandler);
    }

    public void close() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.closed = true;
    }

    public synchronized void setFuture(Future<?> future) {
        this.future = future;
    }
}

