/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.File;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.ClusterConnectionImpl;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.utils.FutureLatch;
import org.hornetq.utils.Pair;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jboss.netty.channel.Channel;
import org.w3c.dom.Node;

@MessageLogger(projectCode="HQ")
public interface HornetQLogger
extends BasicLogger {
    public static final HornetQLogger LOGGER = Logger.getMessageLogger(HornetQLogger.class, HornetQLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111001, value="{0} server is starting with configuration {1}", format=Message.Format.MESSAGE_FORMAT)
    public void serverStarting(String var1, Configuration var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111002, value="{0} is already started, ignoring the call to start..", format=Message.Format.MESSAGE_FORMAT)
    public void serverAlreadyStarted(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111003, value="HornetQ Server version {0} [{1}] {2}", format=Message.Format.MESSAGE_FORMAT)
    public void serverStarted(String var1, SimpleString var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111004, value="HornetQ Server version {0} [{1}] stopped", format=Message.Format.MESSAGE_FORMAT)
    public void serverStopped(String var1, SimpleString var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111005, value="trying to deploy queue {0}", format=Message.Format.MESSAGE_FORMAT)
    public void deployQueue(SimpleString var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111006, value="{0}", format=Message.Format.MESSAGE_FORMAT)
    public void dumpServerInfo(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111007, value="Deleting pending large message as it was not completed: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void deletingPendingMessage(Pair<Long, Long> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111008, value="Waiting to obtain live lock", format=Message.Format.MESSAGE_FORMAT)
    public void awaitingLiveLock();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111009, value="Server is now live", format=Message.Format.MESSAGE_FORMAT)
    public void serverIsLive();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111010, value="live server wants to restart, restarting server in backup", format=Message.Format.MESSAGE_FORMAT)
    public void awaitFailBack();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1111, value="HornetQ Backup Server version {0} [{1}] started, waiting live to fail before it gets active", format=Message.Format.MESSAGE_FORMAT)
    public void backupServerStarted(String var1, SimpleString var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111012, value="Backup Server is now live", format=Message.Format.MESSAGE_FORMAT)
    public void backupServerIsLive();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111013, value="Server {0} is now live", format=Message.Format.MESSAGE_FORMAT)
    public void serverIsLive(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111014, value="**** Dumping session creation stacks ****", format=Message.Format.MESSAGE_FORMAT)
    public void dumpingSessionStacks();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111015, value="session created", format=Message.Format.MESSAGE_FORMAT)
    public void dumpingSessionStack(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111016, value="Using AIO Journal", format=Message.Format.MESSAGE_FORMAT)
    public void journalUseAIO();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111017, value="Using NIO Journal", format=Message.Format.MESSAGE_FORMAT)
    public void journalUseNIO();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111018, value="{0}% loaded", format=Message.Format.MESSAGE_FORMAT)
    public void percentLoaded(Long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111019, value="Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR, deleting record now", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueReloading(Long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111020, value="Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueReloadingPage(Long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111021, value="Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueReloadingPageCursor(Long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111022, value="Large message: {0} did not have any associated reference, file will be deleted", format=Message.Format.MESSAGE_FORMAT)
    public void largeMessageWithNoRef(Long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111023, value="Deleting unreferenced message id={0} from the journal", format=Message.Format.MESSAGE_FORMAT)
    public void journalUnreferencedMessage(Long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111024, value="Started Netty Acceptor version {0} {1}:{2} for {3} protocol", format=Message.Format.MESSAGE_FORMAT)
    public void startedNettyAcceptor(String var1, String var2, Integer var3, ProtocolType var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111025, value="failed to remove connection", format=Message.Format.MESSAGE_FORMAT)
    public void errorRemovingConnection();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111026, value="unable to start connector service: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingConnectorService(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111027, value="unable to stop connector service: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingConnectorService(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111028, value="Backup server {0} is synchronized with live-server.", format=Message.Format.MESSAGE_FORMAT)
    public void backupServerSynched(HornetQServerImpl var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111029, value="replication Journal {0}. Reserving fileIDs for synchronization: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void reservingFileIDs(JournalStorageManager.JournalContent var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111030, value="Replication: sending {0} (size={1}) to backup. {2}", format=Message.Format.MESSAGE_FORMAT)
    public void journalSynch(JournalFile var1, Long var2, SequentialFile var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111031, value="Bridge {0} connected to fowardingAddress={1}. {2} does not have any bindings what means messages will be ignored until a binding is created.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNoBindings(SimpleString var1, SimpleString var2, SimpleString var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111032, value="Bridge {0} is connected", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeConnected(BridgeImpl var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111033, value="Bridge is stopping, will not retry", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeStopping();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111034, value="stopped bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeStopped(SimpleString var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111035, value="paused bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void bridgePaused(SimpleString var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111036, value="backup announced", format=Message.Format.MESSAGE_FORMAT)
    public void backupAnnounced();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111037, value="Waiting to become backup node", format=Message.Format.MESSAGE_FORMAT)
    public void waitingToBecomeBackup();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111038, value="** got backup lock", format=Message.Format.MESSAGE_FORMAT)
    public void gotBackupLock();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111039, value="Waiting to obtain live lock", format=Message.Format.MESSAGE_FORMAT)
    public void waitingToObtainLiveLock();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111040, value="Live Server Obtained live lock", format=Message.Format.MESSAGE_FORMAT)
    public void obtainedLiveLock();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111041, value="Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored and message removed from {3}", format=Message.Format.MESSAGE_FORMAT)
    public void messageWithDuplicateID(Object var1, SimpleString var2, SimpleString var3, SimpleString var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111042, value="Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored", format=Message.Format.MESSAGE_FORMAT)
    public void messageWithDuplicateID(Object var1, SimpleString var2, SimpleString var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111043, value="ignoring prepare on xid as already called :{0}", format=Message.Format.MESSAGE_FORMAT)
    public void ignoringPrepare(Xid var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111044, value="{0} to become 'live'", format=Message.Format.MESSAGE_FORMAT)
    public void becomingLive(HornetQServer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111045, value="Configuration option {0} is deprecated. Consult the manual for details.", format=Message.Format.MESSAGE_FORMAT)
    public void deprecatedConfigurationOption(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112001, value="HornetQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope", format=Message.Format.MESSAGE_FORMAT)
    public void serverFinalisedWIthoutBeingSTopped();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112002, value="Error closing sessions while stopping server", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingSessionsWhileStoppingServer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112003, value="Timed out waiting for pool to terminate {0}. Interrupting all its threads!", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutStoppingThreadpool(ExecutorService var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112004, value="Must specify a name for each divert. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void divertWithNoName();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112005, value="Must specify an address for each divert. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void divertWithNoAddress();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112006, value="Must specify a forwarding address for each divert. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void divertWithNoForwardingAddress();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112007, value="Binding already exists with name {0}, divert will not be deployed", format=Message.Format.MESSAGE_FORMAT)
    public void divertBindingNotExists(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112008, value="Security risk! HornetQ is running with the default cluster admin user and default password. Please see the HornetQ user guide, cluster chapter, for instructions on how to change this.", format=Message.Format.MESSAGE_FORMAT)
    public void clusterSecurityRisk();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112009, value="unable to restart server, please kill and restart manually", format=Message.Format.MESSAGE_FORMAT)
    public void serverRestartWarning();

    @LogMessage(level=Logger.Level.WARN)
    public void serverRestartWarning(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112010, value="Unable to announce backup for replication. Trying to stop the server.", format=Message.Format.MESSAGE_FORMAT)
    public void replicationStartProblem(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112011, value="Critical IO Error, shutting down the server. code={0}, message={1}", format=Message.Format.MESSAGE_FORMAT)
    public void ioErrorShutdownServer(HornetQExceptionType var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112012, value="Error stopping server", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingServer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112013, value="Timed out waiting for backup activation to exit", format=Message.Format.MESSAGE_FORMAT)
    public void backupActivationProblem();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112014, value="Error when trying to start replication", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingReplication(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112015, value="Error when trying to stop replication", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingReplication(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112016, value="{0}", format=Message.Format.MESSAGE_FORMAT)
    public void warn(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112017, value="Error on clearing messages", format=Message.Format.MESSAGE_FORMAT)
    public void errorClearingMessages(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112018, value="Timed out waiting for handler to complete processing", format=Message.Format.MESSAGE_FORMAT)
    public void timeOutWaitingForProcessing();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112019, value="Unable to close session", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCloseSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112020, value="Failed to connect to server.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToConnectToServer();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112021, value="Tried {0} times to connect. Now giving up on reconnecting it.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToConnectToServer(Integer var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112022, value="Waiting {0} milliseconds before next retry. RetryInterval={1} and multiplier={2}", format=Message.Format.MESSAGE_FORMAT)
    public void waitingForRetry(Long var1, Long var2, Double var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112023, value="connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.", format=Message.Format.MESSAGE_FORMAT)
    public void createConnectorException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112024, value="I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void factoryLeftOpen(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112025, value="resetting session after failure", format=Message.Format.MESSAGE_FORMAT)
    public void resettingSessionAfterFailure();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112026, value="Server is starting, retry to create the session {0}", format=Message.Format.MESSAGE_FORMAT)
    public void retryCreateSessionSeverStarting(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112027, value="committing transaction after failover occurred, any non persistent messages may be lost", format=Message.Format.MESSAGE_FORMAT)
    public void commitAfterFailover();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112028, value="failover occured during commit throwing XAException.XA_RETRY", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringCommit();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112029, value="failover occurred during prepare re-trying", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringPrepare();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112030, value="failover occurred during prepare rolling back", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringPrepareRollingBack();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112031, value="failover occurred during prepare rolling back", format=Message.Format.MESSAGE_FORMAT)
    public void errorDuringPrepare(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112032, value="I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void clientSessionNotClosed(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112033, value="error adding packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorAddingPacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112034, value="error calling cancel", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingCancel(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112035, value="error reading index", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112036, value="error setting index", format=Message.Format.MESSAGE_FORMAT)
    public void errorSettingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112037, value="error resetting index", format=Message.Format.MESSAGE_FORMAT)
    public void errorReSettingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112038, value="error reading LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112039, value="error closing LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112040, value="Exception during finalization for LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorFinalisingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112041, value="did not connect the cluster connection to other nodes", format=Message.Format.MESSAGE_FORMAT)
    public void errorConnectingToNodes(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112042, value="Timed out waiting for pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingForTermination();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112043, value="Timed out waiting for scheduled pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingForScheduledPoolTermination();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112044, value="error starting server locator", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingLocator(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112045, value="Closing a Server Locator left open. Please make sure you close all Server Locators explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void serverLocatorNotClosed(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112046, value="error sending topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingTopology(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112047, value="error sending topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingTopologyNodedown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112048, value="Timed out waiting to stop discovery thread", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutStoppingDiscovery();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112049, value="unable to send notification when discovery group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingNotifOnDiscoveryStop(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112050, value="There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node. nodeID={0}", format=Message.Format.MESSAGE_FORMAT)
    public void multipleServersBroadcastingSameNode(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112051, value="error receiving packet in discovery", format=Message.Format.MESSAGE_FORMAT)
    public void errorReceivingPAcketInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112052, value="Cannot deploy a connector with no name specified.", format=Message.Format.MESSAGE_FORMAT)
    public void connectorWithNoName();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112053, value="There is already a connector with name {0} deployed. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void connectorAlreadyDeployed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112054, value="AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal", format=Message.Format.MESSAGE_FORMAT)
    public void AIONotFound();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112055, value="There is already a discovery group with name {0} deployed. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void discoveryGroupAlreadyDeployed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112056, value="error scanning for URL's", format=Message.Format.MESSAGE_FORMAT)
    public void errorScanningURLs(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112057, value="problem undeploying {0}", format=Message.Format.MESSAGE_FORMAT)
    public void problemUndeployingNode(@Cause Exception var1, Node var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112058, value="Timed out waiting for paging cursor to stop {0} {1}", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutStoppingPagingCursor(FutureLatch var1, Executor var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112059, value="Timed out flushing executors for paging cursor to stop {0} {1}", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutFlushingExecutorsPagingCursor(FutureLatch var1, Executor var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112060, value="problem cleaning page address {0}", format=Message.Format.MESSAGE_FORMAT)
    public void problemCleaningPageAddress(@Cause Exception var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112061, value="Could not complete operations on IO context {0}", format=Message.Format.MESSAGE_FORMAT)
    public void problemCompletingOperations(OperationContext var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112062, value="Problem cleaning page subscription counter", format=Message.Format.MESSAGE_FORMAT)
    public void problemCleaningPagesubscriptionCounter(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112063, value="Error on cleaning up cursor pages", format=Message.Format.MESSAGE_FORMAT)
    public void problemCleaningCursorPages(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112064, value="Could not remove page {0} from consumed pages on cursor for address {1}", format=Message.Format.MESSAGE_FORMAT)
    public void problemRemovingCursorPages(Long var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112065, value="Timed out flushing executors for paging cursor to stop {0}", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutFlushingExecutorsPagingCursor(PageSubscription var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112066, value="Could not find page cache for page {0} removing it from the journal", format=Message.Format.MESSAGE_FORMAT)
    public void pageNotFound(PagePosition var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112067, value="Could not locate page transaction {0}, ignoring message on position {1} on address={2} queue={3}", format=Message.Format.MESSAGE_FORMAT)
    public void pageSubscriptionCouldntLoad(long var1, PagePosition var3, SimpleString var4, SimpleString var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112068, value="File {0} being renamed to {1}.invalidPage as it was loaded partially. Please verify your data.", format=Message.Format.MESSAGE_FORMAT)
    public void pageInvalid(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112069, value="Error while deleting page file", format=Message.Format.MESSAGE_FORMAT)
    public void pageDeleteError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112070, value="page finalise error", format=Message.Format.MESSAGE_FORMAT)
    public void pageFinaliseError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112071, value="Page file had incomplete records at position {0} at record number {1}", format=Message.Format.MESSAGE_FORMAT)
    public void pageSuspectFile(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112072, value="Can not delete page transaction id={0}", format=Message.Format.MESSAGE_FORMAT)
    public void pageTxDeleteError(@Cause Exception var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112073, value="Directory {0} did not have an identification file {1}", format=Message.Format.MESSAGE_FORMAT)
    public void pageStoreFactoryNoIdFile(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112074, value="Timed out on waiting PagingStore {0} to shutdown", format=Message.Format.MESSAGE_FORMAT)
    public void pageStoreTimeout(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112075, value="IO Error, impossible to start paging", format=Message.Format.MESSAGE_FORMAT)
    public void pageStoreStartIOError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112076, value="Starting paging on {0}, size = {1}, maxSize={2}", format=Message.Format.MESSAGE_FORMAT)
    public void pageStoreStart(SimpleString var1, long var2, long var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112077, value="Messages are being dropped on address {0}", format=Message.Format.MESSAGE_FORMAT)
    public void pageStoreDropMessages(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112078, value="Server is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void serverIsStopped();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112079, value="Cannot find queue {0} to update delivery count", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueDelCount(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112080, value="Cannot find message {0} to update delivery count", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindMessageDelCount(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112081, value="Message for queue {0} which does not exist. This message will be ignored.", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueForMessage(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112082, value="It was not possible to delete message {0}", format=Message.Format.MESSAGE_FORMAT)
    public void journalErrorDeletingMessage(@Cause Exception var1, Long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112083, value="Message in prepared tx for queue {0} which does not exist. This message will be ignored.", format=Message.Format.MESSAGE_FORMAT)
    public void journalMessageInPreparedTX(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112084, value="Failed to remove reference for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void journalErrorRemovingRef(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112085, value="Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueReloadingACK(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112086, value="PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, invalid state", format=Message.Format.MESSAGE_FORMAT)
    public void journalPAGEOnPrepared();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112087, value="InternalError: Record type {0} not recognized. Maybe you are using journal files created on a different version", format=Message.Format.MESSAGE_FORMAT)
    public void journalInvalidRecordType(Byte var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112088, value="Can not locate recordType={0} on loadPreparedTransaction//deleteRecords", format=Message.Format.MESSAGE_FORMAT)
    public void journalInvalidRecordTypeOnPreparedTX(Byte var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112089, value="Journal Error", format=Message.Format.MESSAGE_FORMAT)
    public void journalError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112090, value="error incrementing delay detection", format=Message.Format.MESSAGE_FORMAT)
    public void errorIncrementDelayDeletionCount(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112091, value="Error on copying large message {0} for DLA or Expiry", format=Message.Format.MESSAGE_FORMAT)
    public void lareMessageErrorCopying(@Cause Exception var1, LargeServerMessage var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112092, value="Error on executing IOAsyncTask", format=Message.Format.MESSAGE_FORMAT)
    public void errorExecutingIOAsyncTask(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112093, value="Error on deleting duplicate cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeletingDuplicateCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112094, value="Reaper thread being restarted", format=Message.Format.MESSAGE_FORMAT)
    public void reaperRestarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112095, value="Did not route to any bindings for address {0} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.", format=Message.Format.MESSAGE_FORMAT)
    public void noDLA(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112096, value="It was not possible to add references due to an IO error code {0} message = {1}", format=Message.Format.MESSAGE_FORMAT)
    public void ioErrorAddingReferences(Integer var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112097, value="Duplicate message detected through the bridge - message will not be routed. Message information:\n{0}", format=Message.Format.MESSAGE_FORMAT)
    public void duplicateMessageDetectedThruBridge(ServerMessage var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112098, value="Duplicate message detected - message will not be routed. Message information:\n{0}", format=Message.Format.MESSAGE_FORMAT)
    public void duplicateMessageDetected(ServerMessage var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112099, value="Error while confirming large message completion on rollback for recordID={0}", format=Message.Format.MESSAGE_FORMAT)
    public void journalErrorConfirmingLargeMessage(@Cause Throwable var1, Long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112100, value="Client connection failed, clearing up resources for session {0}", format=Message.Format.MESSAGE_FORMAT)
    public void clientConnectionFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112101, value="Cleared up resources for session {0}", format=Message.Format.MESSAGE_FORMAT)
    public void clearingUpSession(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112102, value="Error processing IOCallback code = {0} message = {1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorProcessingIOCallback(Integer var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112103, value="Can not find packet to clear: {0} last received command id first stored command id {1}", format=Message.Format.MESSAGE_FORMAT)
    public void cannotFindPacketToClear(Integer var1, Integer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112104, value="Client with version {0} and address {1} is not compatible with server version {2}. Please ensure all clients and servers are upgraded to the same version for them to interoperate properly", format=Message.Format.MESSAGE_FORMAT)
    public void incompatibleVersion(Integer var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112105, value="Client is not being consistent on the request versioning. It just sent a version id={0} while it informed {1} previously", format=Message.Format.MESSAGE_FORMAT)
    public void incompatibleVersionAfterConnect(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112106, value="Reattach request from {0} failed as there is no confirmationWindowSize configured, which may be ok for your system", format=Message.Format.MESSAGE_FORMAT)
    public void reattachRequestFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112107, value="Connection failure has been detected: {0} [code={1}]", format=Message.Format.MESSAGE_FORMAT)
    public void connectionFailureDetected(String var1, HornetQExceptionType var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112108, value="Failure in calling interceptor: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingInterceptor(@Cause Throwable var1, Interceptor var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112109, value="connection closed {0}", format=Message.Format.MESSAGE_FORMAT)
    public void connectionClosed(StompConnection var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112110, value="error cleaning up stomp connection", format=Message.Format.MESSAGE_FORMAT)
    public void errorCleaningStompConn(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112111, value="Stomp Transactional acknowledgement is not supported", format=Message.Format.MESSAGE_FORMAT)
    public void stompTXAckNorSupported();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112112, value="Interrupted while waiting for stomp heart beate to die", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnStompHeartBeat(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112113, value="Timed out flushing channel on InVMConnection", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutFlushingInvmChannel();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112114, value="Unexpected Netty Version was expecting {0} using {1} Version.ID", format=Message.Format.MESSAGE_FORMAT)
    public void unexpectedNettyVersion(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112115, value="channel group did not completely close", format=Message.Format.MESSAGE_FORMAT)
    public void nettyChannelGroupError();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112116, value="{0} is still connected to {1}", format=Message.Format.MESSAGE_FORMAT)
    public void nettyChannelStillOpen(Channel var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112117, value="channel group did not completely unbind", format=Message.Format.MESSAGE_FORMAT)
    public void nettyChannelGroupBindError();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112118, value="{0} is still bound to {1}", format=Message.Format.MESSAGE_FORMAT)
    public void nettyChannelStillBound(Channel var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112119, value="Timed out waiting for netty ssl close future to complete", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutClosingSSL();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112120, value="Timed out waiting for netty channel to close", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutClosingNettyChannel();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112121, value="Timed out waiting for packet to be flushed", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutFlushingPacket();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112122, value="Error instantiating remoting interceptor {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingRemotingInterceptor(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112123, value="The following keys are invalid for configuring the acceptor: {0} the acceptor will not be started.", format=Message.Format.MESSAGE_FORMAT)
    public void invalidAcceptorKeys(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112124, value="Error instantiating remoting acceptor {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingAcceptor(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112125, value="Timed out waiting for remoting thread pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutRemotingThreadPool();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112126, value="error on connection failure check", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnFailureCheck(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112127, value="The following keys are invalid for configuring the connector service: {0} the connector will not be started.", format=Message.Format.MESSAGE_FORMAT)
    public void connectorKeysInvalid(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112128, value="The following keys are required for configuring the connector service: {0} the connector will not be started.", format=Message.Format.MESSAGE_FORMAT)
    public void connectorKeysMissing(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112129, value="Packet {0} can not be processed by the ReplicationEndpoint", format=Message.Format.MESSAGE_FORMAT)
    public void invalidPacketForReplication(Packet var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112130, value="error handling packet {0} for replication", format=Message.Format.MESSAGE_FORMAT)
    public void errorHandlingReplicationPacket(@Cause Exception var1, Packet var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112131, value="Replication Error while closing the page on backup", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingPageOnReplication(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112132, value="Journal comparison mismatch:\n{0}", format=Message.Format.MESSAGE_FORMAT)
    public void journalcomparisonMismatch(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112133, value="Replication Error deleting large message ID = {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeletingLargeMessage(@Cause Exception var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112134, value="Replication Large MessageID {0}  is not available on backup server. Ignoring replication message", format=Message.Format.MESSAGE_FORMAT)
    public void largeMessageNotAvailable(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112135, value="Error completing callback on replication manager", format=Message.Format.MESSAGE_FORMAT)
    public void errorCompletingReplicationCallback(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112136, value="The backup node has been shut-down, replication will now stop", format=Message.Format.MESSAGE_FORMAT)
    public void replicationStopOnBackupShutdown();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112137, value="Connection to the backup node failed, removing replication now", format=Message.Format.MESSAGE_FORMAT)
    public void replicationStopOnBackupFail(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112138, value="Timed out waiting to stop Bridge", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingToStopBridge();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112139, value="Bridge unable to send notification when broadcast group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNotificationOnGroupStopped(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112140, value="Bridge unable to send message {0}, will try again once bridge reconnects", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeUnableToSendMessage(@Cause Exception var1, MessageReference var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112141, value="Connection failed with failedOver={1}", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeConnectionFailed(@Cause Exception var1, Boolean var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112142, value="Error on querying binding on bridge {0}. Retrying in 100 milliseconds", format=Message.Format.MESSAGE_FORMAT)
    public void errorQueryingBridge(@Cause Throwable var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112143, value="Address {0} does not have any bindings yet, retry #({1})", format=Message.Format.MESSAGE_FORMAT)
    public void errorQueryingBridge(SimpleString var1, Integer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112144, value="Server is starting, retry to create the session for bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingBridge(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112145, value="Bridge {0} is unable to connect to destination. It will be disabled.", format=Message.Format.MESSAGE_FORMAT)
    public void errorConnectingBridge(@Cause Exception var1, Bridge var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112146, value="ServerLocator was shutdown, can not retry on opening connection for bridge", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeLocatorShutdown();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112147, value="Bridge {0} achieved {1} maxattempts={2} it will stop retrying to reconnect", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeAbortStart(SimpleString var1, Integer var2, Integer var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112148, value="Unexpected exception while trying to reconnect", format=Message.Format.MESSAGE_FORMAT)
    public void errorReConnecting(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112149, value="transaction with xid {0} timed out", format=Message.Format.MESSAGE_FORMAT)
    public void unexpectedXid(Xid var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112150, value="IO Error completing the transaction, code = {0}, message = {1}", format=Message.Format.MESSAGE_FORMAT)
    public void ioErrorOnTX(Integer var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112151, value="Property {0} must be an Integer, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotInteger(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112152, value="Property {0} must be an Long, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotLong(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112153, value="Property {0} must be an Boolean, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotBoolean(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112154, value="Cannot find hornetq-version.properties on classpath: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void noVersionOnClasspath(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112155, value="Warning: JVM allocated more data what would make results invalid {0}:{1}", format=Message.Format.MESSAGE_FORMAT)
    public void jvmAllocatedMoreMemory(Long var1, Long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112156, value="Could not finish context execution in 10 seconds", format=Message.Format.MESSAGE_FORMAT)
    public void errorCompletingContext(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112157, value="Replacing incomplete LargeMessage with ID={0}", format=Message.Format.MESSAGE_FORMAT)
    public void replacingIncompleteLargeMessage(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112158, value="Cleared up resources for session {0}", format=Message.Format.MESSAGE_FORMAT)
    public void clientConnectionFailedClearingSession(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112159, value="local-bind-address specified for broadcast group but no local-bind-port specified so socket will NOT be bound to a local address/port", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupBindError();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112160, value="unable to send notification when broadcast group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupClosed(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112161, value="NodeID={0} is not available on the topology. Retrying the connection to that node now", format=Message.Format.MESSAGE_FORMAT)
    public void nodeNotAvailable(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112162, value="no queue IDs defined!,  originalMessage  = {0}, copiedMessage = {1}, props={2}", format=Message.Format.MESSAGE_FORMAT)
    public void noQueueIdDefined(ServerMessage var1, ServerMessage var2, SimpleString var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112163, value="exception while invoking {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public void managementOperationError(@Cause Exception var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112164, value="exception while retrieving attribute {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public void managementAttributeError(@Cause Exception var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112165, value="On ManagementService stop, there are {0} unexpected registered MBeans: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void managementStopError(Integer var1, List<String> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112166, value="Unable to delete group binding info {0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToDeleteGroupBindings(@Cause Exception var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112167, value="Error closing serverLocator={0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingServerLocator(@Cause Exception var1, ServerLocatorInternal var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112168, value="unable to start broadcast group {0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToStartBroadcastGroup(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112169, value="unable to start cluster connection {0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToStartClusterConnection(@Cause Exception var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112170, value="unable to start Bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToStartBridge(@Cause Exception var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112171, value="No connector with name '{0}'. backup cannot be announced.", format=Message.Format.MESSAGE_FORMAT)
    public void announceBackupNoConnector(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112172, value="no cluster connections defined, unable to announce backup", format=Message.Format.MESSAGE_FORMAT)
    public void announceBackupNoClusterConnections();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112173, value="Must specify a unique name for each bridge. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNotUnique();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112174, value="Must specify a queue name for each bridge. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNoQueue();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112175, value="Bridge Forward address is not specified. Will use original message address instead", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNoForwardAddress();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112176, value="There is already a bridge with name {0} deployed. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeAlreadyDeployed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112177, value="No queue found with name {0} bridge will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNoQueue(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112178, value="No discovery group found with name {0} bridge will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNoDiscoveryGroup(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112179, value="Must specify a unique name for each cluster connection. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void clusterConnectionNotUnique();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112180, value="Must specify an address for each cluster connection. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void clusterConnectionNoForwardAddress();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112181, value="No connector with name '{0}'. The cluster connection will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void clusterConnectionNoConnector(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112182, value="Cluster Configuration  '{0}' already exists. The cluster connection will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void clusterConnectionAlreadyExists(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112183, value="No discovery group with name '{0}'. The cluster connection will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void clusterConnectionNoDiscoveryGroup(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112184, value="There is already a broadcast-group with name {0} deployed. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupAlreadyExists(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112185, value="There is no connector deployed with name '{0}'. The broadcast group with name '{1}' will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupNoConnector(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112186, value="No connector defined with name '{0}'. The bridge will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNoConnector(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112187, value="Stopping Redistributor, Timed out waiting for tasks to complete", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingRedistributor();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112188, value="IO Error during redistribution, errorCode = {0} message = {1}", format=Message.Format.MESSAGE_FORMAT)
    public void ioErrorRedistributing(Integer var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112189, value="Unable to announce backup, retrying", format=Message.Format.MESSAGE_FORMAT)
    public void errorAnnouncingBackup(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112190, value="Local Member is not set at on ClusterConnection {0}", format=Message.Format.MESSAGE_FORMAT)
    public void noLocalMemborOnClusterConnection(ClusterConnectionImpl var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112191, value="{0}::Remote queue binding {1} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses", format=Message.Format.MESSAGE_FORMAT)
    public void remoteQueueAlreadyBoundOnClusterConnection(Object var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112192, value="problem closing backup session factory for cluster connection", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingBackupFactoryOnClusterConnection(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112193, value="Node Manager can not open file {0}", format=Message.Format.MESSAGE_FORMAT)
    public void nodeManagerCantOpenFile(@Cause Exception var1, File var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112194, value="Error on resetting large message deliver - {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorResttingLargeMessage(@Cause Throwable var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112195, value="Timed out waiting for executor to complete", format=Message.Format.MESSAGE_FORMAT)
    public void errorTransferringConsumer();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112196, value="Queue could not finish waiting executors. Try increasing the thread pool size", format=Message.Format.MESSAGE_FORMAT)
    public void errorFlushingExecutorsOnQueue();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112197, value="Error expiring reference {0} 0n queue", format=Message.Format.MESSAGE_FORMAT)
    public void errorExpiringReferencesOnQueue(@Cause Exception var1, MessageReference var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112198, value="Message has expired. No bindings for Expiry Address {0} so dropping it", format=Message.Format.MESSAGE_FORMAT)
    public void errorExpiringReferencesNoBindings(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112199, value="Message has expired. No expiry queue configured for queue {0} so dropping it", format=Message.Format.MESSAGE_FORMAT)
    public void errorExpiringReferencesNoQueue(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112200, value="Message {0} has exceeded max delivery attempts. No bindings for Dead Letter Address {1} so dropping it", format=Message.Format.MESSAGE_FORMAT)
    public void messageExceededMaxDelivery(MessageReference var1, SimpleString var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112201, value="Message {0} has reached maximum delivery attempts, sending it to Dead Letter Address {1} from {2}", format=Message.Format.MESSAGE_FORMAT)
    public void messageExceededMaxDeliverySendtoDLA(MessageReference var1, SimpleString var2, SimpleString var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112202, value="Message has exceeded max delivery attempts. No Dead Letter Address configured for queue {0} so dropping it", format=Message.Format.MESSAGE_FORMAT)
    public void messageExceededMaxDeliveryNoDLA(SimpleString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112203, value="removing consumer which did not handle a message, consumer={0}, message={1}", format=Message.Format.MESSAGE_FORMAT)
    public void removingBadConsumer(@Cause Throwable var1, Consumer var2, MessageReference var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112204, value="Unable to decrement reference counting on queue", format=Message.Format.MESSAGE_FORMAT)
    public void errorDecrementingRefCount(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112205, value="Unable to remove message id = {0} please remove manually", format=Message.Format.MESSAGE_FORMAT)
    public void errorRemovingMessage(@Cause Throwable var1, Long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112206, value="Error checking DLQ", format=Message.Format.MESSAGE_FORMAT)
    public void errorCheckingDLQ(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112207, value="Failed to register as backup. Stopping the server.", format=Message.Format.MESSAGE_FORMAT)
    public void errorRegisteringBackup();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112208, value="Less than {0}%\n{1}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)", format=Message.Format.MESSAGE_FORMAT)
    public void memoryError(Integer var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112209, value="Error completing callback on replication manager", format=Message.Format.MESSAGE_FORMAT)
    public void errorCompletingCallbackOnReplicationManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112210, value="{0} backup activation thread did not finish.", format=Message.Format.MESSAGE_FORMAT)
    public void backupActivationDidntFinish(HornetQServer var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112211, value="unable to send notification when broadcast group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastBridgeStoppedError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112212, value="unable to send notification when broadcast group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void notificationBridgeStoppedError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112213, value="Could not bind to {0} ({1} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.", format=Message.Format.MESSAGE_FORMAT)
    public void ioDiscoveryError(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112214, value="Group Handler timed-out waiting for sendCondition", format=Message.Format.MESSAGE_FORMAT)
    public void groupHandlerSendTimeout();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112215, value="Compressed large message tried to read {0} bytes from stream {1}", format=Message.Format.MESSAGE_FORMAT)
    public void compressedLargeMessageError(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112216, value="Moving data directory {0} to {1}", format=Message.Format.MESSAGE_FORMAT)
    public void backupMovingDataAway(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112217, value="Error when trying to start replication {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingReplication(BackupReplicationStartFailedMessage.BackupRegistrationProblem var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114001, value="Failed to call onMessage", format=Message.Format.MESSAGE_FORMAT)
    public void onMessageError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114002, value="Failure in initialisation", format=Message.Format.MESSAGE_FORMAT)
    public void initializationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114003, value="failed to cleanup session", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCleanupSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114004, value="Failed to execute failure listener", format=Message.Format.MESSAGE_FORMAT)
    public void failedToExecuteListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114005, value="Failed to handle failover", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandleFailover(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114006, value="XA end operation failed ", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingEnd(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114007, value="XA start operation failed {0} code:{1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingStart(String var1, Integer var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114008, value="Session is not XA", format=Message.Format.MESSAGE_FORMAT)
    public void sessionNotXA();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114009, value="Received exception asynchronously from server", format=Message.Format.MESSAGE_FORMAT)
    public void receivedExceptionAsynchronously(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114010, value="Failed to handle packet", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandlePacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114011, value="Failed to stop discovery group", format=Message.Format.MESSAGE_FORMAT)
    public void failedToStopDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114012, value="Failed to start discovery group", format=Message.Format.MESSAGE_FORMAT)
    public void failedToStartDiscovery(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114013, value="Failed to receive datagram", format=Message.Format.MESSAGE_FORMAT)
    public void failedToReceiveDatagramInDiscovery(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114014, value="Failed to call discovery listener", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCallListenerInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114015, value="Error deploying URI {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeployingURI(@Cause Throwable var1, URI var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114016, value="Error deploying URI", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeployingURI(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114017, value="Error undeploying URI {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorUnDeployingURI(@Cause Throwable var1, URI var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114018, value="key attribute missing for configuration {0}", format=Message.Format.MESSAGE_FORMAT)
    public void keyAttributeMissing(Node var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114019, value="Unable to deply node {0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToDeployNode(@Cause Exception var1, Node var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114020, value="Invalid filter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidFilter(@Cause Throwable var1, SimpleString var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114021, value="page subscription = {0} error={1}", format=Message.Format.MESSAGE_FORMAT)
    public void pageSubscriptionError(IOAsyncTask var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114022, value="Failed to store id", format=Message.Format.MESSAGE_FORMAT)
    public void batchingIdError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114023, value="Cannot find message {0}", format=Message.Format.MESSAGE_FORMAT)
    public void cannotFindMessage(Long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114024, value="Cannot find queue messages for queueID={0} on ack for messageID={1}", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueue(Long var1, Long var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114025, value="Cannot find queue messages {0} for message {1} while processing scheduled messages", format=Message.Format.MESSAGE_FORMAT)
    public void journalCannotFindQueueScheduled(Long var1, Long var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114026, value="error releasing resources", format=Message.Format.MESSAGE_FORMAT)
    public void largeMessageErrorReleasingResources(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114027, value="failed to expire messages for queue", format=Message.Format.MESSAGE_FORMAT)
    public void errorExpiringMessages(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114028, value="Failed to close session", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114029, value="Caught XA exception", format=Message.Format.MESSAGE_FORMAT)
    public void caughtXaException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114030, value="Caught exception", format=Message.Format.MESSAGE_FORMAT)
    public void caughtException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114031, value="Invalid packet {0}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidPacket(Packet var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114032, value="Failed to create session", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCreateSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114033, value="Failed to reattach session", format=Message.Format.MESSAGE_FORMAT)
    public void failedToReattachSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114034, value="Failed to handle create queue", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandleCreateQueue(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114035, value="Unexpected error handling packet {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorHandlingPacket(@Cause Throwable var1, Packet var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114036, value="Failed to decode packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorDecodingPacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114037, value="Failed to execute failure listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingFailureListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114038, value="Unable to send frame {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingFrame(@Cause Exception var1, StompFrame var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114039, value="Stomp Error, tx already exist! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void stompErrorTXExists(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114040, value="Error encoding stomp packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorEncodingStompPacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114041, value="Cannot create stomp ping frame due to encoding problem.", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnStompPingFrame(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114042, value="Failed to write to handler on invm connector {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorWritingToInvmConnector(@Cause Exception var1, Runnable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114043, value="error flushing invm channel", format=Message.Format.MESSAGE_FORMAT)
    public void errorflushingInvmChannel(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114044, value="Failed to execute connection life cycle listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingLifeCycleListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114045, value="Failed to create netty connection", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingNettyConnection(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114046, value="Failed to stop acceptor", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingAcceptor();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114047, value="large message sync: largeMessage instance is incompatible with it, ignoring data", format=Message.Format.MESSAGE_FORMAT)
    public void largeMessageIncomatible();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114048, value="Could not cancel reference {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCancellingRefOnBridge(@Cause Exception var1, MessageReference var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114049, value="Failed to ack on Bridge", format=Message.Format.MESSAGE_FORMAT)
    public void failedToAckOnBridge(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114050, value="-------------------------------Stomp begin tx: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void stompBeginTX(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114052, value="Failed to stop bridge", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingBridge(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114053, value="Failed to pause bridge", format=Message.Format.MESSAGE_FORMAT)
    public void errorPausingBridge(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114054, value="Failed to broadcast connector configs", format=Message.Format.MESSAGE_FORMAT)
    public void errorBroadcastingConnectorConfigs(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114055, value="Failed to close consumer", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingConsumer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114056, value="Failed to close cluster connection flow record", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingFlowRecord(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114057, value="Failed to update cluster connection topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorUpdatingTopology(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114058, value="cluster connection Failed to handle message", format=Message.Format.MESSAGE_FORMAT)
    public void errorHandlingMessage(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114059, value="Failed to ack old reference", format=Message.Format.MESSAGE_FORMAT)
    public void errorAckingOldReference(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114060, value="Failed to expire message reference", format=Message.Format.MESSAGE_FORMAT)
    public void errorExpiringRef(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114061, value="Failed to remove consumer", format=Message.Format.MESSAGE_FORMAT)
    public void errorRemovingConsumer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114062, value="Failed to deliver", format=Message.Format.MESSAGE_FORMAT)
    public void errorDelivering(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114063, value="Error while restarting the backup server: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorRestartingBackupServer(@Cause Exception var1, HornetQServer var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114064, value="Failed to send forced delivery message", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingForcedDelivery(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114065, value="error acknowledging message", format=Message.Format.MESSAGE_FORMAT)
    public void errorAckingMessage(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114066, value="Failed to run large message deliverer", format=Message.Format.MESSAGE_FORMAT)
    public void errorRunningLargeMessageDeliverer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114067, value="Exception while browser handled from {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorBrowserHandlingMessage(@Cause Exception var1, MessageReference var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114068, value="Failed to delete large message file", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeletingLargeMessageFile(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114069, value="Failed to remove temporary queue {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorRemovingTempQueue(@Cause Exception var1, SimpleString var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114070, value="Cannot find consumer with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public void cannotFindConsumer(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114071, value="Failed to close connection {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingConnection(ServerSessionImpl var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114072, value="Failed to call notification listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingNotifListener(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114073, value="Unable to call Hierarchical Repository Change Listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingRepoListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114074, value="failed to timeout transaction, xid:{0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorTimingOutTX(@Cause Exception var1, Xid var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114075, value="Caught unexpected Throwable", format=Message.Format.MESSAGE_FORMAT)
    public void caughtunexpectedThrowable(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114076, value="Failed to invoke getTextContent() on node {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnXMLTransform(@Cause Throwable var1, Node var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114077, value="Invalid configuration", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnXMLTransformInvalidConf(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114078, value="exception while stopping the replication manager", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingReplicationManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114079, value="Bridge Failed to ack", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeFailedToAck(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114080, value="Live server will not fail-back automatically", format=Message.Format.MESSAGE_FORMAT)
    public void autoFailBackDenied();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114081, value="Exception happened while stopping Discovery BroadcastEndpoint {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingDiscoveryBroadcastEndpoint(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=114082, value="Backup server that requested fail-back was not announced. Server will not stop for fail-back.", format=Message.Format.MESSAGE_FORMAT)
    public void failbackMissedBackupAnnouncement();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=114083, value="Can't find queue {0} while reloading PAGE_CURSOR_COMPLETE, deleting record now", format=Message.Format.MESSAGE_FORMAT)
    public void cantFindQueueOnPageComplete(long var1);
}

