/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.File;
import java.io.Serializable;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.ClusterConnectionImpl;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.utils.FutureLatch;
import org.hornetq.utils.Pair;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.w3c.dom.Node;

public class HornetQLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
HornetQLogger,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HQ";
    private static final String FQCN = HornetQLogger_$logger.class.getName();
    private static final String serverStarting = "{0} server is starting with configuration {1}";
    private static final String errorCancellingRefOnBridge = "Could not cancel reference {0}";
    private static final String keyAttributeMissing = "key attribute missing for configuration {0}";
    private static final String discoveryGroupAlreadyDeployed = "There is already a discovery group with name {0} deployed. This one will not be deployed.";
    private static final String errorUnDeployingURI = "Error undeploying URI {0}";
    private static final String errorDeployingURI1 = "Error deploying URI {0}";
    private static final String clusterConnectionNoForwardAddress = "Must specify an address for each cluster connection. This one will not be deployed.";
    private static final String journalCannotFindQueueDelCount = "Cannot find queue {0} to update delivery count";
    private static final String gotBackupLock = "** got backup lock";
    private static final String problemCleaningCursorPages = "Error on cleaning up cursor pages";
    private static final String stompBeginTX = "-------------------------------Stomp begin tx: {0}";
    private static final String errorClosingSession = "Failed to close session";
    private static final String nettyChannelStillBound = "{0} is still bound to {1}";
    private static final String bridgeNoConnector = "No connector defined with name '{0}'. The bridge will not be deployed.";
    private static final String broadcastGroupAlreadyExists = "There is already a broadcast-group with name {0} deployed. This one will not be deployed.";
    private static final String connectionClosed = "connection closed {0}";
    private static final String caughtException = "Caught exception";
    private static final String invalidFilter = "Invalid filter: {0}";
    private static final String errorRegisteringBackup = "Failed to register as backup. Stopping the server.";
    private static final String errorClosingCache = "error closing LargeMessage file cache";
    private static final String replacingIncompleteLargeMessage = "Replacing incomplete LargeMessage with ID={0}";
    private static final String serverIsStopped = "Server is stopped";
    private static final String ioErrorOnTX = "IO Error completing the transaction, code = {0}, message = {1}";
    private static final String batchingIdError = "Failed to store id";
    private static final String pageStoreFactoryNoIdFile = "Directory {0} did not have an identification file {1}";
    private static final String errorCleaningStompConn = "error cleaning up stomp connection";
    private static final String errorStartingReplication1 = "Error when trying to start replication {0}";
    private static final String errorOnXMLTransformInvalidConf = "Invalid configuration";
    private static final String ioErrorRedistributing = "IO Error during redistribution, errorCode = {0} message = {1}";
    private static final String clusterConnectionAlreadyExists = "Cluster Configuration  '{0}' already exists. The cluster connection will not be deployed.";
    private static final String ignoringPrepare = "ignoring prepare on xid as already called :{0}";
    private static final String errorDeletingLargeMessage = "Replication Error deleting large message ID = {0}";
    private static final String stompErrorTXExists = "Stomp Error, tx already exist! {0}";
    private static final String propertyNotInteger = "Property {0} must be an Integer, it is {1}";
    private static final String errorStoppingBridge = "Failed to stop bridge";
    private static final String bridgeNotUnique = "Must specify a unique name for each bridge. This one will not be deployed.";
    private static final String failoverDuringCommit = "failover occured during commit throwing XAException.XA_RETRY";
    private static final String problemRemovingCursorPages = "Could not remove page {0} from consumed pages on cursor for address {1}";
    private static final String backupActivationDidntFinish = "{0} backup activation thread did not finish.";
    private static final String createConnectorException = "connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.";
    private static final String connectorKeysInvalid = "The following keys are invalid for configuring the connector service: {0} the connector will not be started.";
    private static final String errorExpiringReferencesNoQueue = "Message has expired. No expiry queue configured for queue {0} so dropping it";
    private static final String clusterConnectionNoDiscoveryGroup = "No discovery group with name '{0}'. The cluster connection will not be deployed.";
    private static final String journalError = "Journal Error";
    private static final String errorReSettingIndex = "error resetting index";
    private static final String nettyChannelGroupError = "channel group did not completely close";
    private static final String errorCallingStart = "XA start operation failed {0} code:{1}";
    private static final String groupHandlerSendTimeout = "Group Handler timed-out waiting for sendCondition";
    private static final String largeMessageWithNoRef = "Large message: {0} did not have any associated reference, file will be deleted";
    private static final String backupServerIsLive = "Backup Server is now live";
    private static final String errorDeletingLargeMessageFile = "Failed to delete large message file";
    private static final String compressedLargeMessageError = "Compressed large message tried to read {0} bytes from stream {1}";
    private static final String errorStoppingDiscoveryBroadcastEndpoint = "Exception happened while stopping Discovery BroadcastEndpoint {0}";
    private static final String timedOutStoppingThreadpool = "Timed out waiting for pool to terminate {0}. Interrupting all its threads!";
    private static final String receivedExceptionAsynchronously = "Received exception asynchronously from server";
    private static final String journalErrorDeletingMessage = "It was not possible to delete message {0}";
    private static final String propertyNotBoolean = "Property {0} must be an Boolean, it is {1}";
    private static final String errorReadingCache = "error reading LargeMessage file cache";
    private static final String remoteQueueAlreadyBoundOnClusterConnection = "{0}::Remote queue binding {1} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses";
    private static final String errorSendingTopology = "error sending topology";
    private static final String failbackMissedBackupAnnouncement = "Backup server that requested fail-back was not announced. Server will not stop for fail-back.";
    private static final String errorExpiringReferencesNoBindings = "Message has expired. No bindings for Expiry Address {0} so dropping it";
    private static final String timedOutWaitingForTermination = "Timed out waiting for pool to terminate";
    private static final String journalCannotFindQueueReloading = "Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR, deleting record now";
    private static final String nodeManagerCantOpenFile = "Node Manager can not open file {0}";
    private static final String obtainedLiveLock = "Live Server Obtained live lock";
    private static final String errorSendingForcedDelivery = "Failed to send forced delivery message";
    private static final String errorStartingLocator = "error starting server locator";
    private static final String errorStoppingConnectorService = "unable to stop connector service: {0}";
    private static final String caughtunexpectedThrowable = "Caught unexpected Throwable";
    private static final String failedToConnectToServer0 = "Failed to connect to server.";
    private static final String errorRemovingConsumer = "Failed to remove consumer";
    private static final String serverFinalisedWIthoutBeingSTopped = "HornetQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope";
    private static final String problemCleaningPagesubscriptionCounter = "Problem cleaning page subscription counter";
    private static final String jvmAllocatedMoreMemory = "Warning: JVM allocated more data what would make results invalid {0}:{1}";
    private static final String serverIsLive1 = "Server {0} is now live";
    private static final String journalCannotFindQueue = "Cannot find queue messages for queueID={0} on ack for messageID={1}";
    private static final String errorOnStompHeartBeat = "Interrupted while waiting for stomp heart beate to die";
    private static final String failedToCreateSession = "Failed to create session";
    private static final String errorDecrementingRefCount = "Unable to decrement reference counting on queue";
    private static final String timeoutClosingSSL = "Timed out waiting for netty ssl close future to complete";
    private static final String failedToHandlePacket = "Failed to handle packet";
    private static final String pageStoreTimeout = "Timed out on waiting PagingStore {0} to shutdown";
    private static final String errorCreatingNettyConnection = "Failed to create netty connection";
    private static final String bridgeAlreadyDeployed = "There is already a bridge with name {0} deployed. This one will not be deployed.";
    private static final String noLocalMemborOnClusterConnection = "Local Member is not set at on ClusterConnection {0}";
    private static final String journalUnreferencedMessage = "Deleting unreferenced message id={0} from the journal";
    private static final String errorStoppingRedistributor = "Stopping Redistributor, Timed out waiting for tasks to complete";
    private static final String managementStopError = "On ManagementService stop, there are {0} unexpected registered MBeans: {1}";
    private static final String pageStoreDropMessages = "Messages are being dropped on address {0}";
    private static final String timeoutRemotingThreadPool = "Timed out waiting for remoting thread pool to terminate";
    private static final String journalInvalidRecordType = "InternalError: Record type {0} not recognized. Maybe you are using journal files created on a different version";
    private static final String pageSubscriptionError = "page subscription = {0} error={1}";
    private static final String errorCompletingContext = "Could not finish context execution in 10 seconds";
    private static final String errorSettingIndex = "error setting index";
    private static final String journalcomparisonMismatch = "Journal comparison mismatch:\n{0}";
    private static final String duplicateMessageDetected = "Duplicate message detected - message will not be routed. Message information:\n{0}";
    private static final String incompatibleVersionAfterConnect = "Client is not being consistent on the request versioning. It just sent a version id={0} while it informed {1} previously";
    private static final String bridgeNoDiscoveryGroup = "No discovery group found with name {0} bridge will not be deployed.";
    private static final String errorCallingInterceptor = "Failure in calling interceptor: {0}";
    private static final String bridgeFailedToAck = "Bridge Failed to ack";
    private static final String journalCannotFindQueueScheduled = "Cannot find queue messages {0} for message {1} while processing scheduled messages";
    private static final String problemCompletingOperations = "Could not complete operations on IO context {0}";
    private static final String errorRunningLargeMessageDeliverer = "Failed to run large message deliverer";
    private static final String reservingFileIDs = "replication Journal {0}. Reserving fileIDs for synchronization: {1}";
    private static final String errorRestartingBackupServer = "Error while restarting the backup server: {0}";
    private static final String bridgeStopping = "Bridge is stopping, will not retry";
    private static final String errorOnXMLTransform = "Failed to invoke getTextContent() on node {0}";
    private static final String messageExceededMaxDeliveryNoDLA = "Message has exceeded max delivery attempts. No Dead Letter Address configured for queue {0} so dropping it";
    private static final String timedOutFlushingExecutorsPagingCursor1 = "Timed out flushing executors for paging cursor to stop {0}";
    private static final String bridgeConnected = "Bridge {0} is connected";
    private static final String bridgeNoQueue0 = "Must specify a queue name for each bridge. This one will not be deployed.";
    private static final String AIONotFound = "AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal";
    private static final String pageTxDeleteError = "Can not delete page transaction id={0}";
    private static final String errorSendingTopologyNodedown = "error sending topology";
    private static final String nodeNotAvailable = "NodeID={0} is not available on the topology. Retrying the connection to that node now";
    private static final String unableToStartClusterConnection = "unable to start cluster connection {0}";
    private static final String backupActivationProblem = "Timed out waiting for backup activation to exit";
    private static final String duplicateMessageDetectedThruBridge = "Duplicate message detected through the bridge - message will not be routed. Message information:\n{0}";
    private static final String ioErrorAddingReferences = "It was not possible to add references due to an IO error code {0} message = {1}";
    private static final String dumpingSessionStacks = "**** Dumping session creation stacks ****";
    private static final String noVersionOnClasspath = "Cannot find hornetq-version.properties on classpath: {1}";
    private static final String errorCallingRepoListener = "Unable to call Hierarchical Repository Change Listener";
    private static final String errorExpiringReferencesOnQueue = "Error expiring reference {0} 0n queue";
    private static final String errorQueryingBridge1 = "Error on querying binding on bridge {0}. Retrying in 100 milliseconds";
    private static final String errorExpiringMessages = "failed to expire messages for queue";
    private static final String pageNotFound = "Could not find page cache for page {0} removing it from the journal";
    private static final String journalInvalidRecordTypeOnPreparedTX = "Can not locate recordType={0} on loadPreparedTransaction//deleteRecords";
    private static final String errorCallingEnd = "XA end operation failed ";
    private static final String failedToConnectToServer1 = "Tried {0} times to connect. Now giving up on reconnecting it.";
    private static final String errorOnStompPingFrame = "Cannot create stomp ping frame due to encoding problem.";
    private static final String dumpServerInfo = "{0}";
    private static final String journalCannotFindQueueReloadingACK = "Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR";
    private static final String stompTXAckNorSupported = "Stomp Transactional acknowledgement is not supported";
    private static final String incompatibleVersion = "Client with version {0} and address {1} is not compatible with server version {2}. Please ensure all clients and servers are upgraded to the same version for them to interoperate properly";
    private static final String errorRemovingMessage = "Unable to remove message id = {0} please remove manually";
    private static final String timedOutWaitingForScheduledPoolTermination = "Timed out waiting for scheduled pool to terminate";
    private static final String failedToHandleFailover = "Failed to handle failover";
    private static final String journalErrorConfirmingLargeMessage = "Error while confirming large message completion on rollback for recordID={0}";
    private static final String errorUpdatingTopology = "Failed to update cluster connection topology";
    private static final String errorClosingServerLocator = "Error closing serverLocator={0}";
    private static final String replicationStartProblem = "Unable to announce backup for replication. Trying to stop the server.";
    private static final String backupAnnounced = "backup announced";
    private static final String errorHandlingMessage = "cluster connection Failed to handle message";
    private static final String errorFinalisingCache = "Exception during finalization for LargeMessage file cache";
    private static final String percentLoaded = "{0}% loaded";
    private static final String broadcastBridgeStoppedError = "unable to send notification when broadcast group is stopped";
    private static final String unableToCloseSession = "Unable to close session";
    private static final String largeMessageNotAvailable = "Replication Large MessageID {0}  is not available on backup server. Ignoring replication message";
    private static final String errorStoppingServer = "Error stopping server";
    private static final String errorBrowserHandlingMessage = "Exception while browser handled from {0}";
    private static final String clientConnectionFailed = "Client connection failed, clearing up resources for session {0}";
    private static final String ioDiscoveryError = "Could not bind to {0} ({1} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.";
    private static final String notificationBridgeStoppedError = "unable to send notification when broadcast group is stopped";
    private static final String timedOutFlushingExecutorsPagingCursor2 = "Timed out flushing executors for paging cursor to stop {0} {1}";
    private static final String announceBackupNoConnector = "No connector with name '{0}'. backup cannot be announced.";
    private static final String nettyChannelGroupBindError = "channel group did not completely unbind";
    private static final String initializationError = "Failure in initialisation";
    private static final String journalCannotFindQueueReloadingPage = "Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now";
    private static final String errorWritingToInvmConnector = "Failed to write to handler on invm connector {0}";
    private static final String broadcastGroupBindError = "local-bind-address specified for broadcast group but no local-bind-port specified so socket will NOT be bound to a local address/port";
    private static final String problemCleaningPageAddress = "problem cleaning page address {0}";
    private static final String replicationStopOnBackupShutdown = "The backup node has been shut-down, replication will now stop";
    private static final String errorProcessingIOCallback = "Error processing IOCallback code = {0} message = {1}";
    private static final String errorSendingNotifOnDiscoveryStop = "unable to send notification when discovery group is stopped";
    private static final String warn = "{0}";
    private static final String deployQueue = "trying to deploy queue {0}";
    private static final String pageSubscriptionCouldntLoad = "Could not locate page transaction {0}, ignoring message on position {1} on address={2} queue={3}";
    private static final String clusterSecurityRisk = "Security risk! HornetQ is running with the default cluster admin user and default password. Please see the HornetQ user guide, cluster chapter, for instructions on how to change this.";
    private static final String timedOutStoppingDiscovery = "Timed out waiting to stop discovery thread";
    private static final String resettingSessionAfterFailure = "resetting session after failure";
    private static final String errorDecodingPacket = "Failed to decode packet";
    private static final String serverStopped = "HornetQ Server version {0} [{1}] stopped";
    private static final String invalidAcceptorKeys = "The following keys are invalid for configuring the acceptor: {0} the acceptor will not be started.";
    private static final String connectorWithNoName = "Cannot deploy a connector with no name specified.";
    private static final String largeMessageErrorReleasingResources = "error releasing resources";
    private static final String journalCannotFindQueueForMessage = "Message for queue {0} which does not exist. This message will be ignored.";
    private static final String errorStoppingReplication = "Error when trying to stop replication";
    private static final String errorHandlingReplicationPacket = "error handling packet {0} for replication";
    private static final String managementAttributeError = "exception while retrieving attribute {0} on {1}";
    private static final String connectionFailureDetected = "Connection failure has been detected: {0} [code={1}]";
    private static final String failedToStartDiscovery = "Failed to start discovery group";
    private static final String errorFlushingExecutorsOnQueue = "Queue could not finish waiting executors. Try increasing the thread pool size";
    private static final String journalUseNIO = "Using NIO Journal";
    private static final String errorResttingLargeMessage = "Error on resetting large message deliver - {0}";
    private static final String retryCreateSessionSeverStarting = "Server is starting, retry to create the session {0}";
    private static final String timeOutWaitingForProcessing = "Timed out waiting for handler to complete processing";
    private static final String serverRestartWarning = "unable to restart server, please kill and restart manually";
    private static final String pageInvalid = "File {0} being renamed to {1}.invalidPage as it was loaded partially. Please verify your data.";
    private static final String failedToExecuteListener = "Failed to execute failure listener";
    private static final String unableToStartBridge = "unable to start Bridge {0}";
    private static final String waitingForRetry = "Waiting {0} milliseconds before next retry. RetryInterval={1} and multiplier={2}";
    private static final String errorReadingIndex = "error reading index";
    private static final String errorEncodingStompPacket = "Error encoding stomp packet";
    private static final String managementOperationError = "exception while invoking {0} on {1}";
    private static final String clearingUpSession = "Cleared up resources for session {0}";
    private static final String journalMessageInPreparedTX = "Message in prepared tx for queue {0} which does not exist. This message will be ignored.";
    private static final String noDLA = "Did not route to any bindings for address {0} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.";
    private static final String memoryError = "Less than {0}%\n{1}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)";
    private static final String errorReceivingPAcketInDiscovery = "error receiving packet in discovery";
    private static final String journalPAGEOnPrepared = "PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, invalid state";
    private static final String sessionNotXA = "Session is not XA";
    private static final String errorConnectingBridge = "Bridge {0} is unable to connect to destination. It will be disabled.";
    private static final String caughtXaException = "Caught XA exception";
    private static final String messageWithDuplicateID3 = "Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored";
    private static final String errorClosingFlowRecord = "Failed to close cluster connection flow record";
    private static final String problemUndeployingNode = "problem undeploying {0}";
    private static final String removingBadConsumer = "removing consumer which did not handle a message, consumer={0}, message={1}";
    private static final String messageExceededMaxDelivery = "Message {0} has exceeded max delivery attempts. No bindings for Dead Letter Address {1} so dropping it";
    private static final String serverIsLive0 = "Server is now live";
    private static final String errorflushingInvmChannel = "error flushing invm channel";
    private static final String errorOnFailureCheck = "error on connection failure check";
    private static final String errorCompletingReplicationCallback = "Error completing callback on replication manager";
    private static final String journalSynch = "Replication: sending {0} (size={1}) to backup. {2}";
    private static final String bridgeStopped = "stopped bridge {0}";
    private static final String errorCheckingDLQ = "Error checking DLQ";
    private static final String errorStartingReplication0 = "Error when trying to start replication";
    private static final String failedToStopDiscovery = "Failed to stop discovery group";
    private static final String unexpectedNettyVersion = "Unexpected Netty Version was expecting {0} using {1} Version.ID";
    private static final String errorAckingOldReference = "Failed to ack old reference";
    private static final String errorDeletingDuplicateCache = "Error on deleting duplicate cache";
    private static final String onMessageError = "Failed to call onMessage";
    private static final String unableToDeleteGroupBindings = "Unable to delete group binding info {0}";
    private static final String errorScanningURLs = "error scanning for URL's";
    private static final String pageStoreStart = "Starting paging on {0}, size = {1}, maxSize={2}";
    private static final String deletingPendingMessage = "Deleting pending large message as it was not completed: {0}";
    private static final String bridgeConnectionFailed = "Connection failed with failedOver={1}";
    private static final String backupServerStarted = "HornetQ Backup Server version {0} [{1}] started, waiting live to fail before it gets active";
    private static final String journalCannotFindMessageDelCount = "Cannot find message {0} to update delivery count";
    private static final String bridgeLocatorShutdown = "ServerLocator was shutdown, can not retry on opening connection for bridge";
    private static final String errorCallingNotifListener = "Failed to call notification listener";
    private static final String errorCallingCancel = "error calling cancel";
    private static final String errorReConnecting = "Unexpected exception while trying to reconnect";
    private static final String pageDeleteError = "Error while deleting page file";
    private static final String ioErrorShutdownServer = "Critical IO Error, shutting down the server. code={0}, message={1}";
    private static final String replicationStopOnBackupFail = "Connection to the backup node failed, removing replication now";
    private static final String invalidPacketForReplication = "Packet {0} can not be processed by the ReplicationEndpoint";
    private static final String failedToCallListenerInDiscovery = "Failed to call discovery listener";
    private static final String bridgeNotificationOnGroupStopped = "Bridge unable to send notification when broadcast group is stopped";
    private static final String errorStoppingAcceptor = "Failed to stop acceptor";
    private static final String errorClosingConsumer = "Failed to close consumer";
    private static final String errorCallingFailureListener = "Failed to execute failure listener";
    private static final String errorExecutingIOAsyncTask = "Error on executing IOAsyncTask";
    private static final String cannotFindMessage = "Cannot find message {0}";
    private static final String clusterConnectionNoConnector = "No connector with name '{0}'. The cluster connection will not be deployed.";
    private static final String largeMessageIncomatible = "large message sync: largeMessage instance is incompatible with it, ignoring data";
    private static final String broadcastGroupNoConnector = "There is no connector deployed with name '{0}'. The broadcast group with name '{1}' will not be deployed.";
    private static final String errorPausingBridge = "Failed to pause bridge";
    private static final String failedToReattachSession = "Failed to reattach session";
    private static final String commitAfterFailover = "committing transaction after failover occurred, any non persistent messages may be lost";
    private static final String errorClosingPageOnReplication = "Replication Error while closing the page on backup";
    private static final String errorStartingConnectorService = "unable to start connector service: {0}";
    private static final String lareMessageErrorCopying = "Error on copying large message {0} for DLA or Expiry";
    private static final String errorCallingLifeCycleListener = "Failed to execute connection life cycle listener";
    private static final String autoFailBackDenied = "Live server will not fail-back automatically";
    private static final String errorDeployingURI0 = "Error deploying URI";
    private static final String journalErrorRemovingRef = "Failed to remove reference for {0}";
    private static final String pageStoreStartIOError = "IO Error, impossible to start paging";
    private static final String bridgeNoBindings = "Bridge {0} connected to fowardingAddress={1}. {2} does not have any bindings what means messages will be ignored until a binding is created.";
    private static final String errorExpiringRef = "Failed to expire message reference";
    private static final String waitingToBecomeBackup = "Waiting to become backup node";
    private static final String factoryLeftOpen = "I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {0}";
    private static final String messageWithDuplicateID4 = "Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored and message removed from {3}";
    private static final String errorClosingSessionsWhileStoppingServer = "Error closing sessions while stopping server";
    private static final String reattachRequestFailed = "Reattach request from {0} failed as there is no confirmationWindowSize configured, which may be ok for your system";
    private static final String failedToReceiveDatagramInDiscovery = "Failed to receive datagram";
    private static final String errorTimingOutTX = "failed to timeout transaction, xid:{0}";
    private static final String divertWithNoAddress = "Must specify an address for each divert. This one will not be deployed.";
    private static final String nettyChannelStillOpen = "{0} is still connected to {1}";
    private static final String errorRemovingTempQueue = "Failed to remove temporary queue {0}";
    private static final String invalidPacket = "Invalid packet {0}";
    private static final String backupServerSynched = "Backup server {0} is synchronized with live-server.";
    private static final String cannotFindPacketToClear = "Can not find packet to clear: {0} last received command id first stored command id {1}";
    private static final String errorCompletingCallbackOnReplicationManager = "Error completing callback on replication manager";
    private static final String errorAnnouncingBackup = "Unable to announce backup, retrying";
    private static final String propertyNotLong = "Property {0} must be an Long, it is {1}";
    private static final String divertWithNoName = "Must specify a name for each divert. This one will not be deployed.";
    private static final String clientConnectionFailedClearingSession = "Cleared up resources for session {0}";
    private static final String errorIncrementDelayDeletionCount = "error incrementing delay detection";
    private static final String clusterConnectionNotUnique = "Must specify a unique name for each cluster connection. This one will not be deployed.";
    private static final String errorAddingPacket = "error adding packet";
    private static final String becomingLive = "{0} to become 'live'";
    private static final String serverAlreadyStarted = "{0} is already started, ignoring the call to start..";
    private static final String pageFinaliseError = "page finalise error";
    private static final String clientSessionNotClosed = "I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {0}";
    private static final String waitingToObtainLiveLock = "Waiting to obtain live lock";
    private static final String noQueueIdDefined = "no queue IDs defined!,  originalMessage  = {0}, copiedMessage = {1}, props={2}";
    private static final String failoverDuringPrepareRollingBack = "failover occurred during prepare rolling back";
    private static final String errorRemovingConnection = "failed to remove connection";
    private static final String announceBackupNoClusterConnections = "no cluster connections defined, unable to announce backup";
    private static final String bridgePaused = "paused bridge {0}";
    private static final String unableToStartBroadcastGroup = "unable to start broadcast group {0}";
    private static final String errorStoppingReplicationManager = "exception while stopping the replication manager";
    private static final String cantFindQueueOnPageComplete = "Can't find queue {0} while reloading PAGE_CURSOR_COMPLETE, deleting record now";
    private static final String journalCannotFindQueueReloadingPageCursor = "Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now";
    private static final String errorBroadcastingConnectorConfigs = "Failed to broadcast connector configs";
    private static final String errorSendingFrame = "Unable to send frame {0}";
    private static final String unexpectedXid = "transaction with xid {0} timed out";
    private static final String serverStarted = "HornetQ Server version {0} [{1}] {2}";
    private static final String timedOutStoppingPagingCursor = "Timed out waiting for paging cursor to stop {0} {1}";
    private static final String divertWithNoForwardingAddress = "Must specify a forwarding address for each divert. This one will not be deployed.";
    private static final String startedNettyAcceptor = "Started Netty Acceptor version {0} {1}:{2} for {3} protocol";
    private static final String errorDelivering = "Failed to deliver";
    private static final String serverLocatorNotClosed = "Closing a Server Locator left open. Please make sure you close all Server Locators explicitly before letting them go out of scope! {0}";
    private static final String errorDuringPrepare = "failover occurred during prepare rolling back";
    private static final String errorHandlingPacket = "Unexpected error handling packet {0}";
    private static final String messageExceededMaxDeliverySendtoDLA = "Message {0} has reached maximum delivery attempts, sending it to Dead Letter Address {1} from {2}";
    private static final String reaperRestarted = "Reaper thread being restarted";
    private static final String timeoutClosingNettyChannel = "Timed out waiting for netty channel to close";
    private static final String errorTransferringConsumer = "Timed out waiting for executor to complete";
    private static final String timeoutFlushingPacket = "Timed out waiting for packet to be flushed";
    private static final String timedOutWaitingToStopBridge = "Timed out waiting to stop Bridge";
    private static final String bridgeUnableToSendMessage = "Bridge unable to send message {0}, will try again once bridge reconnects";
    private static final String errorStartingBridge = "Server is starting, retry to create the session for bridge {0}";
    private static final String bridgeAbortStart = "Bridge {0} achieved {1} maxattempts={2} it will stop retrying to reconnect";
    private static final String dumpingSessionStack = "session created";
    private static final String awaitFailBack = "live server wants to restart, restarting server in backup";
    private static final String errorQueryingBridge2 = "Address {0} does not have any bindings yet, retry #({1})";
    private static final String unableToDeployNode = "Unable to deply node {0}";
    private static final String errorConnectingToNodes = "did not connect the cluster connection to other nodes";
    private static final String divertBindingNotExists = "Binding already exists with name {0}, divert will not be deployed";
    private static final String cannotFindConsumer = "Cannot find consumer with id {0}";
    private static final String errorCreatingAcceptor = "Error instantiating remoting acceptor {0}";
    private static final String errorAckingMessage = "error acknowledging message";
    private static final String errorCreatingRemotingInterceptor = "Error instantiating remoting interceptor {0}";
    private static final String journalUseAIO = "Using AIO Journal";
    private static final String bridgeNoForwardAddress = "Bridge Forward address is not specified. Will use original message address instead";
    private static final String failedToHandleCreateQueue = "Failed to handle create queue";
    private static final String broadcastGroupClosed = "unable to send notification when broadcast group is stopped";
    private static final String failoverDuringPrepare = "failover occurred during prepare re-trying";
    private static final String errorClearingMessages = "Error on clearing messages";
    private static final String failedToCleanupSession = "failed to cleanup session";
    private static final String pageSuspectFile = "Page file had incomplete records at position {0} at record number {1}";
    private static final String multipleServersBroadcastingSameNode = "There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node. nodeID={0}";
    private static final String deprecatedConfigurationOption = "Configuration option {0} is deprecated. Consult the manual for details.";
    private static final String connectorKeysMissing = "The following keys are required for configuring the connector service: {0} the connector will not be started.";
    private static final String backupMovingDataAway = "Moving data directory {0} to {1}";
    private static final String errorClosingConnection = "Failed to close connection {0}";
    private static final String failedToAckOnBridge = "Failed to ack on Bridge";
    private static final String awaitingLiveLock = "Waiting to obtain live lock";
    private static final String connectorAlreadyDeployed = "There is already a connector with name {0} deployed. This one will not be deployed.";
    private static final String timedOutFlushingInvmChannel = "Timed out flushing channel on InVMConnection";
    private static final String errorClosingBackupFactoryOnClusterConnection = "problem closing backup session factory for cluster connection";
    private static final String bridgeNoQueue1 = "No queue found with name {0} bridge will not be deployed.";

    public HornetQLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void serverStarting(String type, Configuration configuration) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111001: " + this.serverStarting$str(), (Object)type, (Object)configuration);
    }

    protected String serverStarting$str() {
        return serverStarting;
    }

    @Override
    public final void errorCancellingRefOnBridge(Exception e, MessageReference ref2) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114048: " + this.errorCancellingRefOnBridge$str(), (Object)ref2);
    }

    protected String errorCancellingRefOnBridge$str() {
        return errorCancellingRefOnBridge;
    }

    @Override
    public final void keyAttributeMissing(Node node) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114018: " + this.keyAttributeMissing$str(), (Object)node);
    }

    protected String keyAttributeMissing$str() {
        return keyAttributeMissing;
    }

    @Override
    public final void discoveryGroupAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112055: " + this.discoveryGroupAlreadyDeployed$str(), (Object)name);
    }

    protected String discoveryGroupAlreadyDeployed$str() {
        return discoveryGroupAlreadyDeployed;
    }

    @Override
    public final void errorUnDeployingURI(Throwable e, URI a) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114017: " + this.errorUnDeployingURI$str(), (Object)a);
    }

    protected String errorUnDeployingURI$str() {
        return errorUnDeployingURI;
    }

    @Override
    public final void errorDeployingURI(Throwable e, URI uri) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114015: " + this.errorDeployingURI1$str(), (Object)uri);
    }

    protected String errorDeployingURI1$str() {
        return errorDeployingURI1;
    }

    @Override
    public final void clusterConnectionNoForwardAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112180: " + this.clusterConnectionNoForwardAddress$str(), new Object[0]);
    }

    protected String clusterConnectionNoForwardAddress$str() {
        return clusterConnectionNoForwardAddress;
    }

    @Override
    public final void journalCannotFindQueueDelCount(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112079: " + this.journalCannotFindQueueDelCount$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueDelCount$str() {
        return journalCannotFindQueueDelCount;
    }

    @Override
    public final void gotBackupLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111038: " + this.gotBackupLock$str(), new Object[0]);
    }

    protected String gotBackupLock$str() {
        return gotBackupLock;
    }

    @Override
    public final void problemCleaningCursorPages(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112063: " + this.problemCleaningCursorPages$str(), new Object[0]);
    }

    protected String problemCleaningCursorPages$str() {
        return problemCleaningCursorPages;
    }

    @Override
    public final void stompBeginTX(String txID) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114050: " + this.stompBeginTX$str(), (Object)txID);
    }

    protected String stompBeginTX$str() {
        return stompBeginTX;
    }

    @Override
    public final void errorClosingSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114028: " + this.errorClosingSession$str(), new Object[0]);
    }

    protected String errorClosingSession$str() {
        return errorClosingSession;
    }

    @Override
    public final void nettyChannelStillBound(Channel channel, SocketAddress remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112118: " + this.nettyChannelStillBound$str(), (Object)channel, (Object)remoteAddress);
    }

    protected String nettyChannelStillBound$str() {
        return nettyChannelStillBound;
    }

    @Override
    public final void bridgeNoConnector(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112186: " + this.bridgeNoConnector$str(), (Object)name);
    }

    protected String bridgeNoConnector$str() {
        return bridgeNoConnector;
    }

    @Override
    public final void broadcastGroupAlreadyExists(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112184: " + this.broadcastGroupAlreadyExists$str(), (Object)name);
    }

    protected String broadcastGroupAlreadyExists$str() {
        return broadcastGroupAlreadyExists;
    }

    @Override
    public final void connectionClosed(StompConnection connection) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112109: " + this.connectionClosed$str(), (Object)connection);
    }

    protected String connectionClosed$str() {
        return connectionClosed;
    }

    @Override
    public final void caughtException(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114030: " + this.caughtException$str(), new Object[0]);
    }

    protected String caughtException$str() {
        return caughtException;
    }

    @Override
    public final void invalidFilter(Throwable t, SimpleString filter) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114020: " + this.invalidFilter$str(), (Object)filter);
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final void errorRegisteringBackup() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112207: " + this.errorRegisteringBackup$str(), new Object[0]);
    }

    protected String errorRegisteringBackup$str() {
        return errorRegisteringBackup;
    }

    @Override
    public final void errorClosingCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112039: " + this.errorClosingCache$str(), new Object[0]);
    }

    protected String errorClosingCache$str() {
        return errorClosingCache;
    }

    @Override
    public final void replacingIncompleteLargeMessage(Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112157: " + this.replacingIncompleteLargeMessage$str(), (Object)messageID);
    }

    protected String replacingIncompleteLargeMessage$str() {
        return replacingIncompleteLargeMessage;
    }

    @Override
    public final void serverIsStopped() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112078: " + this.serverIsStopped$str(), new Object[0]);
    }

    protected String serverIsStopped$str() {
        return serverIsStopped;
    }

    @Override
    public final void ioErrorOnTX(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112150: " + this.ioErrorOnTX$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorOnTX$str() {
        return ioErrorOnTX;
    }

    @Override
    public final void batchingIdError(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114022: " + this.batchingIdError$str(), new Object[0]);
    }

    protected String batchingIdError$str() {
        return batchingIdError;
    }

    @Override
    public final void pageStoreFactoryNoIdFile(String s, String addressFile) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112073: " + this.pageStoreFactoryNoIdFile$str(), (Object)s, (Object)addressFile);
    }

    protected String pageStoreFactoryNoIdFile$str() {
        return pageStoreFactoryNoIdFile;
    }

    @Override
    public final void errorCleaningStompConn(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112110: " + this.errorCleaningStompConn$str(), new Object[0]);
    }

    protected String errorCleaningStompConn$str() {
        return errorCleaningStompConn;
    }

    @Override
    public final void errorStartingReplication(BackupReplicationStartFailedMessage.BackupRegistrationProblem problem) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112217: " + this.errorStartingReplication1$str(), (Object)problem);
    }

    protected String errorStartingReplication1$str() {
        return errorStartingReplication1;
    }

    @Override
    public final void errorOnXMLTransformInvalidConf(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114077: " + this.errorOnXMLTransformInvalidConf$str(), new Object[0]);
    }

    protected String errorOnXMLTransformInvalidConf$str() {
        return errorOnXMLTransformInvalidConf;
    }

    @Override
    public final void ioErrorRedistributing(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112188: " + this.ioErrorRedistributing$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorRedistributing$str() {
        return ioErrorRedistributing;
    }

    @Override
    public final void clusterConnectionAlreadyExists(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112182: " + this.clusterConnectionAlreadyExists$str(), (Object)connectorName);
    }

    protected String clusterConnectionAlreadyExists$str() {
        return clusterConnectionAlreadyExists;
    }

    @Override
    public final void ignoringPrepare(Xid xid) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111043: " + this.ignoringPrepare$str(), (Object)xid);
    }

    protected String ignoringPrepare$str() {
        return ignoringPrepare;
    }

    @Override
    public final void errorDeletingLargeMessage(Exception e, long messageId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112133: " + this.errorDeletingLargeMessage$str(), (Object)messageId);
    }

    protected String errorDeletingLargeMessage$str() {
        return errorDeletingLargeMessage;
    }

    @Override
    public final void stompErrorTXExists(String txID) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114039: " + this.stompErrorTXExists$str(), (Object)txID);
    }

    protected String stompErrorTXExists$str() {
        return stompErrorTXExists;
    }

    @Override
    public final void propertyNotInteger(String propName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112151: " + this.propertyNotInteger$str(), (Object)propName, (Object)name);
    }

    protected String propertyNotInteger$str() {
        return propertyNotInteger;
    }

    @Override
    public final void errorStoppingBridge(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114052: " + this.errorStoppingBridge$str(), new Object[0]);
    }

    protected String errorStoppingBridge$str() {
        return errorStoppingBridge;
    }

    @Override
    public final void bridgeNotUnique() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112173: " + this.bridgeNotUnique$str(), new Object[0]);
    }

    protected String bridgeNotUnique$str() {
        return bridgeNotUnique;
    }

    @Override
    public final void failoverDuringCommit() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112028: " + this.failoverDuringCommit$str(), new Object[0]);
    }

    protected String failoverDuringCommit$str() {
        return failoverDuringCommit;
    }

    @Override
    public final void problemRemovingCursorPages(Long pageId, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112064: " + this.problemRemovingCursorPages$str(), (Object)pageId, (Object)address);
    }

    protected String problemRemovingCursorPages$str() {
        return problemRemovingCursorPages;
    }

    @Override
    public final void backupActivationDidntFinish(HornetQServer server) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112210: " + this.backupActivationDidntFinish$str(), (Object)server);
    }

    protected String backupActivationDidntFinish$str() {
        return backupActivationDidntFinish;
    }

    @Override
    public final void createConnectorException(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112023: " + this.createConnectorException$str(), new Object[0]);
    }

    protected String createConnectorException$str() {
        return createConnectorException;
    }

    @Override
    public final void connectorKeysInvalid(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112127: " + this.connectorKeysInvalid$str(), (Object)s);
    }

    protected String connectorKeysInvalid$str() {
        return connectorKeysInvalid;
    }

    @Override
    public final void errorExpiringReferencesNoQueue(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112199: " + this.errorExpiringReferencesNoQueue$str(), (Object)name);
    }

    protected String errorExpiringReferencesNoQueue$str() {
        return errorExpiringReferencesNoQueue;
    }

    @Override
    public final void clusterConnectionNoDiscoveryGroup(String discoveryGroupName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112183: " + this.clusterConnectionNoDiscoveryGroup$str(), (Object)discoveryGroupName);
    }

    protected String clusterConnectionNoDiscoveryGroup$str() {
        return clusterConnectionNoDiscoveryGroup;
    }

    @Override
    public final void journalError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112089: " + this.journalError$str(), new Object[0]);
    }

    protected String journalError$str() {
        return journalError;
    }

    @Override
    public final void errorReSettingIndex(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112037: " + this.errorReSettingIndex$str(), new Object[0]);
    }

    protected String errorReSettingIndex$str() {
        return errorReSettingIndex;
    }

    @Override
    public final void nettyChannelGroupError() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112115: " + this.nettyChannelGroupError$str(), new Object[0]);
    }

    protected String nettyChannelGroupError$str() {
        return nettyChannelGroupError;
    }

    @Override
    public final void errorCallingStart(String message, Integer code) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114007: " + this.errorCallingStart$str(), (Object)message, (Object)code);
    }

    protected String errorCallingStart$str() {
        return errorCallingStart;
    }

    @Override
    public final void groupHandlerSendTimeout() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112214: " + this.groupHandlerSendTimeout$str(), new Object[0]);
    }

    protected String groupHandlerSendTimeout$str() {
        return groupHandlerSendTimeout;
    }

    @Override
    public final void largeMessageWithNoRef(Long messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111022: " + this.largeMessageWithNoRef$str(), (Object)messageID);
    }

    protected String largeMessageWithNoRef$str() {
        return largeMessageWithNoRef;
    }

    @Override
    public final void backupServerIsLive() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111012: " + this.backupServerIsLive$str(), new Object[0]);
    }

    protected String backupServerIsLive$str() {
        return backupServerIsLive;
    }

    @Override
    public final void errorDeletingLargeMessageFile(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114068: " + this.errorDeletingLargeMessageFile$str(), new Object[0]);
    }

    protected String errorDeletingLargeMessageFile$str() {
        return errorDeletingLargeMessageFile;
    }

    @Override
    public final void compressedLargeMessageError(int length, int nReadBytes) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112215: " + this.compressedLargeMessageError$str(), (Object)length, (Object)nReadBytes);
    }

    protected String compressedLargeMessageError$str() {
        return compressedLargeMessageError;
    }

    @Override
    public final void errorStoppingDiscoveryBroadcastEndpoint(Object endpoint, Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114081: " + this.errorStoppingDiscoveryBroadcastEndpoint$str(), endpoint);
    }

    protected String errorStoppingDiscoveryBroadcastEndpoint$str() {
        return errorStoppingDiscoveryBroadcastEndpoint;
    }

    @Override
    public final void timedOutStoppingThreadpool(ExecutorService service) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112003: " + this.timedOutStoppingThreadpool$str(), (Object)service);
    }

    protected String timedOutStoppingThreadpool$str() {
        return timedOutStoppingThreadpool;
    }

    @Override
    public final void receivedExceptionAsynchronously(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114009: " + this.receivedExceptionAsynchronously$str(), new Object[0]);
    }

    protected String receivedExceptionAsynchronously$str() {
        return receivedExceptionAsynchronously;
    }

    @Override
    public final void journalErrorDeletingMessage(Exception e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112082: " + this.journalErrorDeletingMessage$str(), (Object)messageID);
    }

    protected String journalErrorDeletingMessage$str() {
        return journalErrorDeletingMessage;
    }

    @Override
    public final void propertyNotBoolean(String propName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112153: " + this.propertyNotBoolean$str(), (Object)propName, (Object)name);
    }

    protected String propertyNotBoolean$str() {
        return propertyNotBoolean;
    }

    @Override
    public final void errorReadingCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112038: " + this.errorReadingCache$str(), new Object[0]);
    }

    protected String errorReadingCache$str() {
        return errorReadingCache;
    }

    @Override
    public final void remoteQueueAlreadyBoundOnClusterConnection(Object messageFlowRecord, SimpleString clusterName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112191: " + this.remoteQueueAlreadyBoundOnClusterConnection$str(), messageFlowRecord, (Object)clusterName);
    }

    protected String remoteQueueAlreadyBoundOnClusterConnection$str() {
        return remoteQueueAlreadyBoundOnClusterConnection;
    }

    @Override
    public final void errorSendingTopology(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112046: " + this.errorSendingTopology$str(), new Object[0]);
    }

    protected String errorSendingTopology$str() {
        return "error sending topology";
    }

    @Override
    public final void failbackMissedBackupAnnouncement() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114082: " + this.failbackMissedBackupAnnouncement$str(), new Object[0]);
    }

    protected String failbackMissedBackupAnnouncement$str() {
        return failbackMissedBackupAnnouncement;
    }

    @Override
    public final void errorExpiringReferencesNoBindings(SimpleString expiryAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112198: " + this.errorExpiringReferencesNoBindings$str(), (Object)expiryAddress);
    }

    protected String errorExpiringReferencesNoBindings$str() {
        return errorExpiringReferencesNoBindings;
    }

    @Override
    public final void timedOutWaitingForTermination() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112042: " + this.timedOutWaitingForTermination$str(), new Object[0]);
    }

    protected String timedOutWaitingForTermination$str() {
        return timedOutWaitingForTermination;
    }

    @Override
    public final void journalCannotFindQueueReloading(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111019: " + this.journalCannotFindQueueReloading$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloading$str() {
        return journalCannotFindQueueReloading;
    }

    @Override
    public final void nodeManagerCantOpenFile(Exception e, File file) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112193: " + this.nodeManagerCantOpenFile$str(), (Object)file);
    }

    protected String nodeManagerCantOpenFile$str() {
        return nodeManagerCantOpenFile;
    }

    @Override
    public final void obtainedLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111040: " + this.obtainedLiveLock$str(), new Object[0]);
    }

    protected String obtainedLiveLock$str() {
        return obtainedLiveLock;
    }

    @Override
    public final void errorSendingForcedDelivery(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114064: " + this.errorSendingForcedDelivery$str(), new Object[0]);
    }

    protected String errorSendingForcedDelivery$str() {
        return errorSendingForcedDelivery;
    }

    @Override
    public final void errorStartingLocator(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112044: " + this.errorStartingLocator$str(), new Object[0]);
    }

    protected String errorStartingLocator$str() {
        return errorStartingLocator;
    }

    @Override
    public final void errorStoppingConnectorService(Throwable e, String name) {
        this.log.logv(FQCN, Logger.Level.INFO, e, "HQ111027: " + this.errorStoppingConnectorService$str(), (Object)name);
    }

    protected String errorStoppingConnectorService$str() {
        return errorStoppingConnectorService;
    }

    @Override
    public final void caughtunexpectedThrowable(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114075: " + this.caughtunexpectedThrowable$str(), new Object[0]);
    }

    protected String caughtunexpectedThrowable$str() {
        return caughtunexpectedThrowable;
    }

    @Override
    public final void failedToConnectToServer() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112020: " + this.failedToConnectToServer0$str(), new Object[0]);
    }

    protected String failedToConnectToServer0$str() {
        return failedToConnectToServer0;
    }

    @Override
    public final void errorRemovingConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114061: " + this.errorRemovingConsumer$str(), new Object[0]);
    }

    protected String errorRemovingConsumer$str() {
        return errorRemovingConsumer;
    }

    @Override
    public final void serverFinalisedWIthoutBeingSTopped() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112001: " + this.serverFinalisedWIthoutBeingSTopped$str(), new Object[0]);
    }

    protected String serverFinalisedWIthoutBeingSTopped$str() {
        return serverFinalisedWIthoutBeingSTopped;
    }

    @Override
    public final void problemCleaningPagesubscriptionCounter(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112062: " + this.problemCleaningPagesubscriptionCounter$str(), new Object[0]);
    }

    protected String problemCleaningPagesubscriptionCounter$str() {
        return problemCleaningPagesubscriptionCounter;
    }

    @Override
    public final void jvmAllocatedMoreMemory(Long totalMemory1, Long totalMemory2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112155: " + this.jvmAllocatedMoreMemory$str(), (Object)totalMemory1, (Object)totalMemory2);
    }

    protected String jvmAllocatedMoreMemory$str() {
        return jvmAllocatedMoreMemory;
    }

    @Override
    public final void serverIsLive(String identity) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111013: " + this.serverIsLive1$str(), (Object)identity);
    }

    protected String serverIsLive1$str() {
        return serverIsLive1;
    }

    @Override
    public final void journalCannotFindQueue(Long queue, Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114024: " + this.journalCannotFindQueue$str(), (Object)queue, (Object)id);
    }

    protected String journalCannotFindQueue$str() {
        return journalCannotFindQueue;
    }

    @Override
    public final void errorOnStompHeartBeat(InterruptedException e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112112: " + this.errorOnStompHeartBeat$str(), new Object[0]);
    }

    protected String errorOnStompHeartBeat$str() {
        return errorOnStompHeartBeat;
    }

    @Override
    public final void failedToCreateSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114032: " + this.failedToCreateSession$str(), new Object[0]);
    }

    protected String failedToCreateSession$str() {
        return failedToCreateSession;
    }

    @Override
    public final void errorDecrementingRefCount(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112204: " + this.errorDecrementingRefCount$str(), new Object[0]);
    }

    protected String errorDecrementingRefCount$str() {
        return errorDecrementingRefCount;
    }

    @Override
    public final void timeoutClosingSSL() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112119: " + this.timeoutClosingSSL$str(), new Object[0]);
    }

    protected String timeoutClosingSSL$str() {
        return timeoutClosingSSL;
    }

    @Override
    public final void failedToHandlePacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114010: " + this.failedToHandlePacket$str(), new Object[0]);
    }

    protected String failedToHandlePacket$str() {
        return failedToHandlePacket;
    }

    @Override
    public final void pageStoreTimeout(SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112074: " + this.pageStoreTimeout$str(), (Object)address);
    }

    protected String pageStoreTimeout$str() {
        return pageStoreTimeout;
    }

    @Override
    public final void errorCreatingNettyConnection(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114045: " + this.errorCreatingNettyConnection$str(), new Object[0]);
    }

    protected String errorCreatingNettyConnection$str() {
        return errorCreatingNettyConnection;
    }

    @Override
    public final void bridgeAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112176: " + this.bridgeAlreadyDeployed$str(), (Object)name);
    }

    protected String bridgeAlreadyDeployed$str() {
        return bridgeAlreadyDeployed;
    }

    @Override
    public final void noLocalMemborOnClusterConnection(ClusterConnectionImpl clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112190: " + this.noLocalMemborOnClusterConnection$str(), (Object)clusterConnection);
    }

    protected String noLocalMemborOnClusterConnection$str() {
        return noLocalMemborOnClusterConnection;
    }

    @Override
    public final void journalUnreferencedMessage(Long messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111023: " + this.journalUnreferencedMessage$str(), (Object)messageID);
    }

    protected String journalUnreferencedMessage$str() {
        return journalUnreferencedMessage;
    }

    @Override
    public final void errorStoppingRedistributor() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112187: " + this.errorStoppingRedistributor$str(), new Object[0]);
    }

    protected String errorStoppingRedistributor$str() {
        return errorStoppingRedistributor;
    }

    public final void managementStopError(Integer size, List unexpectedResourceNames) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112165: " + this.managementStopError$str(), (Object)size, (Object)unexpectedResourceNames);
    }

    protected String managementStopError$str() {
        return managementStopError;
    }

    @Override
    public final void pageStoreDropMessages(SimpleString storeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112077: " + this.pageStoreDropMessages$str(), (Object)storeName);
    }

    protected String pageStoreDropMessages$str() {
        return pageStoreDropMessages;
    }

    @Override
    public final void timeoutRemotingThreadPool() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112125: " + this.timeoutRemotingThreadPool$str(), new Object[0]);
    }

    protected String timeoutRemotingThreadPool$str() {
        return timeoutRemotingThreadPool;
    }

    @Override
    public final void journalInvalidRecordType(Byte recordType) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112087: " + this.journalInvalidRecordType$str(), (Object)recordType);
    }

    protected String journalInvalidRecordType$str() {
        return journalInvalidRecordType;
    }

    @Override
    public final void pageSubscriptionError(IOAsyncTask ioAsyncTask, String error) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114021: " + this.pageSubscriptionError$str(), (Object)ioAsyncTask, (Object)error);
    }

    protected String pageSubscriptionError$str() {
        return pageSubscriptionError;
    }

    @Override
    public final void errorCompletingContext(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112156: " + this.errorCompletingContext$str(), new Object[0]);
    }

    protected String errorCompletingContext$str() {
        return errorCompletingContext;
    }

    @Override
    public final void errorSettingIndex(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112036: " + this.errorSettingIndex$str(), new Object[0]);
    }

    protected String errorSettingIndex$str() {
        return errorSettingIndex;
    }

    @Override
    public final void journalcomparisonMismatch(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112132: " + this.journalcomparisonMismatch$str(), (Object)s);
    }

    protected String journalcomparisonMismatch$str() {
        return journalcomparisonMismatch;
    }

    @Override
    public final void duplicateMessageDetected(ServerMessage message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112098: " + this.duplicateMessageDetected$str(), (Object)message);
    }

    protected String duplicateMessageDetected$str() {
        return duplicateMessageDetected;
    }

    @Override
    public final void incompatibleVersionAfterConnect(int version, int clientVersion) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112105: " + this.incompatibleVersionAfterConnect$str(), (Object)version, (Object)clientVersion);
    }

    protected String incompatibleVersionAfterConnect$str() {
        return incompatibleVersionAfterConnect;
    }

    @Override
    public final void bridgeNoDiscoveryGroup(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112178: " + this.bridgeNoDiscoveryGroup$str(), (Object)name);
    }

    protected String bridgeNoDiscoveryGroup$str() {
        return bridgeNoDiscoveryGroup;
    }

    @Override
    public final void errorCallingInterceptor(Throwable e, Interceptor interceptor) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112108: " + this.errorCallingInterceptor$str(), (Object)interceptor);
    }

    protected String errorCallingInterceptor$str() {
        return errorCallingInterceptor;
    }

    @Override
    public final void bridgeFailedToAck(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114079: " + this.bridgeFailedToAck$str(), new Object[0]);
    }

    protected String bridgeFailedToAck$str() {
        return bridgeFailedToAck;
    }

    @Override
    public final void journalCannotFindQueueScheduled(Long queue, Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114025: " + this.journalCannotFindQueueScheduled$str(), (Object)queue, (Object)id);
    }

    protected String journalCannotFindQueueScheduled$str() {
        return journalCannotFindQueueScheduled;
    }

    @Override
    public final void problemCompletingOperations(OperationContext e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112061: " + this.problemCompletingOperations$str(), (Object)e);
    }

    protected String problemCompletingOperations$str() {
        return problemCompletingOperations;
    }

    @Override
    public final void errorRunningLargeMessageDeliverer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114066: " + this.errorRunningLargeMessageDeliverer$str(), new Object[0]);
    }

    protected String errorRunningLargeMessageDeliverer$str() {
        return errorRunningLargeMessageDeliverer;
    }

    @Override
    public final void reservingFileIDs(JournalStorageManager.JournalContent content, String actContent) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111029: " + this.reservingFileIDs$str(), (Object)content, (Object)actContent);
    }

    protected String reservingFileIDs$str() {
        return reservingFileIDs;
    }

    @Override
    public final void errorRestartingBackupServer(Exception e, HornetQServer backup) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114063: " + this.errorRestartingBackupServer$str(), (Object)backup);
    }

    protected String errorRestartingBackupServer$str() {
        return errorRestartingBackupServer;
    }

    @Override
    public final void bridgeStopping() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111033: " + this.bridgeStopping$str(), new Object[0]);
    }

    protected String bridgeStopping$str() {
        return bridgeStopping;
    }

    @Override
    public final void errorOnXMLTransform(Throwable t, Node n) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114076: " + this.errorOnXMLTransform$str(), (Object)n);
    }

    protected String errorOnXMLTransform$str() {
        return errorOnXMLTransform;
    }

    @Override
    public final void messageExceededMaxDeliveryNoDLA(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112202: " + this.messageExceededMaxDeliveryNoDLA$str(), (Object)name);
    }

    protected String messageExceededMaxDeliveryNoDLA$str() {
        return messageExceededMaxDeliveryNoDLA;
    }

    @Override
    public final void timedOutFlushingExecutorsPagingCursor(PageSubscription pageSubscription) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112065: " + this.timedOutFlushingExecutorsPagingCursor1$str(), (Object)pageSubscription);
    }

    protected String timedOutFlushingExecutorsPagingCursor1$str() {
        return timedOutFlushingExecutorsPagingCursor1;
    }

    @Override
    public final void bridgeConnected(BridgeImpl name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111032: " + this.bridgeConnected$str(), (Object)name);
    }

    protected String bridgeConnected$str() {
        return bridgeConnected;
    }

    @Override
    public final void bridgeNoQueue() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112174: " + this.bridgeNoQueue0$str(), new Object[0]);
    }

    protected String bridgeNoQueue0$str() {
        return bridgeNoQueue0;
    }

    @Override
    public final void AIONotFound() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112054: " + this.AIONotFound$str(), new Object[0]);
    }

    protected String AIONotFound$str() {
        return AIONotFound;
    }

    @Override
    public final void pageTxDeleteError(Exception e, long recordID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112072: " + this.pageTxDeleteError$str(), (Object)recordID);
    }

    protected String pageTxDeleteError$str() {
        return pageTxDeleteError;
    }

    @Override
    public final void errorSendingTopologyNodedown(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112047: " + this.errorSendingTopologyNodedown$str(), new Object[0]);
    }

    protected String errorSendingTopologyNodedown$str() {
        return "error sending topology";
    }

    @Override
    public final void nodeNotAvailable(String targetNodeID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112161: " + this.nodeNotAvailable$str(), (Object)targetNodeID);
    }

    protected String nodeNotAvailable$str() {
        return nodeNotAvailable;
    }

    @Override
    public final void unableToStartClusterConnection(Exception e, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112169: " + this.unableToStartClusterConnection$str(), (Object)name);
    }

    protected String unableToStartClusterConnection$str() {
        return unableToStartClusterConnection;
    }

    @Override
    public final void backupActivationProblem() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112013: " + this.backupActivationProblem$str(), new Object[0]);
    }

    protected String backupActivationProblem$str() {
        return backupActivationProblem;
    }

    @Override
    public final void duplicateMessageDetectedThruBridge(ServerMessage message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112097: " + this.duplicateMessageDetectedThruBridge$str(), (Object)message);
    }

    protected String duplicateMessageDetectedThruBridge$str() {
        return duplicateMessageDetectedThruBridge;
    }

    @Override
    public final void ioErrorAddingReferences(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112096: " + this.ioErrorAddingReferences$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorAddingReferences$str() {
        return ioErrorAddingReferences;
    }

    @Override
    public final void dumpingSessionStacks() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111014: " + this.dumpingSessionStacks$str(), new Object[0]);
    }

    protected String dumpingSessionStacks$str() {
        return dumpingSessionStacks;
    }

    @Override
    public final void noVersionOnClasspath(String classpath) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112154: " + this.noVersionOnClasspath$str(), (Object)classpath);
    }

    protected String noVersionOnClasspath$str() {
        return noVersionOnClasspath;
    }

    @Override
    public final void errorCallingRepoListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114073: " + this.errorCallingRepoListener$str(), new Object[0]);
    }

    protected String errorCallingRepoListener$str() {
        return errorCallingRepoListener;
    }

    @Override
    public final void errorExpiringReferencesOnQueue(Exception e, MessageReference ref) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112197: " + this.errorExpiringReferencesOnQueue$str(), (Object)ref);
    }

    protected String errorExpiringReferencesOnQueue$str() {
        return errorExpiringReferencesOnQueue;
    }

    @Override
    public final void errorQueryingBridge(Throwable t, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, t, "HQ112142: " + this.errorQueryingBridge1$str(), (Object)name);
    }

    protected String errorQueryingBridge1$str() {
        return errorQueryingBridge1;
    }

    @Override
    public final void errorExpiringMessages(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114027: " + this.errorExpiringMessages$str(), new Object[0]);
    }

    protected String errorExpiringMessages$str() {
        return errorExpiringMessages;
    }

    @Override
    public final void pageNotFound(PagePosition pos) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112066: " + this.pageNotFound$str(), (Object)pos);
    }

    protected String pageNotFound$str() {
        return pageNotFound;
    }

    @Override
    public final void journalInvalidRecordTypeOnPreparedTX(Byte recordType) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112088: " + this.journalInvalidRecordTypeOnPreparedTX$str(), (Object)recordType);
    }

    protected String journalInvalidRecordTypeOnPreparedTX$str() {
        return journalInvalidRecordTypeOnPreparedTX;
    }

    @Override
    public final void errorCallingEnd(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114006: " + this.errorCallingEnd$str(), new Object[0]);
    }

    protected String errorCallingEnd$str() {
        return errorCallingEnd;
    }

    @Override
    public final void failedToConnectToServer(Integer reconnectAttempts) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112021: " + this.failedToConnectToServer1$str(), (Object)reconnectAttempts);
    }

    protected String failedToConnectToServer1$str() {
        return failedToConnectToServer1;
    }

    @Override
    public final void errorOnStompPingFrame(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114041: " + this.errorOnStompPingFrame$str(), new Object[0]);
    }

    protected String errorOnStompPingFrame$str() {
        return errorOnStompPingFrame;
    }

    @Override
    public final void dumpServerInfo(String serverInfo) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111006: " + this.dumpServerInfo$str(), (Object)serverInfo);
    }

    protected String dumpServerInfo$str() {
        return "{0}";
    }

    @Override
    public final void journalCannotFindQueueReloadingACK(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112085: " + this.journalCannotFindQueueReloadingACK$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingACK$str() {
        return journalCannotFindQueueReloadingACK;
    }

    @Override
    public final void stompTXAckNorSupported() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112111: " + this.stompTXAckNorSupported$str(), new Object[0]);
    }

    protected String stompTXAckNorSupported$str() {
        return stompTXAckNorSupported;
    }

    @Override
    public final void incompatibleVersion(Integer version, String remoteAddress, String fullVersion) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112104: " + this.incompatibleVersion$str(), (Object)version, (Object)remoteAddress, (Object)fullVersion);
    }

    protected String incompatibleVersion$str() {
        return incompatibleVersion;
    }

    @Override
    public final void errorRemovingMessage(Throwable e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112205: " + this.errorRemovingMessage$str(), (Object)messageID);
    }

    protected String errorRemovingMessage$str() {
        return errorRemovingMessage;
    }

    @Override
    public final void timedOutWaitingForScheduledPoolTermination() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112043: " + this.timedOutWaitingForScheduledPoolTermination$str(), new Object[0]);
    }

    protected String timedOutWaitingForScheduledPoolTermination$str() {
        return timedOutWaitingForScheduledPoolTermination;
    }

    @Override
    public final void failedToHandleFailover(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114005: " + this.failedToHandleFailover$str(), new Object[0]);
    }

    protected String failedToHandleFailover$str() {
        return failedToHandleFailover;
    }

    @Override
    public final void journalErrorConfirmingLargeMessage(Throwable e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112099: " + this.journalErrorConfirmingLargeMessage$str(), (Object)messageID);
    }

    protected String journalErrorConfirmingLargeMessage$str() {
        return journalErrorConfirmingLargeMessage;
    }

    @Override
    public final void errorUpdatingTopology(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114057: " + this.errorUpdatingTopology$str(), new Object[0]);
    }

    protected String errorUpdatingTopology$str() {
        return errorUpdatingTopology;
    }

    @Override
    public final void errorClosingServerLocator(Exception e, ServerLocatorInternal clusterLocator) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112167: " + this.errorClosingServerLocator$str(), (Object)clusterLocator);
    }

    protected String errorClosingServerLocator$str() {
        return errorClosingServerLocator;
    }

    @Override
    public final void replicationStartProblem(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112010: " + this.replicationStartProblem$str(), new Object[0]);
    }

    protected String replicationStartProblem$str() {
        return replicationStartProblem;
    }

    @Override
    public final void backupAnnounced() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111036: " + this.backupAnnounced$str(), new Object[0]);
    }

    protected String backupAnnounced$str() {
        return backupAnnounced;
    }

    @Override
    public final void errorHandlingMessage(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114058: " + this.errorHandlingMessage$str(), new Object[0]);
    }

    protected String errorHandlingMessage$str() {
        return errorHandlingMessage;
    }

    @Override
    public final void errorFinalisingCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112040: " + this.errorFinalisingCache$str(), new Object[0]);
    }

    protected String errorFinalisingCache$str() {
        return errorFinalisingCache;
    }

    @Override
    public final void percentLoaded(Long percent) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111018: " + this.percentLoaded$str(), (Object)percent);
    }

    protected String percentLoaded$str() {
        return percentLoaded;
    }

    @Override
    public final void broadcastBridgeStoppedError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112211: " + this.broadcastBridgeStoppedError$str(), new Object[0]);
    }

    protected String broadcastBridgeStoppedError$str() {
        return "unable to send notification when broadcast group is stopped";
    }

    @Override
    public final void unableToCloseSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112019: " + this.unableToCloseSession$str(), new Object[0]);
    }

    protected String unableToCloseSession$str() {
        return unableToCloseSession;
    }

    @Override
    public final void largeMessageNotAvailable(long messageId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112134: " + this.largeMessageNotAvailable$str(), (Object)messageId);
    }

    protected String largeMessageNotAvailable$str() {
        return largeMessageNotAvailable;
    }

    @Override
    public final void errorStoppingServer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112012: " + this.errorStoppingServer$str(), new Object[0]);
    }

    protected String errorStoppingServer$str() {
        return errorStoppingServer;
    }

    @Override
    public final void errorBrowserHandlingMessage(Exception e, MessageReference current) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114067: " + this.errorBrowserHandlingMessage$str(), (Object)current);
    }

    protected String errorBrowserHandlingMessage$str() {
        return errorBrowserHandlingMessage;
    }

    @Override
    public final void clientConnectionFailed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112100: " + this.clientConnectionFailed$str(), (Object)name);
    }

    protected String clientConnectionFailed$str() {
        return clientConnectionFailed;
    }

    @Override
    public final void ioDiscoveryError(String hostAddress, String s) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112213: " + this.ioDiscoveryError$str(), (Object)hostAddress, (Object)s);
    }

    protected String ioDiscoveryError$str() {
        return ioDiscoveryError;
    }

    @Override
    public final void notificationBridgeStoppedError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112212: " + this.notificationBridgeStoppedError$str(), new Object[0]);
    }

    protected String notificationBridgeStoppedError$str() {
        return "unable to send notification when broadcast group is stopped";
    }

    @Override
    public final void timedOutFlushingExecutorsPagingCursor(FutureLatch future, Executor executor) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112059: " + this.timedOutFlushingExecutorsPagingCursor2$str(), (Object)future, (Object)executor);
    }

    protected String timedOutFlushingExecutorsPagingCursor2$str() {
        return timedOutFlushingExecutorsPagingCursor2;
    }

    @Override
    public final void announceBackupNoConnector(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112171: " + this.announceBackupNoConnector$str(), (Object)connectorName);
    }

    protected String announceBackupNoConnector$str() {
        return announceBackupNoConnector;
    }

    @Override
    public final void nettyChannelGroupBindError() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112117: " + this.nettyChannelGroupBindError$str(), new Object[0]);
    }

    protected String nettyChannelGroupBindError$str() {
        return nettyChannelGroupBindError;
    }

    @Override
    public final void initializationError(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114002: " + this.initializationError$str(), new Object[0]);
    }

    protected String initializationError$str() {
        return initializationError;
    }

    @Override
    public final void journalCannotFindQueueReloadingPage(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111020: " + this.journalCannotFindQueueReloadingPage$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingPage$str() {
        return journalCannotFindQueueReloadingPage;
    }

    @Override
    public final void errorWritingToInvmConnector(Exception e, Runnable runnable) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114042: " + this.errorWritingToInvmConnector$str(), (Object)runnable);
    }

    protected String errorWritingToInvmConnector$str() {
        return errorWritingToInvmConnector;
    }

    @Override
    public final void broadcastGroupBindError() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112159: " + this.broadcastGroupBindError$str(), new Object[0]);
    }

    protected String broadcastGroupBindError$str() {
        return broadcastGroupBindError;
    }

    @Override
    public final void problemCleaningPageAddress(Exception e, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112060: " + this.problemCleaningPageAddress$str(), (Object)address);
    }

    protected String problemCleaningPageAddress$str() {
        return problemCleaningPageAddress;
    }

    @Override
    public final void replicationStopOnBackupShutdown() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112136: " + this.replicationStopOnBackupShutdown$str(), new Object[0]);
    }

    protected String replicationStopOnBackupShutdown$str() {
        return replicationStopOnBackupShutdown;
    }

    @Override
    public final void errorProcessingIOCallback(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112102: " + this.errorProcessingIOCallback$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String errorProcessingIOCallback$str() {
        return errorProcessingIOCallback;
    }

    @Override
    public final void errorSendingNotifOnDiscoveryStop(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112049: " + this.errorSendingNotifOnDiscoveryStop$str(), new Object[0]);
    }

    protected String errorSendingNotifOnDiscoveryStop$str() {
        return errorSendingNotifOnDiscoveryStop;
    }

    @Override
    public final void warn(String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112016: " + this.warn$str(), (Object)message);
    }

    protected String warn$str() {
        return "{0}";
    }

    @Override
    public final void deployQueue(SimpleString queueName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111005: " + this.deployQueue$str(), (Object)queueName);
    }

    protected String deployQueue$str() {
        return deployQueue;
    }

    @Override
    public final void pageSubscriptionCouldntLoad(long transactionID, PagePosition position, SimpleString address, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ112067: " + this.pageSubscriptionCouldntLoad$str(), transactionID, position, address, name);
    }

    protected String pageSubscriptionCouldntLoad$str() {
        return pageSubscriptionCouldntLoad;
    }

    @Override
    public final void clusterSecurityRisk() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112008: " + this.clusterSecurityRisk$str(), new Object[0]);
    }

    protected String clusterSecurityRisk$str() {
        return clusterSecurityRisk;
    }

    @Override
    public final void timedOutStoppingDiscovery() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112048: " + this.timedOutStoppingDiscovery$str(), new Object[0]);
    }

    protected String timedOutStoppingDiscovery$str() {
        return timedOutStoppingDiscovery;
    }

    @Override
    public final void resettingSessionAfterFailure() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112025: " + this.resettingSessionAfterFailure$str(), new Object[0]);
    }

    protected String resettingSessionAfterFailure$str() {
        return resettingSessionAfterFailure;
    }

    @Override
    public final void errorDecodingPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114036: " + this.errorDecodingPacket$str(), new Object[0]);
    }

    protected String errorDecodingPacket$str() {
        return errorDecodingPacket;
    }

    @Override
    public final void serverStopped(String version, SimpleString nodeId) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111004: " + this.serverStopped$str(), (Object)version, (Object)nodeId);
    }

    protected String serverStopped$str() {
        return serverStopped;
    }

    @Override
    public final void invalidAcceptorKeys(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112123: " + this.invalidAcceptorKeys$str(), (Object)s);
    }

    protected String invalidAcceptorKeys$str() {
        return invalidAcceptorKeys;
    }

    @Override
    public final void connectorWithNoName() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112052: " + this.connectorWithNoName$str(), new Object[0]);
    }

    protected String connectorWithNoName$str() {
        return connectorWithNoName;
    }

    @Override
    public final void largeMessageErrorReleasingResources(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114026: " + this.largeMessageErrorReleasingResources$str(), new Object[0]);
    }

    protected String largeMessageErrorReleasingResources$str() {
        return largeMessageErrorReleasingResources;
    }

    @Override
    public final void journalCannotFindQueueForMessage(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112081: " + this.journalCannotFindQueueForMessage$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueForMessage$str() {
        return journalCannotFindQueueForMessage;
    }

    @Override
    public final void errorStoppingReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112015: " + this.errorStoppingReplication$str(), new Object[0]);
    }

    protected String errorStoppingReplication$str() {
        return errorStoppingReplication;
    }

    @Override
    public final void errorHandlingReplicationPacket(Exception e, Packet packet) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112130: " + this.errorHandlingReplicationPacket$str(), (Object)packet);
    }

    protected String errorHandlingReplicationPacket$str() {
        return errorHandlingReplicationPacket;
    }

    @Override
    public final void managementAttributeError(Exception e, String att, String resourceName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112164: " + this.managementAttributeError$str(), (Object)att, (Object)resourceName);
    }

    protected String managementAttributeError$str() {
        return managementAttributeError;
    }

    @Override
    public final void connectionFailureDetected(String message, HornetQExceptionType type) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112107: " + this.connectionFailureDetected$str(), (Object)message, (Object)type);
    }

    protected String connectionFailureDetected$str() {
        return connectionFailureDetected;
    }

    @Override
    public final void failedToStartDiscovery(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114012: " + this.failedToStartDiscovery$str(), new Object[0]);
    }

    protected String failedToStartDiscovery$str() {
        return failedToStartDiscovery;
    }

    @Override
    public final void errorFlushingExecutorsOnQueue() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112196: " + this.errorFlushingExecutorsOnQueue$str(), new Object[0]);
    }

    protected String errorFlushingExecutorsOnQueue$str() {
        return errorFlushingExecutorsOnQueue;
    }

    @Override
    public final void journalUseNIO() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111017: " + this.journalUseNIO$str(), new Object[0]);
    }

    protected String journalUseNIO$str() {
        return journalUseNIO;
    }

    @Override
    public final void errorResttingLargeMessage(Throwable e, Object deliverer) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112194: " + this.errorResttingLargeMessage$str(), deliverer);
    }

    protected String errorResttingLargeMessage$str() {
        return errorResttingLargeMessage;
    }

    @Override
    public final void retryCreateSessionSeverStarting(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112026: " + this.retryCreateSessionSeverStarting$str(), (Object)name);
    }

    protected String retryCreateSessionSeverStarting$str() {
        return retryCreateSessionSeverStarting;
    }

    @Override
    public final void timeOutWaitingForProcessing() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112018: " + this.timeOutWaitingForProcessing$str(), new Object[0]);
    }

    protected String timeOutWaitingForProcessing$str() {
        return timeOutWaitingForProcessing;
    }

    @Override
    public final void serverRestartWarning(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112009: " + this.serverRestartWarning$str(), new Object[0]);
    }

    protected String serverRestartWarning$str() {
        return serverRestartWarning;
    }

    @Override
    public final void pageInvalid(String fileName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112068: " + this.pageInvalid$str(), (Object)fileName, (Object)name);
    }

    protected String pageInvalid$str() {
        return pageInvalid;
    }

    @Override
    public final void failedToExecuteListener(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114004: " + this.failedToExecuteListener$str(), new Object[0]);
    }

    protected String failedToExecuteListener$str() {
        return "Failed to execute failure listener";
    }

    @Override
    public final void unableToStartBridge(Exception e, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112170: " + this.unableToStartBridge$str(), (Object)name);
    }

    protected String unableToStartBridge$str() {
        return unableToStartBridge;
    }

    @Override
    public final void waitingForRetry(Long interval, Long retryInterval, Double multiplier) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112022: " + this.waitingForRetry$str(), (Object)interval, (Object)retryInterval, (Object)multiplier);
    }

    protected String waitingForRetry$str() {
        return waitingForRetry;
    }

    @Override
    public final void errorReadingIndex(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112035: " + this.errorReadingIndex$str(), new Object[0]);
    }

    protected String errorReadingIndex$str() {
        return errorReadingIndex;
    }

    @Override
    public final void errorEncodingStompPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114040: " + this.errorEncodingStompPacket$str(), new Object[0]);
    }

    protected String errorEncodingStompPacket$str() {
        return errorEncodingStompPacket;
    }

    @Override
    public final void managementOperationError(Exception e, String op, String resourceName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112163: " + this.managementOperationError$str(), (Object)op, (Object)resourceName);
    }

    protected String managementOperationError$str() {
        return managementOperationError;
    }

    @Override
    public final void clearingUpSession(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112101: " + this.clearingUpSession$str(), (Object)name);
    }

    protected String clearingUpSession$str() {
        return "Cleared up resources for session {0}";
    }

    @Override
    public final void journalMessageInPreparedTX(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112083: " + this.journalMessageInPreparedTX$str(), (Object)queueID);
    }

    protected String journalMessageInPreparedTX$str() {
        return journalMessageInPreparedTX;
    }

    @Override
    public final void noDLA(SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112095: " + this.noDLA$str(), (Object)address);
    }

    protected String noDLA$str() {
        return noDLA;
    }

    @Override
    public final void memoryError(Integer memoryWarningThreshold, String info) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112208: " + this.memoryError$str(), (Object)memoryWarningThreshold, (Object)info);
    }

    protected String memoryError$str() {
        return memoryError;
    }

    @Override
    public final void errorReceivingPAcketInDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112051: " + this.errorReceivingPAcketInDiscovery$str(), new Object[0]);
    }

    protected String errorReceivingPAcketInDiscovery$str() {
        return errorReceivingPAcketInDiscovery;
    }

    @Override
    public final void journalPAGEOnPrepared() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112086: " + this.journalPAGEOnPrepared$str(), new Object[0]);
    }

    protected String journalPAGEOnPrepared$str() {
        return journalPAGEOnPrepared;
    }

    @Override
    public final void sessionNotXA() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114008: " + this.sessionNotXA$str(), new Object[0]);
    }

    protected String sessionNotXA$str() {
        return sessionNotXA;
    }

    @Override
    public final void errorConnectingBridge(Exception e, Bridge bridge) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112145: " + this.errorConnectingBridge$str(), (Object)bridge);
    }

    protected String errorConnectingBridge$str() {
        return errorConnectingBridge;
    }

    @Override
    public final void caughtXaException(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114029: " + this.caughtXaException$str(), new Object[0]);
    }

    protected String caughtXaException$str() {
        return caughtXaException;
    }

    @Override
    public final void messageWithDuplicateID(Object duplicateProperty, SimpleString toAddress, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111042: " + this.messageWithDuplicateID3$str(), duplicateProperty, (Object)toAddress, (Object)address);
    }

    protected String messageWithDuplicateID3$str() {
        return messageWithDuplicateID3;
    }

    @Override
    public final void errorClosingFlowRecord(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114056: " + this.errorClosingFlowRecord$str(), new Object[0]);
    }

    protected String errorClosingFlowRecord$str() {
        return errorClosingFlowRecord;
    }

    @Override
    public final void problemUndeployingNode(Exception e, Node node) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112057: " + this.problemUndeployingNode$str(), (Object)node);
    }

    protected String problemUndeployingNode$str() {
        return problemUndeployingNode;
    }

    @Override
    public final void removingBadConsumer(Throwable e, Consumer consumer, MessageReference reference) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112203: " + this.removingBadConsumer$str(), (Object)consumer, (Object)reference);
    }

    protected String removingBadConsumer$str() {
        return removingBadConsumer;
    }

    @Override
    public final void messageExceededMaxDelivery(MessageReference ref, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112200: " + this.messageExceededMaxDelivery$str(), (Object)ref, (Object)name);
    }

    protected String messageExceededMaxDelivery$str() {
        return messageExceededMaxDelivery;
    }

    @Override
    public final void serverIsLive() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111009: " + this.serverIsLive0$str(), new Object[0]);
    }

    protected String serverIsLive0$str() {
        return serverIsLive0;
    }

    @Override
    public final void errorflushingInvmChannel(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114043: " + this.errorflushingInvmChannel$str(), new Object[0]);
    }

    protected String errorflushingInvmChannel$str() {
        return errorflushingInvmChannel;
    }

    @Override
    public final void errorOnFailureCheck(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112126: " + this.errorOnFailureCheck$str(), new Object[0]);
    }

    protected String errorOnFailureCheck$str() {
        return errorOnFailureCheck;
    }

    @Override
    public final void errorCompletingReplicationCallback(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112135: " + this.errorCompletingReplicationCallback$str(), new Object[0]);
    }

    protected String errorCompletingReplicationCallback$str() {
        return "Error completing callback on replication manager";
    }

    @Override
    public final void journalSynch(JournalFile jf, Long size, SequentialFile file) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111030: " + this.journalSynch$str(), (Object)jf, (Object)size, (Object)file);
    }

    protected String journalSynch$str() {
        return journalSynch;
    }

    @Override
    public final void bridgeStopped(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111034: " + this.bridgeStopped$str(), (Object)name);
    }

    protected String bridgeStopped$str() {
        return bridgeStopped;
    }

    @Override
    public final void errorCheckingDLQ(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112206: " + this.errorCheckingDLQ$str(), new Object[0]);
    }

    protected String errorCheckingDLQ$str() {
        return errorCheckingDLQ;
    }

    @Override
    public final void errorStartingReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112014: " + this.errorStartingReplication0$str(), new Object[0]);
    }

    protected String errorStartingReplication0$str() {
        return errorStartingReplication0;
    }

    @Override
    public final void failedToStopDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114011: " + this.failedToStopDiscovery$str(), new Object[0]);
    }

    protected String failedToStopDiscovery$str() {
        return failedToStopDiscovery;
    }

    @Override
    public final void unexpectedNettyVersion(String nettyVersion, String id) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112114: " + this.unexpectedNettyVersion$str(), (Object)nettyVersion, (Object)id);
    }

    protected String unexpectedNettyVersion$str() {
        return unexpectedNettyVersion;
    }

    @Override
    public final void errorAckingOldReference(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114059: " + this.errorAckingOldReference$str(), new Object[0]);
    }

    protected String errorAckingOldReference$str() {
        return errorAckingOldReference;
    }

    @Override
    public final void errorDeletingDuplicateCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112093: " + this.errorDeletingDuplicateCache$str(), new Object[0]);
    }

    protected String errorDeletingDuplicateCache$str() {
        return errorDeletingDuplicateCache;
    }

    @Override
    public final void onMessageError(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114001: " + this.onMessageError$str(), new Object[0]);
    }

    protected String onMessageError$str() {
        return onMessageError;
    }

    @Override
    public final void unableToDeleteGroupBindings(Exception e, SimpleString groupId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112166: " + this.unableToDeleteGroupBindings$str(), (Object)groupId);
    }

    protected String unableToDeleteGroupBindings$str() {
        return unableToDeleteGroupBindings;
    }

    @Override
    public final void errorScanningURLs(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112056: " + this.errorScanningURLs$str(), new Object[0]);
    }

    protected String errorScanningURLs$str() {
        return errorScanningURLs;
    }

    @Override
    public final void pageStoreStart(SimpleString storeName, long addressSize, long maxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112076: " + this.pageStoreStart$str(), (Object)storeName, (Object)addressSize, (Object)maxSize);
    }

    protected String pageStoreStart$str() {
        return pageStoreStart;
    }

    public final void deletingPendingMessage(Pair msgToDelete) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111007: " + this.deletingPendingMessage$str(), (Object)msgToDelete);
    }

    protected String deletingPendingMessage$str() {
        return deletingPendingMessage;
    }

    @Override
    public final void bridgeConnectionFailed(Exception e, Boolean failedOver) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112141: " + this.bridgeConnectionFailed$str(), (Object)failedOver);
    }

    protected String bridgeConnectionFailed$str() {
        return bridgeConnectionFailed;
    }

    @Override
    public final void backupServerStarted(String version, SimpleString nodeID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ001111: " + this.backupServerStarted$str(), (Object)version, (Object)nodeID);
    }

    protected String backupServerStarted$str() {
        return backupServerStarted;
    }

    @Override
    public final void journalCannotFindMessageDelCount(Long msg) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112080: " + this.journalCannotFindMessageDelCount$str(), (Object)msg);
    }

    protected String journalCannotFindMessageDelCount$str() {
        return journalCannotFindMessageDelCount;
    }

    @Override
    public final void bridgeLocatorShutdown() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112146: " + this.bridgeLocatorShutdown$str(), new Object[0]);
    }

    protected String bridgeLocatorShutdown$str() {
        return bridgeLocatorShutdown;
    }

    @Override
    public final void errorCallingNotifListener(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114072: " + this.errorCallingNotifListener$str(), new Object[0]);
    }

    protected String errorCallingNotifListener$str() {
        return errorCallingNotifListener;
    }

    @Override
    public final void errorCallingCancel(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112034: " + this.errorCallingCancel$str(), new Object[0]);
    }

    protected String errorCallingCancel$str() {
        return errorCallingCancel;
    }

    @Override
    public final void errorReConnecting(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112148: " + this.errorReConnecting$str(), new Object[0]);
    }

    protected String errorReConnecting$str() {
        return errorReConnecting;
    }

    @Override
    public final void pageDeleteError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112069: " + this.pageDeleteError$str(), new Object[0]);
    }

    protected String pageDeleteError$str() {
        return pageDeleteError;
    }

    @Override
    public final void ioErrorShutdownServer(HornetQExceptionType code, String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112011: " + this.ioErrorShutdownServer$str(), (Object)code, (Object)message);
    }

    protected String ioErrorShutdownServer$str() {
        return ioErrorShutdownServer;
    }

    @Override
    public final void replicationStopOnBackupFail(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112137: " + this.replicationStopOnBackupFail$str(), new Object[0]);
    }

    protected String replicationStopOnBackupFail$str() {
        return replicationStopOnBackupFail;
    }

    @Override
    public final void invalidPacketForReplication(Packet packet) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112129: " + this.invalidPacketForReplication$str(), (Object)packet);
    }

    protected String invalidPacketForReplication$str() {
        return invalidPacketForReplication;
    }

    @Override
    public final void failedToCallListenerInDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114014: " + this.failedToCallListenerInDiscovery$str(), new Object[0]);
    }

    protected String failedToCallListenerInDiscovery$str() {
        return failedToCallListenerInDiscovery;
    }

    @Override
    public final void bridgeNotificationOnGroupStopped(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112139: " + this.bridgeNotificationOnGroupStopped$str(), new Object[0]);
    }

    protected String bridgeNotificationOnGroupStopped$str() {
        return bridgeNotificationOnGroupStopped;
    }

    @Override
    public final void errorStoppingAcceptor() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114046: " + this.errorStoppingAcceptor$str(), new Object[0]);
    }

    protected String errorStoppingAcceptor$str() {
        return errorStoppingAcceptor;
    }

    @Override
    public final void errorClosingConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114055: " + this.errorClosingConsumer$str(), new Object[0]);
    }

    protected String errorClosingConsumer$str() {
        return errorClosingConsumer;
    }

    @Override
    public final void errorCallingFailureListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114037: " + this.errorCallingFailureListener$str(), new Object[0]);
    }

    protected String errorCallingFailureListener$str() {
        return "Failed to execute failure listener";
    }

    @Override
    public final void errorExecutingIOAsyncTask(Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, "HQ112092: " + this.errorExecutingIOAsyncTask$str(), new Object[0]);
    }

    protected String errorExecutingIOAsyncTask$str() {
        return errorExecutingIOAsyncTask;
    }

    @Override
    public final void cannotFindMessage(Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114023: " + this.cannotFindMessage$str(), (Object)id);
    }

    protected String cannotFindMessage$str() {
        return cannotFindMessage;
    }

    @Override
    public final void clusterConnectionNoConnector(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112181: " + this.clusterConnectionNoConnector$str(), (Object)connectorName);
    }

    protected String clusterConnectionNoConnector$str() {
        return clusterConnectionNoConnector;
    }

    @Override
    public final void largeMessageIncomatible() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114047: " + this.largeMessageIncomatible$str(), new Object[0]);
    }

    protected String largeMessageIncomatible$str() {
        return largeMessageIncomatible;
    }

    @Override
    public final void broadcastGroupNoConnector(String connectorName, String bgName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112185: " + this.broadcastGroupNoConnector$str(), (Object)connectorName, (Object)bgName);
    }

    protected String broadcastGroupNoConnector$str() {
        return broadcastGroupNoConnector;
    }

    @Override
    public final void serverRestartWarning() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112009: " + this.serverRestartWarning$str(), new Object[0]);
    }

    @Override
    public final void errorPausingBridge(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114053: " + this.errorPausingBridge$str(), new Object[0]);
    }

    protected String errorPausingBridge$str() {
        return errorPausingBridge;
    }

    @Override
    public final void failedToReattachSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114033: " + this.failedToReattachSession$str(), new Object[0]);
    }

    protected String failedToReattachSession$str() {
        return failedToReattachSession;
    }

    @Override
    public final void commitAfterFailover() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112027: " + this.commitAfterFailover$str(), new Object[0]);
    }

    protected String commitAfterFailover$str() {
        return commitAfterFailover;
    }

    @Override
    public final void errorClosingPageOnReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112131: " + this.errorClosingPageOnReplication$str(), new Object[0]);
    }

    protected String errorClosingPageOnReplication$str() {
        return errorClosingPageOnReplication;
    }

    @Override
    public final void errorStartingConnectorService(Throwable e, String name) {
        this.log.logv(FQCN, Logger.Level.INFO, e, "HQ111026: " + this.errorStartingConnectorService$str(), (Object)name);
    }

    protected String errorStartingConnectorService$str() {
        return errorStartingConnectorService;
    }

    @Override
    public final void lareMessageErrorCopying(Exception e, LargeServerMessage largeServerMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112091: " + this.lareMessageErrorCopying$str(), (Object)largeServerMessage);
    }

    protected String lareMessageErrorCopying$str() {
        return lareMessageErrorCopying;
    }

    @Override
    public final void errorCallingLifeCycleListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114044: " + this.errorCallingLifeCycleListener$str(), new Object[0]);
    }

    protected String errorCallingLifeCycleListener$str() {
        return errorCallingLifeCycleListener;
    }

    @Override
    public final void autoFailBackDenied() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114080: " + this.autoFailBackDenied$str(), new Object[0]);
    }

    protected String autoFailBackDenied$str() {
        return autoFailBackDenied;
    }

    @Override
    public final void errorDeployingURI(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, "HQ114016: " + this.errorDeployingURI0$str(), new Object[0]);
    }

    protected String errorDeployingURI0$str() {
        return errorDeployingURI0;
    }

    @Override
    public final void journalErrorRemovingRef(Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112084: " + this.journalErrorRemovingRef$str(), (Object)messageID);
    }

    protected String journalErrorRemovingRef$str() {
        return journalErrorRemovingRef;
    }

    @Override
    public final void pageStoreStartIOError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112075: " + this.pageStoreStartIOError$str(), new Object[0]);
    }

    protected String pageStoreStartIOError$str() {
        return pageStoreStartIOError;
    }

    @Override
    public final void bridgeNoBindings(SimpleString name, SimpleString forwardingAddress, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111031: " + this.bridgeNoBindings$str(), (Object)name, (Object)forwardingAddress, (Object)address);
    }

    protected String bridgeNoBindings$str() {
        return bridgeNoBindings;
    }

    @Override
    public final void errorExpiringRef(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114060: " + this.errorExpiringRef$str(), new Object[0]);
    }

    protected String errorExpiringRef$str() {
        return errorExpiringRef;
    }

    @Override
    public final void waitingToBecomeBackup() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111037: " + this.waitingToBecomeBackup$str(), new Object[0]);
    }

    protected String waitingToBecomeBackup$str() {
        return waitingToBecomeBackup;
    }

    @Override
    public final void factoryLeftOpen(Exception e, int i) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112024: " + this.factoryLeftOpen$str(), (Object)i);
    }

    protected String factoryLeftOpen$str() {
        return factoryLeftOpen;
    }

    @Override
    public final void messageWithDuplicateID(Object duplicateProperty, SimpleString toAddress, SimpleString address, SimpleString simpleString) {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ111041: " + this.messageWithDuplicateID4$str(), duplicateProperty, toAddress, address, simpleString);
    }

    protected String messageWithDuplicateID4$str() {
        return messageWithDuplicateID4;
    }

    @Override
    public final void errorClosingSessionsWhileStoppingServer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112002: " + this.errorClosingSessionsWhileStoppingServer$str(), new Object[0]);
    }

    protected String errorClosingSessionsWhileStoppingServer$str() {
        return errorClosingSessionsWhileStoppingServer;
    }

    @Override
    public final void reattachRequestFailed(String remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112106: " + this.reattachRequestFailed$str(), (Object)remoteAddress);
    }

    protected String reattachRequestFailed$str() {
        return reattachRequestFailed;
    }

    @Override
    public final void failedToReceiveDatagramInDiscovery(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114013: " + this.failedToReceiveDatagramInDiscovery$str(), new Object[0]);
    }

    protected String failedToReceiveDatagramInDiscovery$str() {
        return failedToReceiveDatagramInDiscovery;
    }

    @Override
    public final void errorTimingOutTX(Exception e, Xid xid) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114074: " + this.errorTimingOutTX$str(), (Object)xid);
    }

    protected String errorTimingOutTX$str() {
        return errorTimingOutTX;
    }

    @Override
    public final void divertWithNoAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112005: " + this.divertWithNoAddress$str(), new Object[0]);
    }

    protected String divertWithNoAddress$str() {
        return divertWithNoAddress;
    }

    @Override
    public final void nettyChannelStillOpen(Channel channel, SocketAddress remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112116: " + this.nettyChannelStillOpen$str(), (Object)channel, (Object)remoteAddress);
    }

    protected String nettyChannelStillOpen$str() {
        return nettyChannelStillOpen;
    }

    @Override
    public final void errorRemovingTempQueue(Exception e, SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114069: " + this.errorRemovingTempQueue$str(), (Object)bindingName);
    }

    protected String errorRemovingTempQueue$str() {
        return errorRemovingTempQueue;
    }

    @Override
    public final void invalidPacket(Packet packet) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114031: " + this.invalidPacket$str(), (Object)packet);
    }

    protected String invalidPacket$str() {
        return invalidPacket;
    }

    @Override
    public final void backupServerSynched(HornetQServerImpl server) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111028: " + this.backupServerSynched$str(), (Object)server);
    }

    protected String backupServerSynched$str() {
        return backupServerSynched;
    }

    @Override
    public final void cannotFindPacketToClear(Integer lastReceivedCommandID, Integer firstStoredCommandID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112103: " + this.cannotFindPacketToClear$str(), (Object)lastReceivedCommandID, (Object)firstStoredCommandID);
    }

    protected String cannotFindPacketToClear$str() {
        return cannotFindPacketToClear;
    }

    @Override
    public final void errorCompletingCallbackOnReplicationManager(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112209: " + this.errorCompletingCallbackOnReplicationManager$str(), new Object[0]);
    }

    protected String errorCompletingCallbackOnReplicationManager$str() {
        return "Error completing callback on replication manager";
    }

    @Override
    public final void errorAnnouncingBackup(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112189: " + this.errorAnnouncingBackup$str(), new Object[0]);
    }

    protected String errorAnnouncingBackup$str() {
        return errorAnnouncingBackup;
    }

    @Override
    public final void propertyNotLong(String propName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112152: " + this.propertyNotLong$str(), (Object)propName, (Object)name);
    }

    protected String propertyNotLong$str() {
        return propertyNotLong;
    }

    @Override
    public final void divertWithNoName() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112004: " + this.divertWithNoName$str(), new Object[0]);
    }

    protected String divertWithNoName$str() {
        return divertWithNoName;
    }

    @Override
    public final void clientConnectionFailedClearingSession(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112158: " + this.clientConnectionFailedClearingSession$str(), (Object)name);
    }

    protected String clientConnectionFailedClearingSession$str() {
        return "Cleared up resources for session {0}";
    }

    @Override
    public final void errorIncrementDelayDeletionCount(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112090: " + this.errorIncrementDelayDeletionCount$str(), new Object[0]);
    }

    protected String errorIncrementDelayDeletionCount$str() {
        return errorIncrementDelayDeletionCount;
    }

    @Override
    public final void clusterConnectionNotUnique() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112179: " + this.clusterConnectionNotUnique$str(), new Object[0]);
    }

    protected String clusterConnectionNotUnique$str() {
        return clusterConnectionNotUnique;
    }

    @Override
    public final void errorAddingPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112033: " + this.errorAddingPacket$str(), new Object[0]);
    }

    protected String errorAddingPacket$str() {
        return errorAddingPacket;
    }

    @Override
    public final void becomingLive(HornetQServer server) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111044: " + this.becomingLive$str(), (Object)server);
    }

    protected String becomingLive$str() {
        return becomingLive;
    }

    @Override
    public final void serverAlreadyStarted(String type) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111002: " + this.serverAlreadyStarted$str(), (Object)type);
    }

    protected String serverAlreadyStarted$str() {
        return serverAlreadyStarted;
    }

    @Override
    public final void pageFinaliseError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112070: " + this.pageFinaliseError$str(), new Object[0]);
    }

    protected String pageFinaliseError$str() {
        return pageFinaliseError;
    }

    @Override
    public final void clientSessionNotClosed(Exception e, int identity) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112032: " + this.clientSessionNotClosed$str(), (Object)identity);
    }

    protected String clientSessionNotClosed$str() {
        return clientSessionNotClosed;
    }

    @Override
    public final void waitingToObtainLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111039: " + this.waitingToObtainLiveLock$str(), new Object[0]);
    }

    protected String waitingToObtainLiveLock$str() {
        return "Waiting to obtain live lock";
    }

    @Override
    public final void noQueueIdDefined(ServerMessage message, ServerMessage messageCopy, SimpleString idsHeaderName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112162: " + this.noQueueIdDefined$str(), (Object)message, (Object)messageCopy, (Object)idsHeaderName);
    }

    protected String noQueueIdDefined$str() {
        return noQueueIdDefined;
    }

    @Override
    public final void failoverDuringPrepareRollingBack() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112030: " + this.failoverDuringPrepareRollingBack$str(), new Object[0]);
    }

    protected String failoverDuringPrepareRollingBack$str() {
        return "failover occurred during prepare rolling back";
    }

    @Override
    public final void errorRemovingConnection() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111025: " + this.errorRemovingConnection$str(), new Object[0]);
    }

    protected String errorRemovingConnection$str() {
        return errorRemovingConnection;
    }

    @Override
    public final void announceBackupNoClusterConnections() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112172: " + this.announceBackupNoClusterConnections$str(), new Object[0]);
    }

    protected String announceBackupNoClusterConnections$str() {
        return announceBackupNoClusterConnections;
    }

    @Override
    public final void bridgePaused(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111035: " + this.bridgePaused$str(), (Object)name);
    }

    protected String bridgePaused$str() {
        return bridgePaused;
    }

    @Override
    public final void unableToStartBroadcastGroup(Exception e, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112168: " + this.unableToStartBroadcastGroup$str(), (Object)name);
    }

    protected String unableToStartBroadcastGroup$str() {
        return unableToStartBroadcastGroup;
    }

    @Override
    public final void errorStoppingReplicationManager(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114078: " + this.errorStoppingReplicationManager$str(), new Object[0]);
    }

    protected String errorStoppingReplicationManager$str() {
        return errorStoppingReplicationManager;
    }

    @Override
    public final void cantFindQueueOnPageComplete(long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ114083: " + this.cantFindQueueOnPageComplete$str(), (Object)queueID);
    }

    protected String cantFindQueueOnPageComplete$str() {
        return cantFindQueueOnPageComplete;
    }

    @Override
    public final void journalCannotFindQueueReloadingPageCursor(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111021: " + this.journalCannotFindQueueReloadingPageCursor$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingPageCursor$str() {
        return journalCannotFindQueueReloadingPageCursor;
    }

    @Override
    public final void errorBroadcastingConnectorConfigs(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114054: " + this.errorBroadcastingConnectorConfigs$str(), new Object[0]);
    }

    protected String errorBroadcastingConnectorConfigs$str() {
        return errorBroadcastingConnectorConfigs;
    }

    @Override
    public final void errorSendingFrame(Exception e, StompFrame frame) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114038: " + this.errorSendingFrame$str(), (Object)frame);
    }

    protected String errorSendingFrame$str() {
        return errorSendingFrame;
    }

    @Override
    public final void unexpectedXid(Xid xid) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112149: " + this.unexpectedXid$str(), (Object)xid);
    }

    protected String unexpectedXid$str() {
        return unexpectedXid;
    }

    @Override
    public final void serverStarted(String fullVersion, SimpleString nodeId, String identity) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111003: " + this.serverStarted$str(), (Object)fullVersion, (Object)nodeId, (Object)identity);
    }

    protected String serverStarted$str() {
        return serverStarted;
    }

    @Override
    public final void timedOutStoppingPagingCursor(FutureLatch future, Executor executor) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112058: " + this.timedOutStoppingPagingCursor$str(), (Object)future, (Object)executor);
    }

    protected String timedOutStoppingPagingCursor$str() {
        return timedOutStoppingPagingCursor;
    }

    @Override
    public final void divertWithNoForwardingAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112006: " + this.divertWithNoForwardingAddress$str(), new Object[0]);
    }

    protected String divertWithNoForwardingAddress$str() {
        return divertWithNoForwardingAddress;
    }

    @Override
    public final void startedNettyAcceptor(String id, String host, Integer port, ProtocolType protocol) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111024: " + this.startedNettyAcceptor$str(), new Object[]{id, host, port, protocol});
    }

    protected String startedNettyAcceptor$str() {
        return startedNettyAcceptor;
    }

    @Override
    public final void errorDelivering(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114062: " + this.errorDelivering$str(), new Object[0]);
    }

    protected String errorDelivering$str() {
        return errorDelivering;
    }

    @Override
    public final void serverLocatorNotClosed(Exception e, int identity) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112045: " + this.serverLocatorNotClosed$str(), (Object)identity);
    }

    protected String serverLocatorNotClosed$str() {
        return serverLocatorNotClosed;
    }

    @Override
    public final void errorDuringPrepare(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112031: " + this.errorDuringPrepare$str(), new Object[0]);
    }

    protected String errorDuringPrepare$str() {
        return "failover occurred during prepare rolling back";
    }

    @Override
    public final void errorHandlingPacket(Throwable t, Packet packet) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, "HQ114035: " + this.errorHandlingPacket$str(), (Object)packet);
    }

    protected String errorHandlingPacket$str() {
        return errorHandlingPacket;
    }

    @Override
    public final void messageExceededMaxDeliverySendtoDLA(MessageReference ref, SimpleString name, SimpleString simpleString) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112201: " + this.messageExceededMaxDeliverySendtoDLA$str(), (Object)ref, (Object)name, (Object)simpleString);
    }

    protected String messageExceededMaxDeliverySendtoDLA$str() {
        return messageExceededMaxDeliverySendtoDLA;
    }

    @Override
    public final void reaperRestarted() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112094: " + this.reaperRestarted$str(), new Object[0]);
    }

    protected String reaperRestarted$str() {
        return reaperRestarted;
    }

    @Override
    public final void timeoutClosingNettyChannel() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112120: " + this.timeoutClosingNettyChannel$str(), new Object[0]);
    }

    protected String timeoutClosingNettyChannel$str() {
        return timeoutClosingNettyChannel;
    }

    @Override
    public final void errorTransferringConsumer() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112195: " + this.errorTransferringConsumer$str(), new Object[0]);
    }

    protected String errorTransferringConsumer$str() {
        return errorTransferringConsumer;
    }

    @Override
    public final void timeoutFlushingPacket() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112121: " + this.timeoutFlushingPacket$str(), new Object[0]);
    }

    protected String timeoutFlushingPacket$str() {
        return timeoutFlushingPacket;
    }

    @Override
    public final void timedOutWaitingToStopBridge() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112138: " + this.timedOutWaitingToStopBridge$str(), new Object[0]);
    }

    protected String timedOutWaitingToStopBridge$str() {
        return timedOutWaitingToStopBridge;
    }

    @Override
    public final void bridgeUnableToSendMessage(Exception e, MessageReference ref) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112140: " + this.bridgeUnableToSendMessage$str(), (Object)ref);
    }

    protected String bridgeUnableToSendMessage$str() {
        return bridgeUnableToSendMessage;
    }

    @Override
    public final void errorStartingBridge(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112144: " + this.errorStartingBridge$str(), (Object)name);
    }

    protected String errorStartingBridge$str() {
        return errorStartingBridge;
    }

    @Override
    public final void bridgeAbortStart(SimpleString name, Integer retryCount, Integer reconnectAttempts) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112147: " + this.bridgeAbortStart$str(), (Object)name, (Object)retryCount, (Object)reconnectAttempts);
    }

    protected String bridgeAbortStart$str() {
        return bridgeAbortStart;
    }

    @Override
    public final void dumpingSessionStack(Exception e) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)e, "HQ111015: " + this.dumpingSessionStack$str(), new Object[0]);
    }

    protected String dumpingSessionStack$str() {
        return dumpingSessionStack;
    }

    @Override
    public final void awaitFailBack() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111010: " + this.awaitFailBack$str(), new Object[0]);
    }

    protected String awaitFailBack$str() {
        return awaitFailBack;
    }

    @Override
    public final void errorQueryingBridge(SimpleString address, Integer retryCount) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112143: " + this.errorQueryingBridge2$str(), (Object)address, (Object)retryCount);
    }

    protected String errorQueryingBridge2$str() {
        return errorQueryingBridge2;
    }

    @Override
    public final void unableToDeployNode(Exception e, Node node) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114019: " + this.unableToDeployNode$str(), (Object)node);
    }

    protected String unableToDeployNode$str() {
        return unableToDeployNode;
    }

    @Override
    public final void errorConnectingToNodes(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112041: " + this.errorConnectingToNodes$str(), new Object[0]);
    }

    protected String errorConnectingToNodes$str() {
        return errorConnectingToNodes;
    }

    @Override
    public final void divertBindingNotExists(SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112007: " + this.divertBindingNotExists$str(), (Object)bindingName);
    }

    protected String divertBindingNotExists$str() {
        return divertBindingNotExists;
    }

    @Override
    public final void cannotFindConsumer(long consumerID) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114070: " + this.cannotFindConsumer$str(), (Object)consumerID);
    }

    protected String cannotFindConsumer$str() {
        return cannotFindConsumer;
    }

    @Override
    public final void errorCreatingAcceptor(Exception e, String factoryClassName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112124: " + this.errorCreatingAcceptor$str(), (Object)factoryClassName);
    }

    protected String errorCreatingAcceptor$str() {
        return errorCreatingAcceptor;
    }

    @Override
    public final void errorAckingMessage(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114065: " + this.errorAckingMessage$str(), new Object[0]);
    }

    protected String errorAckingMessage$str() {
        return errorAckingMessage;
    }

    @Override
    public final void errorCreatingRemotingInterceptor(Exception e, String interceptorClass) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112122: " + this.errorCreatingRemotingInterceptor$str(), (Object)interceptorClass);
    }

    protected String errorCreatingRemotingInterceptor$str() {
        return errorCreatingRemotingInterceptor;
    }

    @Override
    public final void journalUseAIO() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111016: " + this.journalUseAIO$str(), new Object[0]);
    }

    protected String journalUseAIO$str() {
        return journalUseAIO;
    }

    @Override
    public final void bridgeNoForwardAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112175: " + this.bridgeNoForwardAddress$str(), new Object[0]);
    }

    protected String bridgeNoForwardAddress$str() {
        return bridgeNoForwardAddress;
    }

    @Override
    public final void failedToHandleCreateQueue(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114034: " + this.failedToHandleCreateQueue$str(), new Object[0]);
    }

    protected String failedToHandleCreateQueue$str() {
        return failedToHandleCreateQueue;
    }

    @Override
    public final void broadcastGroupClosed(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112160: " + this.broadcastGroupClosed$str(), new Object[0]);
    }

    protected String broadcastGroupClosed$str() {
        return "unable to send notification when broadcast group is stopped";
    }

    @Override
    public final void failoverDuringPrepare() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112029: " + this.failoverDuringPrepare$str(), new Object[0]);
    }

    protected String failoverDuringPrepare$str() {
        return failoverDuringPrepare;
    }

    @Override
    public final void errorClearingMessages(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ112017: " + this.errorClearingMessages$str(), new Object[0]);
    }

    protected String errorClearingMessages$str() {
        return errorClearingMessages;
    }

    @Override
    public final void failedToCleanupSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114003: " + this.failedToCleanupSession$str(), new Object[0]);
    }

    protected String failedToCleanupSession$str() {
        return failedToCleanupSession;
    }

    @Override
    public final void pageSuspectFile(int position, int msgNumber) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112071: " + this.pageSuspectFile$str(), (Object)position, (Object)msgNumber);
    }

    protected String pageSuspectFile$str() {
        return pageSuspectFile;
    }

    @Override
    public final void multipleServersBroadcastingSameNode(String nodeId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112050: " + this.multipleServersBroadcastingSameNode$str(), (Object)nodeId);
    }

    protected String multipleServersBroadcastingSameNode$str() {
        return multipleServersBroadcastingSameNode;
    }

    @Override
    public final void deprecatedConfigurationOption(String deprecatedOption) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111045: " + this.deprecatedConfigurationOption$str(), (Object)deprecatedOption);
    }

    protected String deprecatedConfigurationOption$str() {
        return deprecatedConfigurationOption;
    }

    @Override
    public final void connectorKeysMissing(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112128: " + this.connectorKeysMissing$str(), (Object)s);
    }

    protected String connectorKeysMissing$str() {
        return connectorKeysMissing;
    }

    @Override
    public final void backupMovingDataAway(String oldPath, String newPath) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112216: " + this.backupMovingDataAway$str(), (Object)oldPath, (Object)newPath);
    }

    protected String backupMovingDataAway$str() {
        return backupMovingDataAway;
    }

    @Override
    public final void errorClosingConnection(ServerSessionImpl serverSession) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, "HQ114071: " + this.errorClosingConnection$str(), (Object)serverSession);
    }

    protected String errorClosingConnection$str() {
        return errorClosingConnection;
    }

    @Override
    public final void failedToAckOnBridge(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ114049: " + this.failedToAckOnBridge$str(), new Object[0]);
    }

    protected String failedToAckOnBridge$str() {
        return failedToAckOnBridge;
    }

    @Override
    public final void awaitingLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, "HQ111008: " + this.awaitingLiveLock$str(), new Object[0]);
    }

    protected String awaitingLiveLock$str() {
        return "Waiting to obtain live lock";
    }

    @Override
    public final void connectorAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112053: " + this.connectorAlreadyDeployed$str(), (Object)name);
    }

    protected String connectorAlreadyDeployed$str() {
        return connectorAlreadyDeployed;
    }

    @Override
    public final void timedOutFlushingInvmChannel() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112113: " + this.timedOutFlushingInvmChannel$str(), new Object[0]);
    }

    protected String timedOutFlushingInvmChannel$str() {
        return timedOutFlushingInvmChannel;
    }

    @Override
    public final void errorClosingBackupFactoryOnClusterConnection(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ112192: " + this.errorClosingBackupFactoryOnClusterConnection$str(), new Object[0]);
    }

    protected String errorClosingBackupFactoryOnClusterConnection$str() {
        return errorClosingBackupFactoryOnClusterConnection;
    }

    @Override
    public final void bridgeNoQueue(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, "HQ112177: " + this.bridgeNoQueue1$str(), (Object)name);
    }

    protected String bridgeNoQueue1$str() {
        return bridgeNoQueue1;
    }
}

