/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import org.hornetq.api.core.HornetQAddressFullException;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQDuplicateMetaDataException;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQIncompatibleClientServerException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQLargeMessageException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.HornetQObjectClosedException;
import org.hornetq.api.core.HornetQQueueExistsException;
import org.hornetq.api.core.HornetQSecurityException;
import org.hornetq.api.core.HornetQSessionCreationException;
import org.hornetq.api.core.HornetQTransactionOutcomeUnknownException;
import org.hornetq.api.core.HornetQTransactionRolledBackException;
import org.hornetq.api.core.HornetQUnBlockedException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Connection;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.w3c.dom.Node;

@MessageBundle(projectCode="HQ")
public interface HornetQMessageBundle {
    public static final HornetQMessageBundle BUNDLE = Messages.getBundle(HornetQMessageBundle.class);

    @Message(id=119001, value="Activation for server {0}", format=Message.Format.MESSAGE_FORMAT)
    public String activationForServer(HornetQServer var1);

    @Message(id=119002, value="Generating thread dump because - {0}", format=Message.Format.MESSAGE_FORMAT)
    public String generatingThreadDump(String var1);

    @Message(id=119003, value="Thread {0} name = {1} id = {2} group = {3}", format=Message.Format.MESSAGE_FORMAT)
    public String threadDump(Thread var1, String var2, Long var3, ThreadGroup var4);

    @Message(id=119004, value="End Thread dump", format=Message.Format.MESSAGE_FORMAT)
    public String endThreadDump();

    @Message(id=119005, value="Information about server {0}\nCluster Connection:{1}", format=Message.Format.MESSAGE_FORMAT)
    public String serverDescribe(String var1, String var2);

    @Message(id=119006, value="ClientSession closed while creating session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException clientSessionClosed();

    @Message(id=119007, value="Failed to create session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException failedToCreateSession(@Cause Throwable var1);

    @Message(id=119008, value="Internal Error! ClientSessionFactoryImpl::createSessionInternal just reached a condition that was not supposed to happen. Please inform this condition to the HornetQ team", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException clietSessionInternal();

    @Message(id=119009, value="Queue can not be both durable and temporary", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException queueMisConfigured();

    @Message(id=119010, value="Interrupted awaiting completion in large message controller", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException largeMessageControllerInterrupted(@Cause Exception var1);

    @Message(id=119011, value="Failed to initialise session factory", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException failedToInitialiseSessionFactory(@Cause Exception var1);

    @Message(id=119012, value="connections for {0} closed by management", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException connectionsClosedByManagement(String var1);

    @Message(id=119013, value="journals are not JournalImpl. You can't set a replicator!", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException notJournalImpl();

    @Message(id=119014, value="Unable to complete IO operation - {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException unableToCompleteIOOperation(String var1);

    @Message(id=119015, value="Exception in Netty transport", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException nettyError();

    @Message(id=119016, value="unhandled error during replication", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException replicationUnhandledError(@Cause Exception var1);

    @Message(id=119017, value="Live Node contains more journals than the backup node. Probably a version match error", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException replicationTooManyJournals();

    @Message(id=119018, value="Unhandled file type {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType var1);

    @Message(id=119019, value="Remote Backup can not be up-to-date!", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException replicationBackupUpToDate();

    @Message(id=119020, value="unhandled data type!", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException replicationUnhandledDataType();

    @Message(id=119021, value="No binding for divert {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException noBindingForDivert(SimpleString var1);

    @Message(id=119022, value="Binding {0} is not a divert", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException bindingNotDivert(SimpleString var1);

    @Message(id=119023, value="Error trying to start replication", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException replicationStartError(@Cause Exception var1);

    @Message(id=119024, value="error trying to stop {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException errorStoppingServer(@Cause Exception var1, HornetQServer var2);

    @Message(id=119025, value="Channel disconnected", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException channelDisconnected();

    @Message(id=119026, value="Cannot connect to server(s). Tried with all available servers.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException cannotConnectToServers();

    @Message(id=119027, value="Failed to connect to any static connectors", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException cannotConnectToStaticConnectors(@Cause Exception var1);

    @Message(id=119028, value="Failed to connect to any static connectors", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException cannotConnectToStaticConnectors2();

    @Message(id=119029, value="Connection is destroyed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException connectionDestroyed();

    @Message(id=119030, value="Did not receive data from server for {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException connectionTimedOut(Connection var1);

    @Message(id=119031, value="Timed out waiting to receive initial broadcast from cluster", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException connectionTimedOutInInitialBroadcast();

    @Message(id=119032, value="Timed out waiting to receive cluster topology. Group:{0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup var1);

    @Message(id=119033, value="Timed out waiting for response when sending packet {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException timedOutSendingPacket(Byte var1);

    @Message(id=119034, value="Did not receive data from {0}. It is likely the client has exited or crashed without closing its connection, or the network between the server and client has failed. You also might have configured connection-ttl and client-failure-check-period incorrectly. Please check user manual for more information. The connection will now be closed.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException clientExited(String var1);

    @Message(id=119035, value="The connection was disconnected because of server shutdown", format=Message.Format.MESSAGE_FORMAT)
    public HornetQDisconnectedException disconnected();

    @Message(id=119036, value="Connection failure detected. Unblocking a blocking call that will never get a response", format=Message.Format.MESSAGE_FORMAT)
    public HornetQUnBlockedException unblockingACall();

    @Message(id=119037, value="Timeout on waiting I/O completion", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIOErrorException ioTimeout();

    @Message(id=119038, value="queue {0} has been removed cannot deliver message, queues should not be removed when grouping is used", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNonExistentQueueException groupingQueueRemoved(SimpleString var1);

    @Message(id=119039, value="Queue {0}does not exist", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNonExistentQueueException noSuchQueue(SimpleString var1);

    @Message(id=119040, value="Binding already exists {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQQueueExistsException bindingAlreadyExists(Binding var1);

    @Message(id=119041, value="Queue already exists {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQQueueExistsException queueAlreadyExists(SimpleString var1);

    @Message(id=119042, value="Consumer is closed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQObjectClosedException consumerClosed();

    @Message(id=119043, value="Producer is closed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQObjectClosedException producerClosed();

    @Message(id=119044, value="Session is closed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQObjectClosedException sessionClosed();

    @Message(id=119045, value="Invalid filter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInvalidFilterExpressionException invalidFilter(@Cause Throwable var1, SimpleString var2);

    @Message(id=119046, value="Cannot call receive(...) - a MessageHandler is set", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException messageHandlerSet();

    @Message(id=119047, value="Cannot set MessageHandler - consumer is in receive(...)", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException inReceive();

    @Message(id=119048, value="Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException headerSizeTooBig(Integer var1);

    @Message(id=119049, value="The large message lost connection with its session, either because of a rollback or a closed session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException largeMessageLostSession();

    @Message(id=119050, value="Couldn't select a TransportConfiguration to create SessionFactory", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException noTCForSessionFactory();

    @Message(id=119051, value="MessageId was not assigned to Message", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException messageIdNotAssigned();

    @Message(id=119052, value="Cannot compare journals if not in sync!", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException journalsNotInSync();

    @Message(id=119053, value="Connected server is not a backup server", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException serverNotBackupServer();

    @Message(id=119054, value="Backup replication server is already connected to another server", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException alreadyHaveReplicationServer();

    @Message(id=119055, value="Cannot delete queue {0} on binding {1} - it has consumers = {2}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException cannotDeleteQueue(SimpleString var1, SimpleString var2, String var3);

    @Message(id=119056, value="Backup Server was not yet in sync with live", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException backupServerNotInSync();

    @Message(id=119057, value="Could not find reference on consumer ID={0}, messageId = {1} queue = {2}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException consumerNoReference(Long var1, Long var2, SimpleString var3);

    @Message(id=119058, value="Consumer {0} doesn't exist on the server", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException consumerDoesntExist(long var1);

    @Message(id=119059, value="No address configured on the Server's Session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException noAddress();

    @Message(id=119060, value="large-message not initialized on server", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException largeMessageNotInitialised();

    @Message(id=119061, value="Unable to validate user: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQSecurityException unableToValidateUser(String var1);

    @Message(id=119062, value="User: {0} doesn't have permission='{1}' on address {2}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQSecurityException userNoPermissions(String var1, CheckType var2, String var3);

    @Message(id=119063, value="Server and client versions incompatible", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIncompatibleClientServerException incompatibleCLientServer();

    @Message(id=119064, value="Error saving the message body", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorSavingBody(@Cause Exception var1);

    @Message(id=119065, value="Error reading the LargeMessageBody", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorReadingBody(@Cause Exception var1);

    @Message(id=119066, value="Error closing stream from LargeMessageBody", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorClosingLargeMessage(@Cause Exception var1);

    @Message(id=119067, value="Timeout waiting for LargeMessage Body", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException timeoutOnLargeMessage();

    @Message(id=119068, value="Error on saving Large Message Buffer", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorSavingLargeMessageBuffer(@Cause Exception var1);

    @Message(id=119069, value="Error writing body of message", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorWritingLargeMessage(@Cause Exception var1);

    @Message(id=119070, value="The transaction was rolled back on failover to a backup server", format=Message.Format.MESSAGE_FORMAT)
    public HornetQTransactionRolledBackException txRolledBack();

    @Message(id=119071, value="Server not started", format=Message.Format.MESSAGE_FORMAT)
    public HornetQSessionCreationException serverNotStarted();

    @Message(id=119072, value="Metadata {0}={1} had been set already", format=Message.Format.MESSAGE_FORMAT)
    public HornetQDuplicateMetaDataException duplicateMetadata(String var1, String var2);

    @Message(id=119073, value="The transaction was rolled back on failover however commit may have been succesful", format=Message.Format.MESSAGE_FORMAT)
    public HornetQTransactionOutcomeUnknownException txOutcomeUnknown();

    @Message(id=119074, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidType(Object var1);

    @Message(id=119075, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidEncodeType(Object var1);

    @Message(id=119076, value="Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidManagementParam(Object var1);

    @Message(id=119077, value="Invalid window size {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidWindowSize(Integer var1);

    @Message(id=119078, value="retry interval must be positive, was {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidRetryInterval(Long var1);

    @Message(id=119079, value="{0} must neither be null nor empty", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException emptyOrNull(String var1);

    @Message(id=119080, value="{0}  must be greater than 0 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanZero(String var1, Number var2);

    @Message(id=119081, value="{0} must be a valid percentual value between 0 and 100 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException notPercent(String var1, Number var2);

    @Message(id=119082, value="{0}  must be equals to -1 or greater than 0 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanMinusOne(String var1, Number var2);

    @Message(id=119083, value="{0}  must be equals to -1 or greater or equals to 0 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanZeroOrMinusOne(String var1, Number var2);

    @Message(id=119084, value="{0} must be betwen {1} and {2} inclusive (actual value: {3})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustbeBetween(String var1, Integer var2, Integer var3, Object var4);

    @Message(id=119085, value="Invalid journal type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidJournalType(String var1);

    @Message(id=119086, value="Invalid address full message policy type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidAddressFullPolicyType(String var1);

    @Message(id=119087, value="No operation mapped to int {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noOperationMapped(Integer var1);

    @Message(id=119088, value="invalid value: {0} count must be greater than 0", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanZero(Integer var1);

    @Message(id=119089, value="Cannot set Message Counter Sample Period < {0}ms", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidMessageCounterPeriod(Long var1);

    @Message(id=119090, value="invalid new Priority value: {0}. It must be between 0 and 9 (both included)", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidNewPriority(Integer var1);

    @Message(id=119091, value="No queue found for {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noQueueFound(String var1);

    @Message(id=119092, value="Only NIO and AsyncIO are supported journals", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidJournal();

    @Message(id=119093, value="Invalid journal type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidJournalType2(JournalType var1);

    @Message(id=119094, value="Directory {0} does not exist and cannot be created", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotCreateDir(String var1);

    @Message(id=119095, value="Invalid index {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidIndex(Integer var1);

    @Message(id=119096, value="Cannot convert to int", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotConvertToInt();

    @Message(id=119097, value="Routing name is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException routeNameIsNull();

    @Message(id=119098, value="Cluster name is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException clusterNameIsNull();

    @Message(id=119099, value="Address is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException addressIsNull();

    @Message(id=119100, value="Binding type not specified", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException bindingTypeNotSpecified();

    @Message(id=119101, value="Binding ID is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException bindingIdNotSpecified();

    @Message(id=119102, value="Distance is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException distancenotSpecified();

    @Message(id=119103, value="Invalid last Received Command ID: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidCommandID(Integer var1);

    @Message(id=119104, value="Cannot find channel with id {0} to close", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noChannelToClose(Long var1);

    @Message(id=119105, value="Close Listener cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException closeListenerCannotBeNull();

    @Message(id=119106, value="Fail Listener cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException failListenerCannotBeNull();

    @Message(id=119107, value="Connection already exists with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException connectionExists(Object var1);

    @Message(id=119108, value="Acceptor with id {0} already registered", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException acceptorExists(Integer var1);

    @Message(id=119109, value="Acceptor with id {0} not registered", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException acceptorNotExists(Integer var1);

    @Message(id=119110, value="Invalid argument null listener", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullListener();

    @Message(id=119111, value="Invalid argument null handler", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullHandler();

    @Message(id=119112, value="Unknown protocol {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unknownProtocol(ProtocolType var1);

    @Message(id=119113, value="node id is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeIdNull();

    @Message(id=119114, value="Cannot have a replicated backup without configuring its live-server!", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noLiveForReplicatedBackup();

    @Message(id=119115, value="Queue name is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException queueNameIsNull();

    @Message(id=119116, value="Cannot find resource with name {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotFindResource(String var1);

    @Message(id=119117, value="no getter method for {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noGetterMethod(String var1);

    @Message(id=119118, value="no operation {0}/{1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noOperation(String var1, Integer var2);

    @Message(id=119119, value="match can not be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullMatch();

    @Message(id=119120, value="* can only be at end of match", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidMatch();

    @Message(id=119121, value="User cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullUser();

    @Message(id=119122, value="Password cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullPassword();

    @Message(id=119123, value="No available codec to decode password!", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noCodec();

    @Message(id=119124, value="the first node to be compared is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException firstNodeNull();

    @Message(id=119125, value="the second node to be compared is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException secondNodeNull();

    @Message(id=119126, value="nodes have different node names", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeHaveDifferentNames();

    @Message(id=119127, value="nodes hava a different number of attributes", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeHaveDifferentAttNumber();

    @Message(id=119128, value="attribute {0}={1} doesn't match", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException attsDontMatch(String var1, String var2);

    @Message(id=119129, value="one node has children and the other doesn't", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException oneNodeHasChildren();

    @Message(id=119130, value="nodes hava a different number of children", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeHasDifferentChildNumber();

    @Message(id=119131, value="Element {0} requires a valid Boolean value, but '{1}' cannot be parsed as a Boolean", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeBoolean(Node var1, String var2);

    @Message(id=119132, value="Element {0} requires a valid Double value, but '{1}' cannot be parsed as a Double", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeDouble(Node var1, String var2);

    @Message(id=119133, value="Element {0} requires a valid Integer value, but '{1}' cannot be parsed as a Integer", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeInteger(Node var1, String var2);

    @Message(id=119134, value="Element {0} requires a valid Long value, but '{1}' cannot be parsed as a Long", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeLong(Node var1, String var2);

    @Message(id=119135, value="Failed to get decoder", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException failedToGetDecoder(@Cause Exception var1);

    @Message(id=119136, value="Error decoding password", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException errordecodingPassword(@Cause Exception var1);

    @Message(id=119137, value="Error instantiating transformer class {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException errorCreatingTransformerClass(@Cause Exception var1, String var2);

    @Message(id=119138, value="method autoEncode doesn't know how to convert {0} yet", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException autoConvertError(Class<? extends Object> var1);

    @Message(id=119139, value="Address \"{0}\" is full. Message encode size = {1}B", format=Message.Format.MESSAGE_FORMAT)
    public HornetQAddressFullException addressIsFull(String var1, int var2);

    @Message(id=119140, value="Executing destroyConnection with {0}={1} through management's request", format=Message.Format.MESSAGE_FORMAT)
    public String destroyConnectionWithSessionMetadataHeader(String var1, String var2);

    @Message(id=119141, value="Closing connection {0}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyConnectionWithSessionMetadataClosingConnection(String var1);

    @Message(id=119142, value="Disconnected per admin's request on {0}={1}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQDisconnectedException destroyConnectionWithSessionMetadataSendException(String var1, String var2);

    @Message(id=119143, value="No session found with {0}={1}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyConnectionWithSessionMetadataNoSessionFound(String var1, String var2);
}

