/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.lang.ref.WeakReference;
import org.hornetq.core.server.HornetQLogger;

public class MemorySize {
    private static final int numberOfObjects = 10000;

    private static Object newObject(ObjectFactory factory) throws Exception {
        return factory.createObject();
    }

    public static boolean is64bitArch() {
        boolean is64bit = true;
        try {
            String arch = System.getProperty("os.arch");
            if (arch != null) {
                is64bit = arch.contains("64");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is64bit;
    }

    public static int calculateSize(ObjectFactory factory) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        MemorySize.getMemorySize(runtime);
        MemorySize.newObject(factory);
        int i = 0;
        long heap1 = 0L;
        long heap2 = 0L;
        long totalMemory1 = 0L;
        long totalMemory2 = 0L;
        Object[] obj = new Object[20000];
        for (i = 0; i < 20000; ++i) {
            obj[i] = MemorySize.newObject(factory);
        }
        obj = new Object[20000];
        heap1 = MemorySize.getMemorySize(runtime);
        totalMemory1 = runtime.totalMemory();
        for (i = 0; i < 10000; ++i) {
            obj[i] = MemorySize.newObject(factory);
        }
        heap2 = MemorySize.getMemorySize(runtime);
        totalMemory2 = runtime.totalMemory();
        int size = Math.round((float)(heap2 - heap1) / 10000.0f);
        if (totalMemory1 != totalMemory2) {
            HornetQLogger.LOGGER.jvmAllocatedMoreMemory(totalMemory1, totalMemory2);
        }
        return size;
    }

    private static long getMemorySize(Runtime runtime) {
        for (int i = 0; i < 5; ++i) {
            MemorySize.forceGC();
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private static void forceGC() {
        WeakReference<Object> dumbReference = new WeakReference<Object>(new Object());
        while (dumbReference.get() != null) {
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface ObjectFactory {
        public Object createObject();
    }
}

