/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.AbstractBasicConfiguration;
import org.jboss.logmanager.config.ConfigAction;
import org.jboss.logmanager.config.LogContextConfigurationImpl;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.ObjectProducer;
import org.jboss.logmanager.config.PropertyHelper;

final class LoggerConfigurationImpl
extends AbstractBasicConfiguration<Logger, LoggerConfigurationImpl>
implements LoggerConfiguration {
    private String filter;
    private Boolean useParentHandlers;
    private String level;
    private final List<String> handlerNames = new ArrayList<String>(0);

    LoggerConfigurationImpl(String name, LogContextConfigurationImpl configuration) {
        super(name, configuration, configuration.getLoggerRefs(), configuration.getLoggerConfigurations());
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(final String filter) {
        final String oldFilterName = this.filter;
        this.filter = filter;
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<ObjectProducer>(){

            @Override
            public ObjectProducer validate() throws IllegalArgumentException {
                return configuration.parseFilterExpression(filter);
            }

            @Override
            public void applyPreCreate(ObjectProducer param) {
            }

            @Override
            public void applyPostCreate(ObjectProducer param) {
                configuration.getHandlerRefs().get(LoggerConfigurationImpl.this.getName()).setFilter((Filter)param.getObject());
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.filter = oldFilterName;
            }
        });
    }

    @Override
    public Boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    @Override
    public void setUseParentHandlers(final Boolean useParentHandlers) {
        final Boolean oldUseParentHandlers = this.useParentHandlers;
        this.useParentHandlers = useParentHandlers;
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                if (useParentHandlers != null) {
                    configuration.getLoggerRefs().get(LoggerConfigurationImpl.this.getName()).setUseParentHandlers(useParentHandlers);
                }
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.useParentHandlers = oldUseParentHandlers;
            }
        });
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(String level) {
        String resolvedLevel;
        final String oldLevel = this.level;
        this.level = resolvedLevel = PropertyHelper.resolveValue(level);
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Level>(){

            @Override
            public Level validate() throws IllegalArgumentException {
                return resolvedLevel == null ? null : configuration.getLogContext().getLevelForName(resolvedLevel);
            }

            @Override
            public void applyPreCreate(Level param) {
            }

            @Override
            public void applyPostCreate(Level param) {
                configuration.getLoggerRefs().get(LoggerConfigurationImpl.this.getName()).setLevel(param);
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.level = oldLevel;
            }
        });
    }

    @Override
    public List<String> getHandlerNames() {
        return new ArrayList<String>(this.handlerNames);
    }

    @Override
    public void setHandlerNames(String ... names) {
        final String[] oldHandlerNames = this.handlerNames.toArray(new String[this.handlerNames.size()]);
        this.handlerNames.clear();
        LinkedHashSet<String> strings = new LinkedHashSet<String>(Arrays.asList(names));
        this.handlerNames.addAll(strings);
        final String[] stringsArray = strings.toArray(new String[strings.size()]);
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                for (String name : stringsArray) {
                    if (configuration.getHandlerConfiguration(name) != null) continue;
                    throw new IllegalArgumentException(String.format("Handler \"%s\" is not found", name));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                Map<String, Logger> loggerRefs = configuration.getLoggerRefs();
                Logger logger2 = loggerRefs.get(LoggerConfigurationImpl.this.getName());
                int length = stringsArray.length;
                Handler[] handlers = new Handler[length];
                for (int i = 0; i < length; ++i) {
                    handlers[i] = handlerRefs.get(stringsArray[i]);
                }
                logger2.setHandlers(handlers);
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.handlerNames.clear();
                LoggerConfigurationImpl.this.handlerNames.addAll(Arrays.asList(oldHandlerNames));
            }
        });
    }

    @Override
    public void setHandlerNames(Collection<String> names) {
        this.setHandlerNames(names.toArray(new String[names.size()]));
    }

    @Override
    public boolean addHandlerName(final String name) {
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (this.handlerNames.contains(name)) {
            return false;
        }
        this.handlerNames.add(name);
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                if (configuration.getHandlerConfiguration(name) == null) {
                    throw new IllegalArgumentException(String.format("Handler \"%s\" is not found", name));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                Map<String, Logger> loggerRefs = configuration.getLoggerRefs();
                Logger logger2 = loggerRefs.get(LoggerConfigurationImpl.this.getName());
                logger2.addHandler(handlerRefs.get(name));
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.handlerNames.remove(name);
            }
        });
        return true;
    }

    @Override
    public boolean removeHandlerName(final String name) {
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!this.handlerNames.contains(name)) {
            return false;
        }
        final int index = this.handlerNames.indexOf(name);
        this.handlerNames.remove(index);
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                Map<String, Logger> loggerRefs = configuration.getLoggerRefs();
                Logger logger2 = loggerRefs.get(LoggerConfigurationImpl.this.getName());
                logger2.removeHandler(handlerRefs.get(name));
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.handlerNames.add(index, name);
            }
        });
        return true;
    }
}

