/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.naming.remote.protocol.ProtocolCommand;
import org.jboss.naming.remote.protocol.v1.ProtocolIoFuture;
import org.jboss.naming.remote.protocol.v1.ReadUtil;

abstract class BaseProtocolCommand<T, F extends ProtocolIoFuture<T>>
implements ProtocolCommand<T> {
    public static final int DEFAULT_TIMEOUT = 10;
    private int nextCorrelationId = 1;
    private final Map<Integer, F> requests = new HashMap<Integer, F>();
    private final byte commandId;

    protected BaseProtocolCommand(byte commandId) {
        this.commandId = commandId;
    }

    @Override
    public byte getCommandId() {
        return this.commandId;
    }

    protected void readResult(int correlationId, DataInput input, ValueReader<F> valueReader) throws IOException {
        F future = this.getFuture(correlationId);
        try {
            byte outcome = input.readByte();
            if (outcome == 0) {
                valueReader.read(input, future);
            } else if (outcome == 1) {
                byte parameterType = input.readByte();
                if (parameterType != 2) {
                    throw new IOException("Unexpected response parameter received.");
                }
                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input, this.getClass().getClassLoader());
                Exception exception = unmarshaller.readObject(Exception.class);
                ((ProtocolIoFuture)future).setHeldException(exception);
            } else {
                ((ProtocolIoFuture)future).setException(new IOException("Outcome not understood"));
            }
        }
        catch (ClassCastException e) {
            ((ProtocolIoFuture)future).setException(new IOException(e));
        }
        catch (ClassNotFoundException e) {
            ((ProtocolIoFuture)future).setException(new IOException(e));
        }
        catch (IOException e) {
            ((ProtocolIoFuture)future).setException(e);
        }
    }

    private synchronized int getNextCorrelationId() {
        int next;
        if ((next = this.nextCorrelationId++) < 0) {
            this.nextCorrelationId = 2;
            next = 1;
        }
        return next;
    }

    protected synchronized int reserveNextCorrelationId(F future) {
        Integer next = this.getNextCorrelationId();
        while (this.requests.containsKey(next)) {
            next = this.getNextCorrelationId();
        }
        this.requests.put(next, future);
        return next;
    }

    private synchronized F getFuture(int correlationId) {
        return (F)((ProtocolIoFuture)this.requests.get(correlationId));
    }

    protected synchronized void releaseCorrelationId(int correlationId) {
        this.requests.remove(correlationId);
    }

    protected static interface ValueReader<F extends ProtocolIoFuture<?>> {
        public void read(DataInput var1, F var2) throws IOException;
    }
}

