/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public class ProtocolConnectionConfiguration {
    public static final int DEFAULT_WINDOW_SIZE = 32768;
    private static final long DEFAULT_CONNECT_TIMEOUT = 5000L;
    private URI uri;
    private Endpoint endpoint;
    private OptionMap optionMap = OptionMap.EMPTY;
    private long connectionTimeout = 5000L;
    private CallbackHandler callbackHandler;
    private Map<String, String> saslOptions = Collections.emptyMap();
    private SSLContext sslContext;

    protected ProtocolConnectionConfiguration() {
    }

    protected void validate() {
        if (this.endpoint == null) {
            throw ProtocolMessages.MESSAGES.nullVar("endpoint");
        }
        if (this.optionMap == null) {
            throw ProtocolMessages.MESSAGES.nullVar("optionMap");
        }
        if (this.uri == null) {
            throw ProtocolMessages.MESSAGES.nullVar("uri");
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public OptionMap getOptionMap() {
        return this.optionMap;
    }

    public void setOptionMap(OptionMap optionMap) {
        this.optionMap = optionMap;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public Map<String, String> getSaslOptions() {
        return this.saslOptions;
    }

    public void setSaslOptions(Map<String, String> saslOptions) {
        this.saslOptions = saslOptions;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public ProtocolConnectionConfiguration copy() {
        return ProtocolConnectionConfiguration.copy(this);
    }

    public static ProtocolConnectionConfiguration create(Endpoint endpoint, URI uri) {
        return ProtocolConnectionConfiguration.create(endpoint, uri, OptionMap.EMPTY);
    }

    public static ProtocolConnectionConfiguration create(Endpoint endpoint, URI uri, OptionMap options) {
        ProtocolConnectionConfiguration configuration = new ProtocolConnectionConfiguration();
        configuration.setEndpoint(endpoint);
        configuration.setUri(uri);
        configuration.setOptionMap(options);
        return configuration;
    }

    public static ProtocolConnectionConfiguration copy(ProtocolConnectionConfiguration old) {
        ProtocolConnectionConfiguration configuration = new ProtocolConnectionConfiguration();
        configuration.uri = old.uri;
        configuration.endpoint = old.endpoint;
        configuration.optionMap = old.optionMap;
        configuration.connectionTimeout = old.connectionTimeout;
        configuration.callbackHandler = old.callbackHandler;
        configuration.saslOptions = old.saslOptions;
        configuration.sslContext = old.sslContext;
        return configuration;
    }
}

