/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration.as;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.as.ParserAS7;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.as.Attribute;
import org.infinispan.loaders.jdbc.configuration.as.Element;
import org.infinispan.util.StringPropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JdbcCacheStoreConfigurationParserAS7
implements ConfigurationParser<ConfigurationBuilderHolder> {
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:jboss:domain:infinispan", Element.STRING_KEYED_JDBC_STORE.getLocalName(), 1, 4), new Namespace("urn:jboss:domain:infinispan", Element.STRING_KEYED_JDBC_STORE.getLocalName(), 1, 3), new Namespace("urn:jboss:domain:infinispan", Element.BINARY_KEYED_JDBC_STORE.getLocalName(), 1, 4), new Namespace("urn:jboss:domain:infinispan", Element.BINARY_KEYED_JDBC_STORE.getLocalName(), 1, 3), new Namespace("urn:jboss:domain:infinispan", Element.MIXED_KEYED_JDBC_STORE.getLocalName(), 1, 4), new Namespace("urn:jboss:domain:infinispan", Element.MIXED_KEYED_JDBC_STORE.getLocalName(), 1, 3)};

    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJdbcStore(reader, builder.loaders());
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                this.parseBinaryKeyedJdbcStore(reader, builder.loaders());
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                this.parseMixedKeyedJdbcStore(reader, builder.loaders());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseStringKeyedJdbcStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder) throws XMLStreamException {
        JdbcStringBasedCacheStoreConfigurationBuilder builder = new JdbcStringBasedCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseCommonJdbcStoreAttributes(reader, builder);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block3;
                }
            }
            ParserAS7.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseBinaryKeyedJdbcStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder) throws XMLStreamException {
        JdbcBinaryCacheStoreConfigurationBuilder builder = new JdbcBinaryCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseCommonJdbcStoreAttributes(reader, builder);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block3;
                }
            }
            ParserAS7.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseCommonJdbcStoreAttributes(XMLExtendedStreamReader reader, AbstractJdbcCacheStoreConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    builder.dataSource().jndiUrl(value);
                    continue block3;
                }
                default: {
                    ParserAS7.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, builder);
                }
            }
        }
    }

    private void parseMixedKeyedJdbcStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder) throws XMLStreamException {
        JdbcMixedCacheStoreConfigurationBuilder builder = new JdbcMixedCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseCommonJdbcStoreAttributes(reader, builder);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.stringTable());
                    continue block4;
                }
                case BINARY_KEYED_TABLE: {
                    this.parseTable(reader, builder.binaryTable());
                    continue block4;
                }
            }
            ParserAS7.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseTable(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BATCH_SIZE: {
                    builder.batchSize(Integer.parseInt(value));
                    continue block5;
                }
                case FETCH_SIZE: {
                    builder.fetchSize(Integer.parseInt(value));
                    continue block5;
                }
                case PREFIX: {
                    builder.tableNamePrefix(value);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        this.parseTableElements(reader, builder);
    }

    private void parseTableElements(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder builder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.idColumnName(column.name);
                    builder.idColumnType(column.type);
                    continue block5;
                }
                case DATA_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.dataColumnName(column.name);
                    builder.dataColumnType(column.type);
                    continue block5;
                }
                case TIMESTAMP_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.timestampColumnName(column.name);
                    builder.timestampColumnType(column.type);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private Column parseTableElementAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        Column column = new Column();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    column.name = value;
                    continue block4;
                }
                case TYPE: {
                    column.type = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        return column;
    }

    class Column {
        String name;
        String type;

        Column() {
        }
    }
}

