/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jreadline.console.operator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jreadline.console.ConsoleOperation;
import org.jboss.jreadline.console.operator.ControlOperator;

public class ControlOperatorParser {
    private static Pattern controlOperatorPattern = Pattern.compile("(2>&1)|(2>>)|(2>)|(>>)|(>)|(<)|(\\|&)|(\\|)|(;)|(&&)|(&)");
    private static Pattern redirectionNoPipelinePattern = Pattern.compile("(2>&1)|(2>>)|(2>)|(>>)|(>)|(<)");
    private static Pattern pipelinePattern = Pattern.compile("(\\|&)|(\\|)");

    public static boolean doStringContainRedirectionNoPipeline(String buffer) {
        return redirectionNoPipelinePattern.matcher(buffer).find();
    }

    public static boolean doStringContainPipeline(String buffer) {
        return pipelinePattern.matcher(buffer).find();
    }

    public static int getPositionOfFirstRedirection(String buffer) {
        Matcher matcher = redirectionNoPipelinePattern.matcher(buffer);
        if (matcher.find()) {
            return matcher.end();
        }
        return 0;
    }

    public static int findLastPipelinePositionBeforeCursor(String buffer, int cursor) {
        return ControlOperatorParser.findLastRedirectionOrPipelinePositionBeforeCursor(pipelinePattern, buffer, cursor);
    }

    public static int findLastRedirectionPositionBeforeCursor(String buffer, int cursor) {
        return ControlOperatorParser.findLastRedirectionOrPipelinePositionBeforeCursor(redirectionNoPipelinePattern, buffer, cursor);
    }

    private static int findLastRedirectionOrPipelinePositionBeforeCursor(Pattern pattern, String buffer, int cursor) {
        Matcher matcher = pattern.matcher(buffer);
        if (cursor > buffer.length()) {
            cursor = buffer.length();
        }
        int end = 0;
        while (matcher.find()) {
            if (matcher.start() > cursor) {
                return end;
            }
            end = matcher.end();
        }
        return end;
    }

    public static List<ConsoleOperation> findAllControlOperators(String buffer) {
        Matcher matcher = controlOperatorPattern.matcher(buffer);
        ArrayList<ConsoleOperation> reOpList = new ArrayList<ConsoleOperation>();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_OUT_AND_ERR, buffer.substring(0, matcher.start(1))));
                buffer = buffer.substring(matcher.end(1));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(2) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.APPEND_ERR, buffer.substring(0, matcher.start(2))));
                buffer = buffer.substring(matcher.end(2));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(3) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_ERR, buffer.substring(0, matcher.start(3))));
                buffer = buffer.substring(matcher.end(3));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(4) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.APPEND_OUT, buffer.substring(0, matcher.start(4))));
                buffer = buffer.substring(matcher.end(4));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(5) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_OUT, buffer.substring(0, matcher.start(5))));
                buffer = buffer.substring(matcher.end(5));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(6) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_IN, buffer.substring(0, matcher.start(6))));
                buffer = buffer.substring(matcher.end(6));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(7) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.PIPE_OUT_AND_ERR, buffer.substring(0, matcher.start(7))));
                buffer = buffer.substring(matcher.end(7));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(8) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.PIPE, buffer.substring(0, matcher.start(8))));
                buffer = buffer.substring(matcher.end(8));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(9) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.END, buffer.substring(0, matcher.start(9))));
                buffer = buffer.substring(matcher.end(9));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(10) != null) {
                reOpList.add(new ConsoleOperation(ControlOperator.AND, buffer.substring(0, matcher.start(10))));
                buffer = buffer.substring(matcher.end(10));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(11) == null) continue;
            reOpList.add(new ConsoleOperation(ControlOperator.AMP, buffer.substring(0, matcher.start(11))));
            buffer = buffer.substring(matcher.end(11));
            matcher = controlOperatorPattern.matcher(buffer);
        }
        if (reOpList.size() == 0) {
            reOpList.add(new ConsoleOperation(ControlOperator.NONE, buffer));
        }
        if (buffer.trim().length() > 0) {
            reOpList.add(new ConsoleOperation(ControlOperator.NONE, buffer));
        }
        return reOpList;
    }
}

