/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jreadline.edit.mapper;

import java.util.regex.Pattern;
import org.jboss.jreadline.edit.KeyOperation;
import org.jboss.jreadline.edit.actions.Operation;
import org.jboss.jreadline.edit.mapper.OperationMapper;

public class KeyMapper {
    private static Pattern quotePattern = Pattern.compile("^\"");
    private static Pattern metaPattern = Pattern.compile("^(\\\\M|M|Meta)-");
    private static Pattern controlPattern = Pattern.compile("^(\\\\C|C|Control)-");

    public static KeyOperation mapQuoteKeys(String keys, Operation operation) {
        return new KeyOperation(KeyMapper.mapKeys(quotePattern.split(keys)[1]), operation);
    }

    public static KeyOperation mapQuoteKeys(String keys, String operation) {
        return new KeyOperation(KeyMapper.mapKeys(quotePattern.split(keys)[1]), OperationMapper.mapToFunction(operation));
    }

    public static KeyOperation mapKeys(String keys, Operation operation) {
        return new KeyOperation(KeyMapper.mapKeys(keys), operation);
    }

    public static KeyOperation mapKeys(String keys, String operation) {
        return new KeyOperation(KeyMapper.mapKeys(keys), OperationMapper.mapToFunction(operation));
    }

    private static int[] mapKeys(String keys) {
        boolean meta = false;
        boolean control = false;
        String randomKeys = null;
        String rest = keys;
        while (rest != null) {
            String[] split;
            if (metaPattern.matcher(rest).find()) {
                meta = true;
                split = metaPattern.split(rest);
                if (split.length > 1) {
                    rest = split[1];
                    continue;
                }
                rest = null;
                continue;
            }
            if (controlPattern.matcher(rest).find()) {
                control = true;
                split = controlPattern.split(rest);
                if (split.length > 1) {
                    rest = split[1];
                    continue;
                }
                rest = null;
                continue;
            }
            randomKeys = rest;
            rest = null;
        }
        return KeyMapper.mapRandomKeys(randomKeys, control, meta);
    }

    private static int[] mapRandomKeys(String randomKeys, boolean control, boolean meta) {
        int[] out;
        if (randomKeys == null) {
            throw new RuntimeException("ERROR JReadline didnt find any keys after meta/control: " + randomKeys + " Check your inputrc.");
        }
        int pos = 0;
        if (meta) {
            out = new int[randomKeys.length() + 1];
            out[0] = 27;
            pos = 1;
        } else {
            out = new int[randomKeys.length()];
        }
        int[] random = control ? KeyMapper.convertRandomControlKeys(randomKeys) : KeyMapper.convertRandomKeys(randomKeys);
        int i = 0;
        while (i < random.length) {
            out[pos] = random[i];
            ++i;
            ++pos;
        }
        return out;
    }

    private static int[] convertRandomKeys(String random) {
        int[] converted = new int[random.length()];
        for (int i = 0; i < random.length(); ++i) {
            converted[i] = random.charAt(i);
        }
        return converted;
    }

    private static int[] convertRandomControlKeys(String random) {
        int[] converted = new int[random.length()];
        for (int i = 0; i < random.length(); ++i) {
            converted[i] = KeyMapper.lookupControlKey(Character.toLowerCase(random.charAt(i)));
            if (converted[i] != -1) continue;
            throw new RuntimeException("ERROR parsing " + random + " keys to JReadline. Check your inputrc.");
        }
        return converted;
    }

    private static int lookupControlKey(char c) {
        switch (c) {
            case '@': {
                return 0;
            }
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
            case 'd': {
                return 4;
            }
            case 'e': {
                return 5;
            }
            case 'f': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'j': {
                return 10;
            }
            case 'k': {
                return 11;
            }
            case 'l': {
                return 12;
            }
            case 'm': {
                return 13;
            }
            case 'n': {
                return 14;
            }
            case 'o': {
                return 15;
            }
            case 'p': {
                return 16;
            }
            case 'q': {
                return 17;
            }
            case 'r': {
                return 18;
            }
            case 's': {
                return 19;
            }
            case 't': {
                return 20;
            }
            case 'u': {
                return 21;
            }
            case 'v': {
                return 22;
            }
            case 'w': {
                return 23;
            }
            case 'x': {
                return 24;
            }
            case 'y': {
                return 25;
            }
            case 'z': {
                return 26;
            }
            case '[': {
                return 27;
            }
        }
        return -1;
    }
}

