/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.SarLogger;
import org.jboss.as.service.SarMessages;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class StartStopService
extends AbstractService {
    private final Method startMethod;
    private final Method stopMethod;

    StartStopService(Object mBeanInstance, Method startMethod, Method stopMethod) {
        super(mBeanInstance);
        this.startMethod = startMethod;
        this.stopMethod = stopMethod;
    }

    public void start(StartContext context) throws StartException {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Starting Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.startMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            throw SarMessages.MESSAGES.failedExecutingLegacyMethod(e, "start()");
        }
    }

    public void stop(StopContext context) {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Stopping Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.stopMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod(e, "stop()");
        }
    }
}

