/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.controller.transform.AbstractSubsystemTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class InfinispanSubsystemTransformer_1_3
extends AbstractSubsystemTransformer {
    public InfinispanSubsystemTransformer_1_3() {
        super("infinispan");
    }

    public ModelNode transformModel(TransformationContext context, ModelNode model) {
        for (Property p : model.get("cache-container").asPropertyList()) {
            this.transformCache(model, p.getName(), "local-cache");
            this.transformCache(model, p.getName(), "distributed-cache");
            this.transformCache(model, p.getName(), "replicated-cache");
            this.transformCache(model, p.getName(), "invalidation-cache");
        }
        return model;
    }

    private void transformCache(ModelNode model, String containerName, String cacheType) {
        if (!model.get("cache-container").has(containerName) || !model.get(new String[]{"cache-container", containerName}).has(cacheType)) {
            return;
        }
        ModelNode cacheHolder = model.get(new String[]{"cache-container", containerName, cacheType});
        if (!cacheHolder.isDefined()) {
            return;
        }
        for (Property c : cacheHolder.asPropertyList()) {
            ModelNode cache = c.getValue();
            if (cache.has("indexing-properties")) {
                cache.remove("indexing-properties");
            }
            model.get(new String[]{"cache-container", containerName, cacheType, c.getName()}).set(cache);
        }
    }
}

