/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.jbossweb;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.AutoProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.container.catalina.CatalinaFactory;
import org.jboss.modcluster.container.catalina.JMXServerProvider;
import org.jboss.modcluster.container.catalina.ProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.ServerProvider;

public class JBossWebEventHandlerAdapter
extends CatalinaEventHandlerAdapter
implements NotificationListener {
    private volatile ObjectName serviceObjectName = JBossWebEventHandlerAdapter.toObjectName((String)"jboss.web:service=WebServer");
    private volatile String connectorsStartedNotificationType = "jboss.tomcat.connectors.started";
    private volatile String connectorsStoppedNotificationType = "jboss.tomcat.connectors.stopped";
    private final MBeanServer server;

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler) {
        this(eventHandler, ManagementFactory.getPlatformMBeanServer());
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer server) {
        super(eventHandler, (ServerProvider)new JMXServerProvider(server, JBossWebEventHandlerAdapter.toObjectName((String)"jboss.web:type=Server")), (ProxyConnectorProvider)new AutoProxyConnectorProvider());
        this.server = server;
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer server, ServerProvider serverProvider, CatalinaFactory factory) {
        super(eventHandler, serverProvider, factory);
        this.server = server;
    }

    protected void init(Server server) {
        super.init(server);
        if (this.server.isRegistered(this.serviceObjectName)) {
            try {
                this.server.addNotificationListener(this.serviceObjectName, this, null, (Object)server);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void destroy(Server server) {
        if (this.server.isRegistered(this.serviceObjectName)) {
            try {
                this.server.removeNotificationListener(this.serviceObjectName, this);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (ListenerNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        super.destroy(server);
    }

    public void handleNotification(Notification notification, Object object) {
        String type = notification.getType();
        if (type != null) {
            if (type.equals(this.connectorsStartedNotificationType)) {
                if (this.start.get()) {
                    for (Service service : ((Server)object).findServices()) {
                        this.eventHandler.status(this.factory.createEngine((Engine)service.getContainer()));
                    }
                }
            } else if (type.equals(this.connectorsStoppedNotificationType) && this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(this.factory.createServer((Server)object));
            }
        }
    }

    public void setServiceObjectName(ObjectName serviceObjectName) {
        this.serviceObjectName = serviceObjectName;
    }

    public void setConnectorsStoppedNotificationType(String type) {
        this.connectorsStoppedNotificationType = type;
    }

    public void setConnectorsStartedNotificationType(String type) {
        this.connectorsStartedNotificationType = type;
    }

    public int hashCode() {
        return 1;
    }

    protected boolean isAfterInit(LifecycleEvent event) {
        return event.getType().equals("init");
    }

    protected boolean isBeforeDestroy(LifecycleEvent event) {
        return event.getType().equals("destroy");
    }
}

