/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AttributeDefinition {
    private final String name;
    private final String xmlName;
    private final ModelType type;
    private final boolean allowNull;
    private final boolean allowExpression;
    private final ModelNode defaultValue;
    private final MeasurementUnit measurementUnit;
    private final String[] alternatives;
    private final String[] requires;
    private final ParameterCorrector valueCorrector;
    private final ParameterValidator validator;
    private final EnumSet<AttributeAccess.Flag> flags;
    protected final AttributeMarshaller attributeMarshaller;
    private final boolean resourceOnly;
    private final DeprecationData deprecationData;
    private static final ExpressionResolver NO_OPERATION_CONTEXT_FOR_RESOLVING_MODEL_PARAMETERS = new ExpressionResolver(){

        @Override
        public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
            return ExpressionResolver.DEFAULT.resolveExpressions(node);
        }
    };

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterValidator validator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, null, validator, true, alternatives, requires, null, false, null, flags);
    }

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector valueCorrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AttributeAccess.Flag ... flags) {
        this.name = name;
        this.xmlName = xmlName;
        this.type = type;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
        this.defaultValue = new ModelNode();
        if (defaultValue != null) {
            this.defaultValue.set(defaultValue);
        }
        this.defaultValue.protect();
        this.measurementUnit = measurementUnit;
        this.alternatives = alternatives;
        this.requires = requires;
        this.valueCorrector = valueCorrector;
        if (validator == null) {
            this.validator = null;
        } else {
            Boolean nullCheck = validateNull ? Boolean.valueOf(allowNull) : null;
            this.validator = new NillableOrExpressionParameterValidator(validator, nullCheck, allowExpression);
        }
        this.flags = flags == null || flags.length == 0 ? EnumSet.noneOf(AttributeAccess.Flag.class) : (flags.length == 0 ? EnumSet.of(flags[0]) : EnumSet.of(flags[0], flags));
        this.attributeMarshaller = attributeMarshaller != null ? attributeMarshaller : new DefaultAttributeMarshaller();
        this.resourceOnly = resourceOnly;
        this.deprecationData = deprecationData;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public ModelType getType() {
        return this.type;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    public ModelNode getDefaultValue() {
        return this.defaultValue.isDefined() ? this.defaultValue : null;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public String[] getAlternatives() {
        return this.alternatives;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public EnumSet<AttributeAccess.Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public boolean isMarshallable(ModelNode resourceModel) {
        return this.attributeMarshaller.isMarshallable(this, resourceModel, true);
    }

    public boolean isMarshallable(ModelNode resourceModel, boolean marshallDefault) {
        return this.attributeMarshaller.isMarshallable(this, resourceModel, marshallDefault);
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        return this.validateOperation(operationObject, true);
    }

    public final void validateAndSet(ModelNode operationObject, ModelNode model) throws OperationFailedException {
        ModelNode newValue;
        if (operationObject.hasDefined(this.name) && this.isDeprecated()) {
            ControllerLogger.DEPRECATED_LOGGER.attributeDeprecated(this.getName());
        }
        if (!(newValue = this.correctValue(operationObject.get(this.name), model.get(this.name))).equals(operationObject.get(this.name))) {
            operationObject.get(this.name).set(newValue);
        }
        ModelNode node = this.validateOperation(operationObject, false);
        model.get(this.name).set(node);
    }

    @Deprecated
    public ModelNode validateResolvedOperation(ModelNode operationObject) throws OperationFailedException {
        return this.resolveModelAttribute(NO_OPERATION_CONTEXT_FOR_RESOLVING_MODEL_PARAMETERS, operationObject);
    }

    public ModelNode resolveModelAttribute(final OperationContext context, ModelNode model) throws OperationFailedException {
        return this.resolveModelAttribute(new ExpressionResolver(){

            @Override
            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        }, model);
    }

    public ModelNode resolveModelAttribute(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (model.has(this.name)) {
            node.set(model.get(this.name));
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            node.set(this.defaultValue);
        }
        ModelNode resolved = resolver.resolveExpressions(node);
        this.validator.validateParameter(this.name, resolved);
        return resolved;
    }

    public boolean isAllowed(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRequired(ModelNode operationObject) {
        boolean required;
        boolean bl = required = !this.allowNull;
        return required ? !this.hasAlternative(operationObject) : required;
    }

    public boolean hasAlternative(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        this.marshallAsElement(resourceModel, true, writer);
    }

    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerMessages.MESSAGES.couldNotMarshalAttributeAsElement(this.getName());
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode attr = this.getNoTextDescription(false);
        attr.get("description").set(this.getAttributeTextDescription(bundle2, prefix));
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle2, prefix));
        }
        return result;
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode attr = this.getNoTextDescription(false);
        String description = resolver.getResourceAttributeDescription(this.getName(), locale, bundle2);
        attr.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getResourceAttributeDeprecatedDescription(this.getName(), locale, bundle2));
        }
        return result;
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle2, prefix));
        ModelNode result = operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle2, prefix));
        }
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode param = this.getNoTextDescription(true);
        String description = resolver.getOperationParameterDescription(operationName, this.getName(), locale, bundle2);
        param.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getOperationParameterDeprecatedDescription(operationName, this.getName(), locale, bundle2));
        }
        return result;
    }

    public String getAttributeTextDescription(ResourceBundle bundle2, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        return bundle2.getString(bundleKey);
    }

    public String getAttributeDeprecatedDescription(ResourceBundle bundle2, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        bundleKey = bundleKey + ".deprecated";
        return bundle2.getString(bundleKey);
    }

    public ModelNode addDeprecatedInfo(ModelNode model) {
        if (this.deprecationData == null) {
            return null;
        }
        ModelNode deprecated = model.get("deprecated");
        deprecated.get("since").set(this.deprecationData.getSince().toString());
        deprecated.get("reason");
        return deprecated;
    }

    public ModelNode getNoTextDescription(boolean forOperation) {
        ModelNode result = new ModelNode();
        result.get("type").set(this.type);
        result.get("description");
        result.get("expressions-allowed").set(this.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        if (this.defaultValue != null && this.defaultValue.isDefined()) {
            result.get("default").set(this.defaultValue);
        }
        if (this.measurementUnit != null && this.measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(this.measurementUnit.getName());
        }
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if (this.requires != null) {
            for (String required : this.requires) {
                result.get("requires").add(required);
            }
        }
        if (this.validator instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)this.validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.type) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.type) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(result, this.validator);
        return result;
    }

    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
        AllowedValuesValidator avv;
        List<ModelNode> allowed;
        if (validator instanceof AllowedValuesValidator && (allowed = (avv = (AllowedValuesValidator)((Object)validator)).getAllowedValues()) != null) {
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
    }

    protected final ModelNode correctValue(ModelNode newValue, ModelNode oldValue) {
        if (this.valueCorrector != null) {
            return this.valueCorrector.correct(newValue, oldValue);
        }
        return newValue;
    }

    private ModelNode validateOperation(ModelNode operationObject, boolean correctValue) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (operationObject.has(this.name)) {
            node.set(operationObject.get(this.name));
        }
        if (this.isAllowExpression() && node.getType() == ModelType.STRING) {
            node = ParseUtils.parsePossibleExpression(node.asString());
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            if (correctValue) {
                this.correctValue(node, node);
            }
            this.validator.validateParameter(this.name, this.defaultValue);
        } else {
            if (correctValue) {
                this.correctValue(node, node);
            }
            this.validator.validateParameter(this.name, node);
        }
        return node;
    }

    public AttributeMarshaller getAttributeMarshaller() {
        return this.attributeMarshaller;
    }

    public boolean isResourceOnly() {
        return this.resourceOnly;
    }

    public boolean isDeprecated() {
        return this.deprecationData != null;
    }

    public DeprecationData getDeprecationData() {
        return this.deprecationData;
    }
}

