/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class CompositeOperationHandler
implements OperationStepHandler {
    public static final CompositeOperationHandler INSTANCE = new CompositeOperationHandler();
    public static final String NAME = "composite";
    private static final AttributeDefinition STEPS = new PrimitiveListAttributeDefinition.Builder("steps", ModelType.OBJECT).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("composite", ControllerResolver.getResolver("root")).addParameter(STEPS).setReplyType(ModelType.OBJECT).setPrivateEntry().build();

    private CompositeOperationHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        int i;
        STEPS.validateOperation(operation);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        List list = operation.get("steps").asList();
        final ModelNode responseMap = context.getResult().setEmptyObject();
        HashMap<String, OperationStepHandler> stepHandlerMap = new HashMap<String, OperationStepHandler>();
        final int size = list.size();
        for (i = 0; i < size; ++i) {
            String stepName = "step-" + (i + 1);
            responseMap.get(stepName);
            ModelNode subOperation = (ModelNode)list.get(i);
            PathAddress stepAddress = PathAddress.pathAddress(subOperation.get("address"));
            String stepOpName = subOperation.require("operation").asString();
            OperationStepHandler stepHandler = registry.getOperationHandler(stepAddress, stepOpName);
            if (stepHandler == null) {
                context.getFailureDescription().set(ControllerMessages.MESSAGES.noHandler(stepOpName, stepAddress));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                return;
            }
            stepHandlerMap.put(stepName, stepHandler);
        }
        for (i = size - 1; i >= 0; --i) {
            ModelNode subOperation = (ModelNode)list.get(i);
            String stepName = "step-" + (i + 1);
            context.addStep(responseMap.get(stepName).setEmptyObject(), subOperation, (OperationStepHandler)stepHandlerMap.get(stepName), OperationContext.Stage.IMMEDIATE);
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                ModelNode failureMsg = new ModelNode();
                for (int i = 0; i < size; ++i) {
                    String stepName = "step-" + (i + 1);
                    ModelNode stepResponse = responseMap.get(stepName);
                    if (!stepResponse.hasDefined("failure-description")) continue;
                    failureMsg.get(new String[]{ControllerMessages.MESSAGES.compositeOperationFailed(), ControllerMessages.MESSAGES.operation(stepName)}).set(stepResponse.get("failure-description"));
                }
                if (!failureMsg.isDefined()) {
                    failureMsg.set(ControllerMessages.MESSAGES.compositeOperationRolledBack());
                }
                context.getFailureDescription().set(failureMsg);
            }
        });
    }
}

