/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectListAttributeDefinition
extends ListAttributeDefinition {
    private final ObjectTypeAttributeDefinition valueType;

    private ObjectListAttributeDefinition(String name, String xmlName, ObjectTypeAttributeDefinition valueType, boolean allowNull, int minSize, int maxSize, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AttributeAccess.Flag ... flags) {
        super(name, xmlName, allowNull, minSize, maxSize, valueType.getValidator(), alternatives, requires, attributeMarshaller, resourceOnly, deprecated, flags);
        this.valueType = valueType;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode attr = this.getNoTextDescription(false);
        attr.get("description").set(this.getAttributeTextDescription(bundle2, prefix));
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        this.addValueTypeDescription(result, prefix, bundle2, false, null, null);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle2, prefix));
        ModelNode result = operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        this.addValueTypeDescription(result, prefix, bundle2, true, null, null);
        return result;
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        this.addValueTypeDescription(node, this.valueType.getName(), bundle2, false, null, null);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.addValueTypeDescription(node, this.getName(), bundle2, false, resolver, locale);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.addValueTypeDescription(node, this.getName(), bundle2, true, resolver, locale);
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (resourceModel.hasDefined(this.getName())) {
            writer.writeStartElement(this.getXmlName());
            for (ModelNode handler : resourceModel.get(this.getName()).asList()) {
                this.valueType.marshallAsElement(handler, writer);
            }
            writer.writeEndElement();
        }
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle2, boolean forOperation, ResourceDescriptionResolver resolver, Locale locale) {
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        node.get("description");
        node.get("expressions-allowed").set(this.valueType.isAllowExpression());
        if (forOperation) {
            node.get("required").set(!this.valueType.isAllowNull());
        }
        node.get("nillable").set(this.isAllowNull());
        ModelNode defaultValue = this.valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            node.get("default").set(defaultValue);
        }
        if ((measurementUnit = this.valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            node.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = this.valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                node.get("alternatives").add(alternative);
            }
        }
        if ((requires = this.valueType.getRequires()) != null) {
            for (String required : requires) {
                node.get("requires").add(required);
            }
        }
        if ((validator = this.valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        node.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        node.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        node.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        node.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(node, validator);
        this.valueType.addValueTypeDescription(node, prefix, bundle2, resolver, locale);
    }

    public static final class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, ObjectListAttributeDefinition> {
        private final ObjectTypeAttributeDefinition valueType;

        public Builder(String name, ObjectTypeAttributeDefinition valueType) {
            super(name, ModelType.LIST);
            this.valueType = valueType;
        }

        public static Builder of(String name, ObjectTypeAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        @Override
        public ObjectListAttributeDefinition build() {
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            return new ObjectListAttributeDefinition(this.name, this.xmlName, this.valueType, this.allowNull, this.minSize, this.maxSize, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.flags);
        }

        @Override
        public Builder setAllowNull(boolean allowNull) {
            return (Builder)super.setAllowNull(allowNull);
        }
    }
}

