/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.List;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;

public class NillableOrExpressionParameterValidator
implements ParameterValidator,
MinMaxValidator,
AllowedValuesValidator {
    private final ParameterValidator delegate;
    private final Boolean allowNull;
    private final boolean allowExpression;

    public NillableOrExpressionParameterValidator(ParameterValidator delegate, Boolean allowNull, boolean allowExpression) {
        this.delegate = delegate;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        switch (value.getType()) {
            case EXPRESSION: {
                if (this.allowExpression) break;
                throw ControllerMessages.MESSAGES.expressionNotAllowed(parameterName);
            }
            case UNDEFINED: {
                if (this.allowNull != null) {
                    if (this.allowNull.booleanValue()) break;
                    throw ControllerMessages.MESSAGES.nullNotAllowed(parameterName);
                }
            }
            default: {
                this.delegate.validateParameter(parameterName, value);
            }
        }
    }

    @Override
    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
        if (!value.isDefined()) {
            if (!this.allowExpression) {
                throw ControllerMessages.MESSAGES.nullNotAllowed(parameterName);
            }
        } else {
            this.delegate.validateResolvedParameter(parameterName, value);
        }
    }

    @Override
    public Long getMin() {
        return this.delegate instanceof MinMaxValidator ? ((MinMaxValidator)((Object)this.delegate)).getMin() : null;
    }

    @Override
    public Long getMax() {
        return this.delegate instanceof MinMaxValidator ? ((MinMaxValidator)((Object)this.delegate)).getMax() : null;
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        return this.delegate instanceof AllowedValuesValidator ? ((AllowedValuesValidator)((Object)this.delegate)).getAllowedValues() : null;
    }
}

