/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.File;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.as.controller.persistence.FilePersistenceUtils;
import org.jboss.dmr.ModelNode;

public class FilePersistenceResource
extends AbstractFilePersistenceResource {
    private final File tempFileName;
    protected final File fileName;

    FilePersistenceResource(ModelNode model, File fileName, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.fileName = fileName;
        this.tempFileName = FilePersistenceUtils.createTempFile(fileName);
    }

    @Override
    protected void doCommit(ExposedByteArrayOutputStream marshalled) {
        try {
            FilePersistenceUtils.writeToTempFile(marshalled, this.tempFileName);
            FilePersistenceUtils.moveTempFileToMain(this.tempFileName, this.fileName);
        }
        catch (Exception e) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
        }
    }
}

