/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AliasResourceRegistration;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ConcreteResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.ProxyControllerRegistration;

final class NodeSubregistry {
    private static final String WILDCARD_VALUE = "*";
    private final String keyName;
    private final ConcreteResourceRegistration parent;
    private volatile Map<String, AbstractResourceRegistration> childRegistries;
    private static final AtomicMapFieldUpdater<NodeSubregistry, String, AbstractResourceRegistration> childRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(NodeSubregistry.class, Map.class, "childRegistries"));

    NodeSubregistry(String keyName, ConcreteResourceRegistration parent) {
        this.keyName = keyName;
        this.parent = parent;
        childRegistriesUpdater.clear(this);
    }

    AbstractResourceRegistration getParent() {
        return this.parent;
    }

    Set<String> getChildNames() {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        if (snapshot == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(snapshot.keySet());
    }

    ManagementResourceRegistration register(String elementValue, ResourceDefinition provider, boolean runtimeOnly) {
        ConcreteResourceRegistration newRegistry = new ConcreteResourceRegistration(elementValue, this, provider, runtimeOnly);
        AbstractResourceRegistration existingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry);
        if (existingRegistry != null) {
            throw ControllerMessages.MESSAGES.nodeAlreadyRegistered(this.getLocationString(), elementValue);
        }
        return newRegistry;
    }

    ProxyControllerRegistration registerProxyController(String elementValue, ProxyController proxyController) {
        ProxyControllerRegistration newRegistry = new ProxyControllerRegistration(elementValue, this, proxyController);
        AbstractResourceRegistration appearingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry);
        if (appearingRegistry != null) {
            throw ControllerMessages.MESSAGES.nodeAlreadyRegistered(this.getLocationString(), elementValue);
        }
        return newRegistry;
    }

    void unregisterProxyController(String elementValue) {
        childRegistriesUpdater.remove(this, elementValue);
    }

    public AliasResourceRegistration registerAlias(String elementValue, AliasEntry aliasEntry, AbstractResourceRegistration target) {
        AliasResourceRegistration newRegistry = new AliasResourceRegistration(elementValue, this, aliasEntry, target);
        AbstractResourceRegistration existingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry);
        if (existingRegistry != null) {
            throw ControllerMessages.MESSAGES.nodeAlreadyRegistered(this.getLocationString(), elementValue);
        }
        return newRegistry;
    }

    public void unregisterAlias(String elementValue) {
        childRegistriesUpdater.remove(this, elementValue);
    }

    void unregisterSubModel(String elementValue) {
        childRegistriesUpdater.remove(this, elementValue);
    }

    OperationEntry getOperationEntry(ListIterator<PathElement> iterator, String child, String operationName, OperationEntry inherited) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        OperationEntry result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getOperationEntry(searchControl.getIterator(), operationName, inherited);
        }
        if (result == null && searchControl.getWildCardRegistry() != null) {
            result = searchControl.getWildCardRegistry().getOperationEntry(searchControl.getIterator(), operationName, inherited);
        }
        return result;
    }

    void getHandlers(ListIterator<PathElement> iterator, String child, Map<String, OperationEntry> providers, boolean inherited) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        if (searchControl.getWildCardRegistry() != null) {
            searchControl.getWildCardRegistry().getOperationDescriptions(searchControl.getIterator(), providers, inherited);
        }
        if (searchControl.getSpecifiedRegistry() != null) {
            searchControl.getSpecifiedRegistry().getOperationDescriptions(searchControl.getIterator(), providers, inherited);
        }
    }

    String getLocationString() {
        return this.parent.getLocationString() + "(" + this.keyName + " => ";
    }

    DescriptionProvider getModelDescription(ListIterator<PathElement> iterator, String child) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        DescriptionProvider result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getModelDescription(searchControl.getIterator());
        }
        if (result == null && searchControl.getWildCardRegistry() != null) {
            result = searchControl.getWildCardRegistry().getModelDescription(searchControl.getIterator());
        }
        return result;
    }

    Set<String> getChildNames(ListIterator<PathElement> iterator, String child) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        Set<String> result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getChildNames(searchControl.getIterator());
        }
        if (searchControl.getWildCardRegistry() != null) {
            Set<String> wildCardChildren = searchControl.getWildCardRegistry().getChildNames(searchControl.getIterator());
            if (result == null) {
                result = wildCardChildren;
            } else if (wildCardChildren != null) {
                result = new HashSet<String>(result);
                result.addAll(wildCardChildren);
            }
        }
        return result;
    }

    Set<String> getAttributeNames(ListIterator<PathElement> iterator, String child) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        Set<String> result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getAttributeNames(searchControl.getIterator());
        }
        if (searchControl.getWildCardRegistry() != null) {
            Set<String> wildCardChildren = searchControl.getWildCardRegistry().getAttributeNames(searchControl.getIterator());
            if (result == null) {
                result = wildCardChildren;
            } else if (wildCardChildren != null) {
                result = new HashSet<String>(result);
                result.addAll(wildCardChildren);
            }
        }
        return result;
    }

    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String child, String attributeName) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        AttributeAccess result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getAttributeAccess(searchControl.getIterator(), attributeName);
        }
        if (result == null && searchControl.getWildCardRegistry() != null) {
            result = searchControl.getWildCardRegistry().getAttributeAccess(searchControl.getIterator(), attributeName);
        }
        return result;
    }

    Set<PathElement> getChildAddresses(ListIterator<PathElement> iterator, String child) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        Set<PathElement> result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getChildAddresses(searchControl.getIterator());
        }
        if (searchControl.getWildCardRegistry() != null) {
            Set<PathElement> wildCardChildren = searchControl.getWildCardRegistry().getChildAddresses(searchControl.getIterator());
            if (result == null) {
                result = wildCardChildren;
            } else if (wildCardChildren != null) {
                result = new HashSet<PathElement>(result);
                result.addAll(wildCardChildren);
            }
        }
        return result;
    }

    ProxyController getProxyController(ListIterator<PathElement> iterator, String child) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        ProxyController result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getProxyController(searchControl.getIterator());
        }
        if (result == null && searchControl.getWildCardRegistry() != null) {
            result = searchControl.getWildCardRegistry().getProxyController(searchControl.getIterator());
        }
        return result;
    }

    AbstractResourceRegistration getResourceRegistration(ListIterator<PathElement> iterator, String child) {
        RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
        AbstractResourceRegistration result = null;
        if (searchControl.getSpecifiedRegistry() != null) {
            result = searchControl.getSpecifiedRegistry().getResourceRegistration(searchControl.getIterator());
        }
        if (result == null && searchControl.getWildCardRegistry() != null) {
            result = searchControl.getWildCardRegistry().getResourceRegistration(searchControl.getIterator());
        }
        return result;
    }

    void getProxyControllers(ListIterator<PathElement> iterator, String child, Set<ProxyController> controllers) {
        if (child != null) {
            RegistrySearchControl searchControl = new RegistrySearchControl(iterator, child);
            if (searchControl.getWildCardRegistry() != null) {
                searchControl.getWildCardRegistry().getProxyControllers(searchControl.getIterator(), controllers);
            }
            if (searchControl.getSpecifiedRegistry() != null) {
                searchControl.getSpecifiedRegistry().getProxyControllers(searchControl.getIterator(), controllers);
            }
        } else {
            Map<String, AbstractResourceRegistration> snapshot = childRegistriesUpdater.get(this);
            for (AbstractResourceRegistration childRegistry : snapshot.values()) {
                childRegistry.getProxyControllers(iterator, controllers);
            }
        }
    }

    String getKeyName() {
        return this.keyName;
    }

    private class RegistrySearchControl {
        private final AbstractResourceRegistration specifiedRegistry;
        private final AbstractResourceRegistration wildCardRegistry;
        private final ListIterator<PathElement> iterator;
        private final int restoreIndex;
        private boolean backupRequired;

        private RegistrySearchControl(ListIterator<PathElement> iterator, String childName) {
            Map snapshot = childRegistriesUpdater.get(NodeSubregistry.this);
            this.specifiedRegistry = (AbstractResourceRegistration)snapshot.get(childName);
            this.wildCardRegistry = NodeSubregistry.WILDCARD_VALUE.equals(childName) ? null : (AbstractResourceRegistration)snapshot.get(NodeSubregistry.WILDCARD_VALUE);
            this.iterator = iterator;
            this.restoreIndex = this.specifiedRegistry != null && this.wildCardRegistry != null ? iterator.nextIndex() : -1;
        }

        private AbstractResourceRegistration getSpecifiedRegistry() {
            return this.specifiedRegistry;
        }

        private AbstractResourceRegistration getWildCardRegistry() {
            return this.wildCardRegistry;
        }

        private ListIterator<PathElement> getIterator() {
            if (this.backupRequired) {
                if (this.restoreIndex == -1) {
                    throw new IllegalStateException("Multiple iterator requests are not supported since both named and wildcard entries were not present");
                }
                while (this.iterator.nextIndex() > this.restoreIndex) {
                    this.iterator.previous();
                }
            }
            this.backupRequired = true;
            return this.iterator;
        }
    }
}

