/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class RejectExpressionValuesTransformer
implements ResourceTransformer,
OperationTransformer {
    private final Set<String> attributeNames;
    private final OperationTransformer writeAttributeTransformer = new WriteAttributeTransformer();
    private static final Pattern pattern = Pattern.compile(".*\\$\\{.*\\}.*");

    public RejectExpressionValuesTransformer(AttributeDefinition ... attributes) {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition def : attributes) {
            names.add(def.getName());
        }
        this.attributeNames = names;
    }

    public RejectExpressionValuesTransformer(String ... attributeNames) {
        this.attributeNames = new HashSet<String>();
        this.attributeNames.addAll(Arrays.asList(attributeNames));
    }

    public OperationTransformer getWriteAttributeTransformer() {
        return this.writeAttributeTransformer;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        final Set<String> attributes = this.checkModel(operation);
        boolean reject = attributes.size() > 0;
        OperationRejectionPolicy rejectPolicy = reject ? new OperationRejectionPolicy(){

            @Override
            public boolean rejectOperation(ModelNode preparedResult) {
                return true;
            }

            @Override
            public String getFailureDescription() {
                return ControllerMessages.MESSAGES.expressionNotAllowed(attributes.toString()).getMessage();
            }
        } : OperationTransformer.DEFAULT_REJECTION_POLICY;
        return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        Set<String> attributes = this.checkModel(model);
        if (attributes.size() > 0) {
            throw ControllerMessages.MESSAGES.expressionNotAllowed(attributes.toString());
        }
        ResourceTransformer.DEFAULT.transformResource(context, address, resource);
    }

    protected Set<String> checkModel(ModelNode model) throws OperationFailedException {
        HashSet<String> attributes = new HashSet<String>();
        for (String attribute : this.attributeNames) {
            if (!model.hasDefined(attribute) || !this.checkForExpression(model.get(attribute))) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    protected boolean checkForExpression(ModelNode node) {
        if (!node.isDefined()) {
            return false;
        }
        ModelNode resolved = node.clone();
        if (node.getType() == ModelType.EXPRESSION || node.getType() == ModelType.STRING) {
            return this.checkForExpression(resolved.asString());
        }
        if (node.getType() == ModelType.OBJECT) {
            for (Property prop : resolved.asPropertyList()) {
                if (!this.checkForExpression(prop.getValue())) continue;
                return true;
            }
        } else if (node.getType() == ModelType.LIST) {
            for (ModelNode current : resolved.asList()) {
                if (!this.checkForExpression(current)) continue;
                return true;
            }
        } else if (node.getType() == ModelType.PROPERTY) {
            return this.checkForExpression(resolved.asProperty().getValue());
        }
        return false;
    }

    protected boolean checkForExpression(String value) {
        return pattern.matcher(value).matches();
    }

    class WriteAttributeTransformer
    implements OperationTransformer {
        WriteAttributeTransformer() {
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            boolean rejectResult;
            final String attribute = operation.require("name").asString();
            boolean containsExpression = false;
            if (RejectExpressionValuesTransformer.this.attributeNames.contains(attribute) && operation.hasDefined("value")) {
                containsExpression = RejectExpressionValuesTransformer.this.checkForExpression(operation.get("value"));
            }
            if (rejectResult = containsExpression) {
                OperationRejectionPolicy rejectPolicy = new OperationRejectionPolicy(){

                    @Override
                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    @Override
                    public String getFailureDescription() {
                        return ControllerMessages.MESSAGES.expressionNotAllowed(attribute).getMessage();
                    }
                };
                return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

