/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRPropertyDefinition;
import org.jboss.as.jaxr.extension.JAXRSubsystemParser;
import org.jboss.as.jaxr.extension.JAXRSubsystemRootResource;
import org.jboss.as.jaxr.extension.JAXRSubsystemWriter;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JAXRExtension
implements Extension {
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jaxr");
    static final PathElement PROPERTY_PATH = PathElement.pathElement((String)"property");
    private final JAXRSubsystemParser parser = new JAXRSubsystemParser();
    private final JAXRConfiguration config = new JAXRConfiguration();
    private static final String RESOURCE_NAME = JAXRConfiguration.class.getPackage().getName() + ".LocalDescriptions";

    static ResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder("jaxr");
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JAXRConfiguration.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping("jaxr", JAXRConstants.Namespace.JAXR_1_1.getUriString(), (XMLElementReader)this.parser);
        context.setSubsystemXmlMapping("jaxr", JAXRConstants.Namespace.JAXR_1_0.getUriString(), (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem("jaxr", 1, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new JAXRSubsystemRootResource(this.config));
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        registration.registerSubModel((ResourceDefinition)new JAXRPropertyDefinition(this.config));
        subsystem.registerXMLElementWriter((XMLElementWriter)JAXRSubsystemWriter.INSTANCE);
    }
}

