/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements Context {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final boolean multithreaded;
    private final ServiceRegistry serviceRegistry;

    public AbstractContext(boolean multithreaded) {
        this.multithreaded = multithreaded;
        this.serviceRegistry = Container.instance().services();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="False positive from FindBugs")
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            return null;
        }
        if (contextual == null) {
            throw new IllegalArgumentException(ContextMessage.CONTEXTUAL_IS_NULL, new Object[0]);
        }
        String id = this.getId(contextual);
        Object beanInstance = beanStore.get(id);
        if (beanInstance != null) {
            return (T)beanInstance.getInstance();
        }
        if (creationalContext != null) {
            LockedBean lock = null;
            try {
                Object instance;
                if (this.multithreaded) {
                    lock = beanStore.lock(id);
                    beanInstance = beanStore.get(id);
                    if (beanInstance != null) {
                        Object object = beanInstance.getInstance();
                        return (T)object;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableContextualInstanceImpl<Contextual<T>, Object>(contextual, instance, creationalContext, (ContextualStore)this.serviceRegistry.get(ContextualStore.class));
                    beanStore.put(id, beanInstance);
                }
                Object object = instance;
                return (T)object;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private <T> void destroy(String id) {
        if (this.getBeanStore() == null) {
            throw new IllegalStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        ContextualInstance beanInstance = this.getBeanStore().get(id);
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
        log.trace((Enum)ContextMessage.CONTEXTUAL_INSTANCE_REMOVED, new Object[]{id, this});
    }

    protected void destroy() {
        log.trace((Enum)ContextMessage.CONTEXT_CLEARED, new Object[]{this});
        if (this.getBeanStore() == null) {
            throw new IllegalStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        for (String id : this.getBeanStore()) {
            this.destroy(id);
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    public void cleanup() {
        if (this.getBeanStore() != null) {
            this.getBeanStore().clear();
        }
    }

    protected static <T> Contextual<T> getContextual(String id) {
        return ((ContextualStore)Container.instance().services().get(ContextualStore.class)).getContextual(id);
    }

    protected String getId(Contextual<?> contextual) {
        return ((ContextualStore)this.serviceRegistry.get(ContextualStore.class)).putIfAbsent(contextual);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

