/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.HornetQComponentControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractHornetQComponentControlHandler<T extends HornetQComponentControl>
extends AbstractRuntimeOnlyHandler {
    private static final SimpleAttributeDefinition STARTED = SimpleAttributeDefinitionBuilder.create((String)"started", (ModelType)ModelType.BOOLEAN).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private ParametersValidator readAttributeValidator = new ParametersValidator();

    protected AbstractHornetQComponentControlHandler() {
        this.readAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        OperationContext.RollbackHandler rh;
        final String operationName = operation.require("operation").asString();
        HornetQComponentControl control = null;
        boolean appliedToRuntime = false;
        Object handback = null;
        if ("read-attribute".equals(operationName)) {
            this.readAttributeValidator.validate(operation);
            String name = operation.require("name").asString();
            if (STARTED.getName().equals(name)) {
                control = (HornetQComponentControl)this.getHornetQComponentControl(context, operation, false);
                context.getResult().set(control.isStarted());
            } else {
                this.handleReadAttribute(name, context, operation);
            }
        } else if ("start".equals(operationName)) {
            control = (HornetQComponentControl)this.getHornetQComponentControl(context, operation, true);
            try {
                control.start();
                appliedToRuntime = true;
                context.getResult();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else if ("stop".equals(operationName)) {
            control = (HornetQComponentControl)this.getHornetQComponentControl(context, operation, true);
            try {
                control.stop();
                appliedToRuntime = true;
                context.getResult();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            handback = this.handleOperation(operationName, context, operation);
            boolean bl = appliedToRuntime = handback != null;
        }
        if (appliedToRuntime) {
            final HornetQComponentControl rhControl = control;
            final Object rhHandback = handback;
            rh = new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    try {
                        if ("start".equals(operationName)) {
                            rhControl.stop();
                        } else if ("stop".equals(operationName)) {
                            rhControl.start();
                        } else {
                            AbstractHornetQComponentControlHandler.this.handleRevertOperation(operationName, context, operation, rhHandback);
                        }
                    }
                    catch (Exception e) {
                        MessagingLogger.ROOT_LOGGER.revertOperationFailed(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
                    }
                }
            };
        } else {
            rh = OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
        }
        context.completeStep(rh);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        registry.registerReadOnlyAttribute((AttributeDefinition)STARTED, (OperationStepHandler)this);
    }

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        SimpleOperationDefinition startOp = new SimpleOperationDefinitionBuilder("start", resolver).build();
        registry.registerOperationHandler((OperationDefinition)startOp, (OperationStepHandler)this);
        SimpleOperationDefinition stopOp = new SimpleOperationDefinitionBuilder("stop", resolver).build();
        registry.registerOperationHandler((OperationDefinition)stopOp, (OperationStepHandler)this);
    }

    protected abstract T getHornetQComponentControl(HornetQServer var1, PathAddress var2);

    protected abstract String getDescriptionPrefix();

    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        this.unsupportedAttribute(attributeName);
    }

    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        this.unsupportedOperation(operationName);
        throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
    }

    protected void handleRevertOperation(String operationName, OperationContext context, ModelNode operation, Object handback) {
    }

    protected final void unsupportedAttribute(String attributeName) {
        throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
    }

    protected final void unsupportedOperation(String operationName) {
        throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
    }

    protected final T getHornetQComponentControl(OperationContext context, ModelNode operation, boolean forWrite) throws OperationFailedException {
        PathAddress address;
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(forWrite).getService(hqServiceName);
        HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        T control = this.getHornetQComponentControl(server, address = PathAddress.pathAddress((ModelNode)operation.require("address")));
        if (control == null) {
            throw new OperationFailedException(ControllerMessages.MESSAGES.noHandler("read-attribute", PathAddress.pathAddress((ModelNode)operation.require("address"))));
        }
        return control;
    }
}

