/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;

public class BroadcastGroupWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    public static final BroadcastGroupWriteAttributeHandler INSTANCE = new BroadcastGroupWriteAttributeHandler();
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

    private BroadcastGroupWriteAttributeHandler() {
        for (AttributeDefinition attr : BroadcastGroupDefinition.ATTRIBUTES) {
            this.attributes.put(attr.getName(), attr);
        }
    }

    protected void modelChanged(OperationContext context, ModelNode operation, final String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource;
                AttributeDefinition attr = (AttributeDefinition)BroadcastGroupWriteAttributeHandler.this.attributes.get(attributeName);
                if (attr.hasAlternative((resource = context.readResource(PathAddress.EMPTY_ADDRESS)).getModel())) {
                    context.setRollbackOnly();
                    throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.altAttributeAlreadyDefined(attributeName)));
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.VERIFY);
        context.reloadRequired();
        context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }
}

