/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.JournalTypeValidator;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface CommonAttributes {
    public static final String DISCOVERY_GROUP_NAME = "discovery-group-name";
    public static final String ENTRIES = "entries";
    public static final SimpleAttributeDefinition ALLOW_FAILBACK = new SimpleAttributeDefinition("allow-failback", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition ASYNC_CONNECTION_EXECUTION_ENABLED = new SimpleAttributeDefinition("async-connection-execution-enabled", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition BACKUP = new SimpleAttributeDefinition("backup", new ModelNode().set(false), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition CALL_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"call-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(30000L)).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).build();
    public static final SimpleAttributeDefinition CALL_FAILOVER_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"call-failover-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(-1L)).setAllowNull(true).setMeasurementUnit(MeasurementUnit.MILLISECONDS).build();
    public static final SimpleAttributeDefinition CHECK_PERIOD = SimpleAttributeDefinitionBuilder.create((String)"check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(30000L)).setAllowNull(true).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final AttributeDefinition CLIENT_ID = SimpleAttributeDefinitionBuilder.create((String)"client-id", (ModelType)ModelType.STRING).setAllowNull(true).build();
    public static final SimpleAttributeDefinition CHECK_FOR_LIVE_SERVER = SimpleAttributeDefinitionBuilder.create((String)"check-for-live-server", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false)).setAllowNull(true).build();
    public static final SimpleAttributeDefinition CLUSTERED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"clustered", (ModelType)ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).setDeprecated(MessagingExtension.VERSION_1_2_0)).setAttributeMarshaller(AttributeMarshallers.NOOP_MARSHALLER)).setStorageRuntime().build();
    public static final SimpleAttributeDefinition CLUSTER_PASSWORD = new SimpleAttributeDefinition("cluster-password", "cluster-password", new ModelNode().set("CHANGE ME!!"), ModelType.STRING, true, true, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition CLUSTER_USER = new SimpleAttributeDefinition("cluster-user", "cluster-user", new ModelNode().set("HORNETQ.CLUSTER.ADMIN.USER"), ModelType.STRING, true, true, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition CONSUMER_COUNT = SimpleAttributeDefinitionBuilder.create((String)"consumer-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    public static final SimpleAttributeDefinition BRIDGE_CONFIRMATION_WINDOW_SIZE = SimpleAttributeDefinitionBuilder.create((String)"confirmation-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000)).setMeasurementUnit(MeasurementUnit.BYTES).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL = SimpleAttributeDefinitionBuilder.create((String)"connection-ttl", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(60000L)).setAllowNull(true).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL_OVERRIDE = new SimpleAttributeDefinition("connection-ttl-override", new ModelNode().set(-1L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition CONSUMER_MAX_RATE = new SimpleAttributeDefinition("consumer-max-rate", new ModelNode().set(-1), ModelType.INT, true, MeasurementUnit.PER_SECOND);
    public static final SimpleAttributeDefinition CREATE_BINDINGS_DIR = new SimpleAttributeDefinition("create-bindings-dir", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition CREATE_JOURNAL_DIR = new SimpleAttributeDefinition("create-journal-dir", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition DEAD_LETTER_ADDRESS = new SimpleAttributeDefinition("dead-letter-address", ModelType.STRING, true);
    public static final AttributeDefinition DELIVERING_COUNT = SimpleAttributeDefinitionBuilder.create((String)"delivering-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    public static final PrimitiveListAttributeDefinition DESTINATION_ENTRIES = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"entries", (ModelType)ModelType.STRING).setAllowNull(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.JndiEntriesAttributeMarshaller(true))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DURABLE = SimpleAttributeDefinitionBuilder.create((String)"durable", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true)).setAllowNull(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition FACTORY_CLASS = SimpleAttributeDefinitionBuilder.create((String)"factory-class", (ModelType)ModelType.STRING).setRestartAllServices().build();
    public static final SimpleAttributeDefinition EXPIRY_ADDRESS = new SimpleAttributeDefinition("expiry-address", ModelType.STRING, true);
    public static final SimpleAttributeDefinition FAILBACK_DELAY = new SimpleAttributeDefinition("failback-delay", new ModelNode().set(5000L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition FAILOVER_ON_SERVER_SHUTDOWN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failover-on-server-shutdown", (ModelType)ModelType.BOOLEAN).setAllowNull(true).setDeprecated(MessagingExtension.VERSION_1_2_0)).setAttributeMarshaller(AttributeMarshallers.NOOP_MARSHALLER)).build();
    public static final SimpleAttributeDefinition FAILOVER_ON_SHUTDOWN = new SimpleAttributeDefinition("failover-on-shutdown", new ModelNode().set(false), ModelType.BOOLEAN, true);
    public static final SimpleAttributeDefinition FILTER = SimpleAttributeDefinitionBuilder.create((String)"filter", (ModelType)ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition GROUP_ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"group-address", (ModelType)ModelType.STRING).setDefaultValue(null).setAllowNull(true).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition GROUP_PORT = SimpleAttributeDefinitionBuilder.create((String)"group-port", (ModelType)ModelType.INT).setDefaultValue(null).setAllowNull(true).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition HA = SimpleAttributeDefinitionBuilder.create((String)"ha", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false)).setAllowNull(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition ID_CACHE_SIZE = new SimpleAttributeDefinition("id-cache-size", new ModelNode().set(20000), ModelType.INT, true, MeasurementUnit.NONE, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JMX_DOMAIN = new SimpleAttributeDefinition("jmx-domain", new ModelNode().set("org.hornetq"), ModelType.STRING, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JMX_MANAGEMENT_ENABLED = new SimpleAttributeDefinition("jmx-management-enabled", new ModelNode().set(false), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_SIZE = new SimpleAttributeDefinition("journal-buffer-size", ModelType.LONG, true, MeasurementUnit.BYTES, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_TIMEOUT = new SimpleAttributeDefinition("journal-buffer-timeout", ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_MIN_FILES = new SimpleAttributeDefinition("journal-compact-min-files", new ModelNode().set(10), ModelType.INT, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_PERCENTAGE = new SimpleAttributeDefinition("journal-compact-percentage", new ModelNode().set(30), ModelType.INT, true, MeasurementUnit.PERCENTAGE, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_FILE_SIZE = new SimpleAttributeDefinition("journal-file-size", new ModelNode().set(0xA00000), ModelType.LONG, true, MeasurementUnit.BYTES, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_MAX_IO = new SimpleAttributeDefinition("journal-max-io", ModelType.INT, true, MeasurementUnit.NONE, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_MIN_FILES = new SimpleAttributeDefinition("journal-min-files", new ModelNode().set(2), ModelType.INT, true, MeasurementUnit.NONE, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_SYNC_NON_TRANSACTIONAL = new SimpleAttributeDefinition("journal-sync-non-transactional", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_SYNC_TRANSACTIONAL = new SimpleAttributeDefinition("journal-sync-transactional", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition JOURNAL_TYPE = new SimpleAttributeDefinition("journal-type", "journal-type", new ModelNode().set(ConfigurationImpl.DEFAULT_JOURNAL_TYPE.toString()), ModelType.STRING, true, false, MeasurementUnit.NONE, (ParameterValidator)JournalTypeValidator.INSTANCE, null, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition LIVE_CONNECTOR_REF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"live-connector-ref", (ModelType)ModelType.STRING).setAllowNull(true).setDeprecated(MessagingExtension.VERSION_1_2_0)).setRestartAllServices().setAttributeMarshaller(AttributeMarshallers.NOOP_MARSHALLER)).build();
    public static final SimpleAttributeDefinition LOCAL_BIND_ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"local-bind-address", (ModelType)ModelType.STRING).setDefaultValue(null).setAllowNull(true).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition LOCAL_BIND_PORT = SimpleAttributeDefinitionBuilder.create((String)"local-bind-port", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1)).setAllowNull(true).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition JGROUPS_STACK = SimpleAttributeDefinitionBuilder.create((String)"jgroups-stack", (ModelType)ModelType.STRING).setDefaultValue(null).setAllowNull(true).setAlternatives(new String[]{"socket-binding", "group-address", "group-port", "local-bind-address", "local-bind-port"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition JGROUPS_CHANNEL = SimpleAttributeDefinitionBuilder.create((String)"jgroups-channel", (ModelType)ModelType.STRING).setDefaultValue(null).setAllowNull(true).setAlternatives(new String[]{"socket-binding", "group-address", "group-port", "local-bind-address", "local-bind-port"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition LOG_JOURNAL_WRITE_RATE = new SimpleAttributeDefinition("log-journal-write-rate", new ModelNode().set(false), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition MANAGEMENT_ADDRESS = new SimpleAttributeDefinition("management-address", new ModelNode().set(ConfigurationImpl.DEFAULT_MANAGEMENT_ADDRESS.toString()), ModelType.STRING, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition MANAGEMENT_NOTIFICATION_ADDRESS = new SimpleAttributeDefinition("management-notification-address", new ModelNode().set(ConfigurationImpl.DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS.toString()), ModelType.STRING, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition MAX_RETRY_INTERVAL = SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(2000L)).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition MEMORY_MEASURE_INTERVAL = SimpleAttributeDefinitionBuilder.create((String)"memory-measure-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(-1L)).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition MEMORY_WARNING_THRESHOLD = SimpleAttributeDefinitionBuilder.create((String)"memory-warning-threshold", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(25)).setMeasurementUnit(MeasurementUnit.PERCENTAGE).setAllowNull(true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final AttributeDefinition MESSAGE_COUNT = SimpleAttributeDefinitionBuilder.create((String)"message-count", (ModelType)ModelType.LONG).setStorageRuntime().build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_ENABLED = new SimpleAttributeDefinition("message-counter-enabled", new ModelNode().set(false), ModelType.BOOLEAN, true);
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_MAX_DAY_HISTORY = new SimpleAttributeDefinition("message-counter-max-day-history", new ModelNode().set(10), ModelType.INT, true, MeasurementUnit.DAYS);
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_SAMPLE_PERIOD = new SimpleAttributeDefinition("message-counter-sample-period", new ModelNode().set(10000L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS);
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_SCAN_PERIOD = new SimpleAttributeDefinition("message-expiry-scan-period", new ModelNode().set(30000L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_THREAD_PRIORITY = new SimpleAttributeDefinition("message-expiry-thread-priority", new ModelNode().set(3), ModelType.INT, true, MeasurementUnit.NONE, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition MESSAGES_ADDED = SimpleAttributeDefinitionBuilder.create((String)"messages-added", (ModelType)ModelType.LONG).setStorageRuntime().build();
    public static final AttributeDefinition MIN_LARGE_MESSAGE_SIZE = SimpleAttributeDefinitionBuilder.create((String)"min-large-message-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(102400)).setMeasurementUnit(MeasurementUnit.BYTES).setAllowNull(true).setRestartAllServices().build();
    public static final AttributeDefinition BACKUP_GROUP_NAME = SimpleAttributeDefinitionBuilder.create((String)"backup-group-name", (ModelType)ModelType.STRING).setAllowNull(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition PAGE_MAX_CONCURRENT_IO = SimpleAttributeDefinitionBuilder.create((String)"page-max-concurrent-io", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(5)).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final AttributeDefinition PAUSED = SimpleAttributeDefinitionBuilder.create((String)"paused", (ModelType)ModelType.BOOLEAN).setStorageRuntime().build();
    public static final SimpleAttributeDefinition PERF_BLAST_PAGES = new SimpleAttributeDefinition("perf-blast-pages", new ModelNode().set(-1), ModelType.INT, true, MeasurementUnit.NONE, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = new SimpleAttributeDefinition("persist-delivery-count-before-delivery", new ModelNode().set(false), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition PERSISTENCE_ENABLED = new SimpleAttributeDefinition("persistence-enabled", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition PERSIST_ID_CACHE = new SimpleAttributeDefinition("persist-id-cache", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition RECONNECT_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0)).setAllowNull(true).build();
    public static final PrimitiveListAttributeDefinition REMOTING_INTERCEPTORS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("remoting-interceptors", ModelType.STRING).setAllowNull(true)).setMinSize(1)).setMaxSize(Integer.MAX_VALUE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                writer.writeStartElement(attribute.getXmlName());
                for (ModelNode child : list) {
                    writer.writeStartElement(Element.CLASS_NAME.getLocalName());
                    writer.writeCharacters(child.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    })).build();
    public static final SimpleAttributeDefinition REPLICATION_CLUSTERNAME = SimpleAttributeDefinitionBuilder.create((String)"replication-clustername", (ModelType)ModelType.STRING).setAllowNull(true).setRestartAllServices().build();
    public static final AttributeDefinition RETRY_INTERVAL = SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(2000L)).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setRestartAllServices().build();
    public static final AttributeDefinition RETRY_INTERVAL_MULTIPLIER = SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.BIG_DECIMAL).setDefaultValue(new ModelNode().set(1.0)).setAllowNull(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition RUN_SYNC_SPEED_TEST = new SimpleAttributeDefinition("run-sync-speed-test", new ModelNode().set(false), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final AttributeDefinition SCHEDULED_COUNT = SimpleAttributeDefinitionBuilder.create((String)"scheduled-count", (ModelType)ModelType.LONG).setStorageRuntime().build();
    public static final AttributeDefinition SCHEDULED_THREAD_POOL_MAX_SIZE = SimpleAttributeDefinitionBuilder.create((String)"scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(5)).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = new SimpleAttributeDefinition("security-domain", new ModelNode().set("other"), ModelType.STRING, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition SECURITY_ENABLED = new SimpleAttributeDefinition("security-enabled", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition SECURITY_INVALIDATION_INTERVAL = new SimpleAttributeDefinition("security-invalidation-interval", new ModelNode().set(10000L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition SELECTOR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"selector", (ModelType)ModelType.STRING).setAllowNull(true).setAttributeMarshaller(AttributeMarshallers.SELECTOR_MARSHALLER)).setRestartAllServices().build();
    public static final SimpleAttributeDefinition SERVER_DUMP_INTERVAL = new SimpleAttributeDefinition("server-dump-interval", new ModelNode().set(-1L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition SHARED_STORE = new SimpleAttributeDefinition("shared-store", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition SOCKET_BINDING_ALTERNATIVE = SimpleAttributeDefinitionBuilder.create((String)"socket-binding", (ModelType)ModelType.STRING).setDefaultValue(null).setAllowNull(false).setAlternatives(new String[]{GROUP_ADDRESS.getName(), GROUP_PORT.getName(), LOCAL_BIND_ADDRESS.getName(), LOCAL_BIND_PORT.getName(), JGROUPS_STACK.getName(), JGROUPS_CHANNEL.getName()}).setRestartAllServices().build();
    public static final AttributeDefinition TEMPORARY = SimpleAttributeDefinitionBuilder.create((String)"temporary", (ModelType)ModelType.BOOLEAN).setStorageRuntime().build();
    public static final AttributeDefinition THREAD_POOL_MAX_SIZE = SimpleAttributeDefinitionBuilder.create((String)"thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(30)).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT = new SimpleAttributeDefinition("transaction-timeout", new ModelNode().set(300000L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT_SCAN_PERIOD = new SimpleAttributeDefinition("transaction-timeout-scan-period", new ModelNode().set(1000L), ModelType.LONG, true, MeasurementUnit.MILLISECONDS, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final SimpleAttributeDefinition TRANSFORMER_CLASS_NAME = SimpleAttributeDefinitionBuilder.create((String)"transformer-class-name", (ModelType)ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition USER = new SimpleAttributeDefinition("user", "user", new ModelNode().set("HORNETQ.CLUSTER.ADMIN.USER"), ModelType.STRING, true, true, null);
    public static final SimpleAttributeDefinition VALUE = new SimpleAttributeDefinition("value", ModelType.STRING, false);
    public static final SimpleAttributeDefinition WILD_CARD_ROUTING_ENABLED = new SimpleAttributeDefinition("wild-card-routing-enabled", new ModelNode().set(true), ModelType.BOOLEAN, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    public static final String ACCEPTOR = "acceptor";
    public static final String ACCEPTORS = "acceptors";
    public static final String ADDRESS = "address";
    public static final String ADDRESS_SETTING = "address-setting";
    public static final String ADDRESS_SETTINGS = "address-settings";
    public static final String BINDING_NAMES = "binding-names";
    public static final String BINDINGS_DIRECTORY = "bindings-directory";
    public static final String BRIDGE = "bridge";
    public static final String BRIDGES = "bridges";
    public static final String BROADCAST_GROUP = "broadcast-group";
    public static final String BROADCAST_GROUPS = "broadcast-groups";
    public static final String CLASS_NAME = "class-name";
    public static final String CLUSTER_CONNECTION = "cluster-connection";
    public static final String CLUSTER_CONNECTIONS = "cluster-connections";
    public static final String CONNECTION_FACTORY = "connection-factory";
    public static final String CONNECTOR = "connector";
    public static final String CONNECTORS = "connectors";
    public static final String CONNECTOR_NAME = "connector-name";
    public static final String CONNECTOR_REF_STRING = "connector-ref";
    public static final String CONNECTOR_SERVICE = "connector-service";
    public static final String CONNECTOR_SERVICES = "connector-services";
    public static final String CORE_ADDRESS = "core-address";
    public static final String CORE_QUEUE = "core-queue";
    public static final String CORE_QUEUES = "core-queues";
    public static final String DEFAULT = "default";
    public static final String DESTINATION = "destination";
    public static final String DISCOVERY_GROUP = "discovery-group";
    public static final String DISCOVERY_GROUPS = "discovery-groups";
    public static final String DISCOVERY_GROUP_REF = "discovery-group-ref";
    public static final String DIVERT = "divert";
    public static final String DIVERTS = "diverts";
    public static final String DURABLE_MESSAGE_COUNT = "durable-message-count";
    public static final String DURABLE_SUBSCRIPTION_COUNT = "durable-subscription-count";
    public static final String ENTRY = "entry";
    public static final String FILE_DEPLOYMENT_ENABLED = "file-deployment-enabled";
    public static final String GROUPING_HANDLER = "grouping-handler";
    public static final String ID = "id";
    public static final String IN_VM_ACCEPTOR = "in-vm-acceptor";
    public static final String IN_VM_CONNECTOR = "in-vm-connector";
    public static final String JMS_BRIDGE = "jms-bridge";
    public static final String JMS_CONNECTION_FACTORIES = "jms-connection-factories";
    public static final String JMS_DESTINATIONS = "jms-destinations";
    public static final String JMS_QUEUE = "jms-queue";
    public static final String JMS_TOPIC = "jms-topic";
    public static final String JNDI_BINDING = "jndi-binding";
    public static final String JOURNAL_DIRECTORY = "journal-directory";
    public static final String KEY = "key";
    public static final String INBOUND_CONFIG = "inbound-config";
    public static final String LARGE_MESSAGES_DIRECTORY = "large-messages-directory";
    public static final String LAST_VALUE_QUEUE = "last-value=queue";
    public static final String LOCAL = "local";
    public static final String LOCAL_TX = "LocalTransaction";
    public static final String MANAGE_XML_NAME = "manage";
    public static final String MATCH = "match";
    public static final String MODE = "mode";
    public static final String NAME = "name";
    public static final String NETTY_ACCEPTOR = "netty-acceptor";
    public static final String NETTY_CONNECTOR = "netty-connector";
    public static final String NONE = "none";
    public static final String NON_DURABLE_MESSAGE_COUNT = "non-durable-message-count";
    public static final String NON_DURABLE_SUBSCRIPTION_COUNT = "non-durable-subscription-count";
    public static final String NO_TX = "NoTransaction";
    public static final String NUMBER_OF_BYTES_PER_PAGE = "number-of-bytes-per-page";
    public static final String NUMBER_OF_PAGES = "number-of-pages";
    public static final String PAGING_DIRECTORY = "paging-directory";
    public static final String PARAM = "param";
    public static final String PERMISSION_ELEMENT_NAME = "permission";
    public static final String POOLED_CONNECTION_FACTORY = "pooled-connection-factory";
    public static final String QUEUE = "queue";
    public static final String QUEUE_NAME = "queue-name";
    public static final String QUEUE_NAMES = "queue-names";
    public static final String REMOTING_INTERCEPTORS_STRING = "remoting-interceptors";
    public static final String REMOTE_ACCEPTOR = "remote-acceptor";
    public static final String REMOTE_CONNECTOR = "remote-connector";
    public static final String REMOTING_INTERCEPTOR = "remoting-interceptor";
    public static final String RESOURCE_ADAPTER = "resource-adapter";
    public static final String ROLE = "role";
    public static final String ROLES_ATTR_NAME = "roles";
    public static final String SECURITY_ROLE = "security-role";
    public static final String SECURITY_SETTING = "security-setting";
    public static final String SECURITY_SETTINGS = "security-settings";
    public static final String SOCKET_BINDING = "socket-binding";
    public static final String HORNETQ_SERVER = "hornetq-server";
    public static final String STARTED = "started";
    public static final String STATIC_CONNECTORS = "static-connectors";
    public static final String STRING = "string";
    public static final String SUBSCRIPTION_COUNT = "subscription-count";
    public static final String SUBSYSTEM = "subsystem";
    public static final String TOPIC_ADDRESS = "topic-address";
    public static final String TYPE_ATTR_NAME = "type";
    public static final String VERSION = "version";
    public static final String XA = "xa";
    public static final String XA_TX = "XATransaction";
    public static final AttributeDefinition[] SIMPLE_ROOT_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{PERSISTENCE_ENABLED, SCHEDULED_THREAD_POOL_MAX_SIZE, THREAD_POOL_MAX_SIZE, SECURITY_DOMAIN, SECURITY_ENABLED, SECURITY_INVALIDATION_INTERVAL, WILD_CARD_ROUTING_ENABLED, MANAGEMENT_ADDRESS, MANAGEMENT_NOTIFICATION_ADDRESS, CLUSTER_USER, CLUSTER_PASSWORD, JMX_MANAGEMENT_ENABLED, JMX_DOMAIN, MESSAGE_COUNTER_ENABLED, MESSAGE_COUNTER_SAMPLE_PERIOD, MESSAGE_COUNTER_MAX_DAY_HISTORY, CONNECTION_TTL_OVERRIDE, ASYNC_CONNECTION_EXECUTION_ENABLED, TRANSACTION_TIMEOUT, TRANSACTION_TIMEOUT_SCAN_PERIOD, MESSAGE_EXPIRY_SCAN_PERIOD, MESSAGE_EXPIRY_THREAD_PRIORITY, ID_CACHE_SIZE, PERSIST_ID_CACHE, REMOTING_INTERCEPTORS, BACKUP, ALLOW_FAILBACK, FAILBACK_DELAY, FAILOVER_ON_SHUTDOWN, SHARED_STORE, PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY, PAGE_MAX_CONCURRENT_IO, CREATE_BINDINGS_DIR, CREATE_JOURNAL_DIR, JOURNAL_TYPE, JOURNAL_BUFFER_TIMEOUT, JOURNAL_BUFFER_SIZE, JOURNAL_SYNC_TRANSACTIONAL, JOURNAL_SYNC_NON_TRANSACTIONAL, LOG_JOURNAL_WRITE_RATE, JOURNAL_FILE_SIZE, JOURNAL_MIN_FILES, JOURNAL_COMPACT_PERCENTAGE, JOURNAL_COMPACT_MIN_FILES, JOURNAL_MAX_IO, PERF_BLAST_PAGES, RUN_SYNC_SPEED_TEST, SERVER_DUMP_INTERVAL, MEMORY_WARNING_THRESHOLD, MEMORY_MEASURE_INTERVAL, CHECK_FOR_LIVE_SERVER, BACKUP_GROUP_NAME, REPLICATION_CLUSTERNAME};
    public static final AttributeDefinition[] SIMPLE_ROOT_RESOURCE_WRITE_ATTRIBUTES = new AttributeDefinition[]{FAILOVER_ON_SHUTDOWN, MESSAGE_COUNTER_ENABLED, MESSAGE_COUNTER_MAX_DAY_HISTORY, MESSAGE_COUNTER_SAMPLE_PERIOD};
}

