/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.Messaging12SubsystemParser;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class Messaging13SubsystemParser
extends Messaging12SubsystemParser {
    private static final Messaging13SubsystemParser INSTANCE = new Messaging13SubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    protected Messaging13SubsystemParser() {
    }

    @Override
    protected void checkClusterConnectionConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
    }

    @Override
    protected void checkBroadcastGroupConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.SOCKET_BINDING, Element.JGROUPS_STACK);
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.JGROUPS_STACK, Element.GROUP_ADDRESS);
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.GROUP_ADDRESS, Element.SOCKET_BINDING);
    }

    @Override
    protected void checkDiscoveryGroupConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.SOCKET_BINDING, Element.JGROUPS_STACK);
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.JGROUPS_STACK, Element.GROUP_ADDRESS);
        Messaging13SubsystemParser.checkNotBothElements(reader, seen, Element.GROUP_ADDRESS, Element.SOCKET_BINDING);
    }

    @Override
    protected void handleUnknownConnectionFactoryAttribute(XMLExtendedStreamReader reader, Element element, ModelNode connectionFactory, boolean pooled) throws XMLStreamException {
        switch (element) {
            case CALL_FAILOVER_TIMEOUT: 
            case COMPRESS_LARGE_MESSAGES: {
                Messaging13SubsystemParser.handleElementText(reader, element, connectionFactory);
                break;
            }
            case USE_AUTO_RECOVERY: 
            case INITIAL_MESSAGE_PACKET_SIZE: 
            case INITIAL_CONNECT_ATTEMPTS: {
                if (!pooled) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                Messaging13SubsystemParser.handleElementText(reader, element, connectionFactory);
                break;
            }
            default: {
                super.handleUnknownConnectionFactoryAttribute(reader, element, connectionFactory, pooled);
            }
        }
    }

    @Override
    protected void handleUnknownClusterConnectionAttribute(XMLExtendedStreamReader reader, Element element, ModelNode clusterConnectionAdd) throws XMLStreamException {
        switch (element) {
            case CALL_FAILOVER_TIMEOUT: {
                Messaging13SubsystemParser.handleElementText(reader, element, clusterConnectionAdd);
                break;
            }
            default: {
                super.handleUnknownClusterConnectionAttribute(reader, element, clusterConnectionAdd);
            }
        }
    }

    @Override
    protected void handleUnknownConfigurationAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        switch (element) {
            case CHECK_FOR_LIVE_SERVER: 
            case BACKUP_GROUP_NAME: 
            case REPLICATION_CLUSTERNAME: {
                Messaging13SubsystemParser.handleElementText(reader, element, operation);
                break;
            }
            default: {
                super.handleUnknownConfigurationAttribute(reader, element, operation);
            }
        }
    }

    @Override
    protected void handleUnknownBroadcastGroupAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        switch (element) {
            case JGROUPS_STACK: 
            case JGROUPS_CHANNEL: {
                Messaging13SubsystemParser.handleElementText(reader, element, operation);
                break;
            }
            default: {
                super.handleUnknownBroadcastGroupAttribute(reader, element, operation);
            }
        }
    }

    @Override
    protected void handleUnknownDiscoveryGroupAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        switch (element) {
            case JGROUPS_STACK: 
            case JGROUPS_CHANNEL: {
                Messaging13SubsystemParser.handleElementText(reader, element, operation);
                break;
            }
            default: {
                super.handleUnknownDiscoveryGroupAttribute(reader, element, operation);
            }
        }
    }

    @Override
    protected void processHornetQServers(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
            switch (schemaVer) {
                case MESSAGING_1_0: 
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HORNETQ_SERVER: {
                    this.processHornetQServer(reader, subsystemAddress, list, schemaVer);
                    continue block7;
                }
                case JMS_BRIDGE: {
                    this.processJmsBridge(reader, subsystemAddress, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processJmsBridge(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> list) throws XMLStreamException {
        String bridgeName = null;
        String moduleName = null;
        int count = reader.getAttributeCount();
        block9: for (int n = 0; n < count; ++n) {
            String attrName = reader.getAttributeLocalName(n);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case NAME: {
                    bridgeName = reader.getAttributeValue(n);
                    continue block9;
                }
                case MODULE: {
                    moduleName = reader.getAttributeValue(n);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                }
            }
        }
        if (bridgeName == null || bridgeName.length() == 0) {
            bridgeName = "default";
        }
        ModelNode address = subsystemAddress.clone();
        address.add("jms-bridge", bridgeName);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        list.add(operation);
        if (moduleName != null && moduleName.length() > 0) {
            JMSBridgeDefinition.MODULE.parseAndSetParameter(moduleName, operation, (XMLStreamReader)reader);
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOURCE: 
                case TARGET: {
                    this.processJmsBridgeResource(reader, operation, element.getLocalName());
                    continue block10;
                }
                case QUALITY_OF_SERVICE: 
                case FAILURE_RETRY_INTERVAL: 
                case MAX_RETRIES: 
                case MAX_BATCH_SIZE: 
                case MAX_BATCH_TIME: 
                case SUBSCRIPTION_NAME: 
                case CLIENT_ID: 
                case ADD_MESSAGE_ID_IN_HEADER: {
                    Messaging13SubsystemParser.handleElementText(reader, element, operation);
                    continue block10;
                }
                case SELECTOR: {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"string");
                    String selector = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.SELECTOR.parseAndSetParameter(selector, operation, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processJmsBridgeResource(XMLExtendedStreamReader reader, ModelNode operation, String modelName) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case USER: 
                case PASSWORD: {
                    Messaging13SubsystemParser.handleElementText(reader, element, modelName, operation);
                    continue block5;
                }
                case CONNECTION_FACTORY: 
                case DESTINATION: {
                    Messaging13SubsystemParser.handleSingleAttribute(reader, element, modelName, "name", operation);
                    continue block5;
                }
                case CONTEXT: {
                    ModelNode context = operation.get(element.getDefinition(modelName).getName());
                    this.processContext(reader, context);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processContext(XMLExtendedStreamReader reader, ModelNode context) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int count = reader.getAttributeCount();
                    String key = null;
                    String value = null;
                    block8: for (int n = 0; n < count; ++n) {
                        String attrName = reader.getAttributeLocalName(n);
                        Attribute attribute = Attribute.forName(attrName);
                        switch (attribute) {
                            case KEY: {
                                key = reader.getAttributeValue(n);
                                continue block8;
                            }
                            case VALUE: {
                                value = reader.getAttributeValue(n);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                            }
                        }
                    }
                    context.get(key).set(value);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    protected List<String> parseRolesAttribute(XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        String roles = reader.getAttributeValue(index);
        return Arrays.asList(roles.split("[,\\s]+"));
    }

    static void handleSingleAttribute(XMLExtendedStreamReader reader, Element element, String modelName, String attributeName, ModelNode node) throws XMLStreamException {
        AttributeDefinition attributeDefinition = element.getDefinition(modelName);
        String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)attributeName);
        if (attributeDefinition instanceof SimpleAttributeDefinition) {
            ((SimpleAttributeDefinition)attributeDefinition).parseAndSetParameter(value, node, (XMLStreamReader)reader);
        } else if (attributeDefinition instanceof ListAttributeDefinition) {
            ((ListAttributeDefinition)attributeDefinition).parseAndAddParameterElement(value, node, (XMLStreamReader)reader);
        }
    }

    protected static void checkNotBothElements(XMLExtendedStreamReader reader, Set<Element> seen, Element element1, Element element2) throws XMLStreamException {
        if (seen.contains((Object)element1) && seen.contains((Object)element2)) {
            throw new XMLStreamException(MessagingMessages.MESSAGES.onlyOneRequired(element1.getLocalName(), element2.getLocalName()), reader.getLocation());
        }
    }
}

