/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.AbstractSubsystemTransformer;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.CoreAddressDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GenericTransportDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Messaging12SubsystemParser;
import org.jboss.as.messaging.Messaging13SubsystemParser;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.MessagingSubsystemRootResourceDefinition;
import org.jboss.as.messaging.MessagingXMLWriter;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.OperationTransformers;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.SecuritySettingDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"messaging");
    static final String RESOURCE_NAME = MessagingExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    public static final ModelVersion VERSION_1_2_0 = ModelVersion.create((int)1, (int)2, (int)0);
    public static final ModelVersion VERSION_1_1_0 = ModelVersion.create((int)1, (int)1, (int)0);

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        return MessagingExtension.getResourceDescriptionResolver(true, keyPrefix);
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(boolean useUnprefixedChildTypes, String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)MessagingXMLWriter.INSTANCE);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration rootRegistration = subsystem.registerSubsystemModel((ResourceDefinition)MessagingSubsystemRootResourceDefinition.INSTANCE);
        rootRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration serverRegistration = rootRegistration.registerSubModel((ResourceDefinition)new HornetQServerResourceDefinition(registerRuntimeOnly));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration coreAddress = serverRegistration.registerSubModel((ResourceDefinition)new CoreAddressDefinition());
            coreAddress.setRuntimeOnly(true);
        }
        serverRegistration.registerSubModel((ResourceDefinition)new AddressSettingDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new BroadcastGroupDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new DiscoveryGroupDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new DivertDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new QueueDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)GenericTransportDefinition.createAcceptorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)RemoteTransportDefinition.createAcceptorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)InVMTransportDefinition.createAcceptorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)GenericTransportDefinition.createConnectorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)RemoteTransportDefinition.createConnectorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)InVMTransportDefinition.createConnectorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new BridgeDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new ClusterConnectionDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new GroupingHandlerDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new ConnectorServiceDefinition(registerRuntimeOnly));
        for (String path : MessagingPathHandlers.PATHS.keySet()) {
            ManagementResourceRegistration bindings = serverRegistration.registerSubModel(PathElement.pathElement((String)"path", (String)path), (DescriptionProvider)new MessagingSubsystemProviders.PathProvider(path));
            MessagingPathHandlers.register(bindings, path);
        }
        serverRegistration.registerSubModel((ResourceDefinition)new ConnectionFactoryDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new PooledConnectionFactoryDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new JMSQueueDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new JMSTopicDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new SecuritySettingDefinition(registerRuntimeOnly));
        if (registerRuntimeOnly) {
            SimpleResourceDefinition deploymentsDef = new SimpleResourceDefinition(SUBSYSTEM_PATH, MessagingExtension.getResourceDescriptionResolver("deployed"));
            ManagementResourceRegistration deploymentsRegistration = subsystem.registerDeploymentModel((ResourceDefinition)deploymentsDef);
            ManagementResourceRegistration serverModel = deploymentsRegistration.registerSubModel((ResourceDefinition)new HornetQServerResourceDefinition(true));
            serverModel.registerSubModel((ResourceDefinition)JMSQueueDefinition.newDeployedJMSQueueDefinition());
            serverModel.registerSubModel((ResourceDefinition)JMSTopicDefinition.newDeployedJMSTopicDefinition());
        }
        rootRegistration.registerSubModel((ResourceDefinition)new JMSBridgeDefinition());
        MessagingExtension.registerTransformers_1_1_0(subsystem);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_0.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_1.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_2.getUriString(), (XMLElementReader)Messaging12SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_3.getUriString(), (XMLElementReader)Messaging13SubsystemParser.getInstance());
    }

    private static void registerTransformers_1_1_0(SubsystemRegistration subsystem) {
        String[] transports;
        final AttributeDefinition[] transformerdPooledCFAttributes = new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.INITIAL_CONNECT_ATTEMPTS, ConnectionFactoryAttributes.Pooled.INITIAL_MESSAGE_PACKET_SIZE, ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES, ConnectionFactoryAttributes.Pooled.USE_AUTO_RECOVERY, CommonAttributes.CALL_FAILOVER_TIMEOUT};
        TransformersSubRegistration transformers = subsystem.registerModelTransformers((ModelVersionRange)VERSION_1_1_0, (ResourceTransformer)new AbstractSubsystemTransformer(SUBSYSTEM_NAME){

            public ModelNode transformModel(TransformationContext context, ModelNode model) {
                ModelNode oldModel = model.clone();
                if (oldModel.hasDefined("hornetq-server")) {
                    for (Property server : oldModel.get("hornetq-server").asPropertyList()) {
                        if (!oldModel.get(new String[]{"hornetq-server", server.getName()}).hasDefined(CommonAttributes.CLUSTERED.getName())) {
                            oldModel.get(new String[]{"hornetq-server", server.getName()}).get(CommonAttributes.CLUSTERED.getName()).set(false);
                        }
                        oldModel.get(new String[]{"hornetq-server", server.getName()}).remove(CommonAttributes.CHECK_FOR_LIVE_SERVER.getName());
                        oldModel.get(new String[]{"hornetq-server", server.getName()}).remove(CommonAttributes.BACKUP_GROUP_NAME.getName());
                        oldModel.get(new String[]{"hornetq-server", server.getName()}).remove(CommonAttributes.REPLICATION_CLUSTERNAME.getName());
                        if (server.getValue().hasDefined("cluster-connection")) {
                            for (Property clusterConnection : server.getValue().get("cluster-connection").asPropertyList()) {
                                oldModel.get(new String[]{"hornetq-server", server.getName(), "cluster-connection", clusterConnection.getName()}).remove(CommonAttributes.CALL_FAILOVER_TIMEOUT.getName());
                            }
                        }
                        if (server.getValue().hasDefined("broadcast-group")) {
                            for (Property broadcastGroup : server.getValue().get("broadcast-group").asPropertyList()) {
                                oldModel.get(new String[]{"hornetq-server", server.getName(), "broadcast-group", broadcastGroup.getName()}).remove(CommonAttributes.JGROUPS_STACK.getName());
                                oldModel.get(new String[]{"hornetq-server", server.getName(), "broadcast-group", broadcastGroup.getName()}).remove(CommonAttributes.JGROUPS_CHANNEL.getName());
                            }
                        }
                        if (server.getValue().hasDefined("discovery-group")) {
                            for (Property discoveryGroup : server.getValue().get("discovery-group").asPropertyList()) {
                                oldModel.get(new String[]{"hornetq-server", server.getName(), "discovery-group", discoveryGroup.getName()}).remove(CommonAttributes.JGROUPS_STACK.getName());
                                oldModel.get(new String[]{"hornetq-server", server.getName(), "discovery-group", discoveryGroup.getName()}).remove(CommonAttributes.JGROUPS_CHANNEL.getName());
                            }
                        }
                        if (server.getValue().hasDefined("pooled-connection-factory")) {
                            for (Property pooledConnectionFactory : server.getValue().get("pooled-connection-factory").asPropertyList()) {
                                for (AttributeDefinition attribute : transformerdPooledCFAttributes) {
                                    oldModel.get(new String[]{"hornetq-server", server.getName(), "pooled-connection-factory", pooledConnectionFactory.getName()}).remove(attribute.getName());
                                }
                            }
                        }
                        if (!server.getValue().hasDefined("connection-factory")) continue;
                        for (Property connectionFactory : server.getValue().get("connection-factory").asPropertyList()) {
                            oldModel.get(new String[]{"hornetq-server", server.getName(), "connection-factory", connectionFactory.getName()}).remove(CommonAttributes.CALL_FAILOVER_TIMEOUT.getName());
                            if (!connectionFactory.getValue().hasDefined(CommonAttributes.HA.getName())) {
                                oldModel.get(new String[]{"hornetq-server", server.getName(), "connection-factory", connectionFactory.getName()}).get(CommonAttributes.HA.getName()).set(CommonAttributes.HA.getDefaultValue());
                            }
                            if (!connectionFactory.getValue().hasDefined(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getName()) || !connectionFactory.getValue().get(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getName()).equals(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getDefaultValue())) continue;
                            oldModel.get(new String[]{"hornetq-server", server.getName(), "connection-factory", connectionFactory.getName()}).get(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getName()).set(new ModelNode());
                        }
                    }
                }
                return oldModel;
            }
        });
        TransformersSubRegistration server = transformers.registerSubResource(PathElement.pathElement((String)"hornetq-server"));
        server.registerOperationTransformer("add", (OperationTransformer)new OperationTransformers.MultipleOperationalTransformer(new OperationTransformers.InsertDefaultValuesOperationTransformer(new AttributeDefinition[]{CommonAttributes.ID_CACHE_SIZE, CommonAttributes.CLUSTERED}), new OperationTransformers.RemoveAttributesOperationTransformer(new AttributeDefinition[]{CommonAttributes.CHECK_FOR_LIVE_SERVER, CommonAttributes.BACKUP_GROUP_NAME, CommonAttributes.REPLICATION_CLUSTERNAME})));
        RejectExpressionValuesTransformer rejectTransportParamExpressionTransformer = new RejectExpressionValuesTransformer(new String[]{"value"});
        for (String transport : transports = new String[]{"acceptor", "remote-acceptor", "in-vm-acceptor", "connector", "remote-connector", "in-vm-connector"}) {
            TransformersSubRegistration remoteConnector = server.registerSubResource(PathElement.pathElement((String)transport));
            TransformersSubRegistration transportParam = remoteConnector.registerSubResource(PathElement.pathElement((String)"param"));
            transportParam.registerOperationTransformer("add", (OperationTransformer)rejectTransportParamExpressionTransformer);
            transportParam.registerOperationTransformer("write-attribute", rejectTransportParamExpressionTransformer.getWriteAttributeTransformer());
        }
        RejectExpressionValuesTransformer rejectExpressionTransformer = new RejectExpressionValuesTransformer(new String[]{"path"});
        for (String path : MessagingPathHandlers.PATHS.keySet()) {
            TransformersSubRegistration pathRegistration = server.registerSubResource(PathElement.pathElement((String)"path", (String)path), (ResourceTransformer)rejectExpressionTransformer, (OperationTransformer)rejectExpressionTransformer);
            pathRegistration.registerOperationTransformer("add", (OperationTransformer)rejectExpressionTransformer);
            pathRegistration.registerOperationTransformer("write-attribute", rejectExpressionTransformer.getWriteAttributeTransformer());
        }
        TransformersSubRegistration clusterConnection = server.registerSubResource(ClusterConnectionDefinition.PATH);
        clusterConnection.registerOperationTransformer("add", (OperationTransformer)new OperationTransformers.RemoveAttributesOperationTransformer(new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT}));
        clusterConnection.registerOperationTransformer("write-attribute", (OperationTransformer)new OperationTransformers.FailUnignoredAttributesOperationTransformer(new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT}));
        TransformersSubRegistration connectionFactory = server.registerSubResource(ConnectionFactoryDefinition.PATH);
        connectionFactory.registerOperationTransformer("add", (OperationTransformer)new OperationTransformers.RemoveAttributesOperationTransformer(new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT}));
        connectionFactory.registerOperationTransformer("write-attribute", (OperationTransformer)new OperationTransformers.FailUnignoredAttributesOperationTransformer(new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT}));
        TransformersSubRegistration pooledConnectionFactory = server.registerSubResource(PooledConnectionFactoryDefinition.PATH);
        pooledConnectionFactory.registerOperationTransformer("add", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode transformedOperation = operation.clone();
                for (AttributeDefinition attribute : transformerdPooledCFAttributes) {
                    transformedOperation.remove(attribute.getName());
                }
                if (!transformedOperation.hasDefined(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS.getName())) {
                    transformedOperation.get(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS.getName()).set(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS.getDefaultValue());
                }
                return new OperationTransformer.TransformedOperation(transformedOperation, OperationResultTransformer.ORIGINAL_RESULT);
            }
        });
        pooledConnectionFactory.registerOperationTransformer("write-attribute", (OperationTransformer)new OperationTransformers.FailUnignoredAttributesOperationTransformer(transformerdPooledCFAttributes));
    }
}

