/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;

public interface OperationTransformers {

    public static final class InsertDefaultValuesOperationTransformer
    implements OperationTransformer {
        private final AttributeDefinition[] definitions;

        public InsertDefaultValuesOperationTransformer(AttributeDefinition ... definitions) {
            this.definitions = definitions;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            for (AttributeDefinition attr : this.definitions) {
                if (operation.hasDefined(attr.getName())) continue;
                operation.get(attr.getName()).set(attr.getDefaultValue());
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    public static final class FailUnignoredAttributesOperationTransformer
    implements OperationTransformer {
        private final AttributeDefinition[] definitions;

        public FailUnignoredAttributesOperationTransformer(AttributeDefinition ... definitions) {
            this.definitions = definitions;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            OperationResultTransformer resultTransformer = OperationResultTransformer.ORIGINAL_RESULT;
            final ArrayList<String> found = new ArrayList<String>();
            for (AttributeDefinition attr : this.definitions) {
                if (!operation.require("name").asString().equals(attr.getName())) continue;
                if (found.size() == 0) {
                    resultTransformer = new OperationResultTransformer(){

                        public ModelNode transformResult(ModelNode result) {
                            ModelNode transformed = result;
                            if (!"ignored-by-unaffected-host-controller".equals(result.get("outcome").asString())) {
                                transformed = new ModelNode();
                                transformed.get("outcome").set("failed");
                                transformed.get("failure-description").set(MessagingMessages.MESSAGES.unsupportedAttributeInVersion(found.toString(), MessagingExtension.VERSION_1_1_0));
                            }
                            return transformed;
                        }
                    };
                }
                found.add(attr.getName());
            }
            return new OperationTransformer.TransformedOperation(operation, resultTransformer);
        }
    }

    public static final class RemoveAttributesOperationTransformer
    implements OperationTransformer {
        private final AttributeDefinition[] definitions;

        public RemoveAttributesOperationTransformer(AttributeDefinition ... definitions) {
            this.definitions = definitions;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            ModelNode transformedOperation = operation.clone();
            for (AttributeDefinition attr : this.definitions) {
                transformedOperation.remove(attr.getName());
            }
            return new OperationTransformer.TransformedOperation(transformedOperation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    public static final class MultipleOperationalTransformer
    implements OperationTransformer {
        private final OperationTransformer[] transformers;

        public MultipleOperationalTransformer(OperationTransformer ... transformers) {
            this.transformers = transformers;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            OperationTransformer.TransformedOperation transformedOperation = new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
            for (OperationTransformer transformer : this.transformers) {
                transformedOperation = transformer.transformOperation(context, address, transformedOperation.getTransformedOperation());
            }
            return transformedOperation;
        }
    }
}

