/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueConfigurationWriteHandler;
import org.jboss.as.messaging.QueueControlHandler;
import org.jboss.as.messaging.QueueReadAttributeHandler;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.dmr.ModelType;

public class QueueDefinition
extends SimpleResourceDefinition {
    public static final AttributeDefinition ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"queue-address", (ModelType)ModelType.STRING).setXmlName("address").setRestartAllServices().build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADDRESS, CommonAttributes.FILTER, CommonAttributes.DURABLE};
    static final AttributeDefinition ID = SimpleAttributeDefinitionBuilder.create((String)"id", (ModelType)ModelType.LONG).setStorageRuntime().build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.PAUSED, CommonAttributes.TEMPORARY, ID};
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.SCHEDULED_COUNT, CommonAttributes.CONSUMER_COUNT};
    private final boolean registerRuntimeOnly;

    public QueueDefinition(boolean registerRuntimeOnly) {
        super(PathElement.pathElement((String)"queue"), MessagingExtension.getResourceDescriptionResolver("queue"), (AbstractAddStepHandler)QueueAdd.INSTANCE, (OperationStepHandler)QueueRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)QueueConfigurationWriteHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
            }
            for (AttributeDefinition metric : METRICS) {
                registry.registerMetric(metric, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            QueueControlHandler.INSTANCE.registerOperations(registry);
        }
    }
}

