/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class QueueReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final QueueReadAttributeHandler INSTANCE = new QueueReadAttributeHandler();
    private ParametersValidator validator = new ParametersValidator();

    private QueueReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        String queueName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        QueueControl control = (QueueControl)QueueControl.class.cast(hqServer.getManagementService().getResource("core.queue." + queueName));
        if (CommonAttributes.MESSAGE_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getMessageCount());
        } else if (CommonAttributes.SCHEDULED_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getScheduledCount());
        } else if (CommonAttributes.CONSUMER_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getConsumerCount());
        } else if (CommonAttributes.DELIVERING_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getDeliveringCount());
        } else if (CommonAttributes.MESSAGES_ADDED.getName().equals(attributeName)) {
            context.getResult().set(control.getMessagesAdded());
        } else if (QueueDefinition.ID.getName().equals(attributeName)) {
            context.getResult().set(control.getID());
        } else if (CommonAttributes.PAUSED.getName().equals(attributeName)) {
            try {
                context.getResult().set(control.isPaused());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (CommonAttributes.TEMPORARY.getName().equals(attributeName)) {
            context.getResult().set(control.isTemporary());
        } else {
            throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
        }
        context.stepCompleted();
    }
}

