/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class TransportConfigOperationHandlers {
    static final OperationStepHandler REMOVE = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            TransportConfigOperationHandlers.reloadRequiredStep(context);
            context.stepCompleted();
        }
    };

    TransportConfigOperationHandlers() {
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    OperationContext.RollbackHandler rh;
                    ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceController controller = context.getServiceRegistry(false).getService(hqServiceName);
                    if (controller != null) {
                        context.reloadRequired();
                        rh = OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER;
                    } else {
                        rh = OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
                    }
                    context.completeStep(rh);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static void processAcceptors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        Map<String, Object> parameters;
        ModelNode config;
        String acceptorName;
        HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("acceptor")) {
            for (Property property : params.get("acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName));
            }
        }
        if (params.hasDefined("remote-acceptor")) {
            for (Property property : params.get("remote-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                bindings.add(binding);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        if (params.hasDefined("in-vm-acceptor")) {
            for (Property property : params.get("in-vm-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                parameters.put(InVMTransportDefinition.SERVER_ID.getName(), config.get(InVMTransportDefinition.SERVER_ID.getName()).asInt());
                acceptors.put(acceptorName, new TransportConfiguration(InVMAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
    }

    static Map<String, Object> getParameters(OperationContext context, ModelNode config) throws OperationFailedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (config.hasDefined("param")) {
            for (Property parameter : config.get("param").asPropertyList()) {
                String name = parameter.getName();
                ModelNode value = parameter.getValue().get("value");
                ModelNode expression = ParseUtils.parsePossibleExpression((String)value.asString());
                String resolvedValue = context.resolveExpressions(expression).asString();
                parameters.put(name, resolvedValue);
            }
        }
        return parameters;
    }

    static void processConnectors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        Map<String, Object> parameters;
        ModelNode config;
        String connectorName;
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("connector")) {
            for (Property property : params.get("connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName));
            }
        }
        if (params.hasDefined("remote-connector")) {
            for (Property property : params.get("remote-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                bindings.add(binding);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        if (params.hasDefined("in-vm-connector")) {
            for (Property property : params.get("in-vm-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                parameters.put(InVMTransportDefinition.SERVER_ID.getName(), config.get(InVMTransportDefinition.SERVER_ID.getName()).asInt());
                connectors.put(connectorName, new TransportConfiguration(InVMConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        configuration.setConnectorConfigurations(connectors);
    }

    static class BasicTransportConfigAdd
    implements OperationStepHandler,
    DescriptionProvider {
        private final AttributeDefinition[] attributes;
        private final boolean isAcceptor;

        BasicTransportConfigAdd(boolean isAcceptor, AttributeDefinition[] attributes) {
            this.isAcceptor = isAcceptor;
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, subModel);
            }
            if (operation.hasDefined("param")) {
                for (Property property : operation.get("param").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"param", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.parameterNotDefined(property.getName())));
                    }
                    param.getModel().get("value").set(value);
                }
            }
            TransportConfigOperationHandlers.reloadRequiredStep(context);
            context.stepCompleted();
        }

        public ModelNode getModelDescription(Locale locale) {
            if (this.isAcceptor) {
                return MessagingDescriptions.getAcceptorAdd(locale, this.attributes);
            }
            return MessagingDescriptions.getConnectorAdd(locale, this.attributes);
        }
    }
}

