/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryService;
import org.jboss.as.messaging.jms.ConnectionFactoryType;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final ConnectionFactoryAdd INSTANCE = new ConnectionFactoryAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AlternativeAttributeCheckHandler.checkAlternatives(operation, ConnectionFactoryAttributes.Common.CONNECTOR.getName(), ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName(), false);
        for (AttributeDefinition attribute : ConnectionFactoryDefinition.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ConnectionFactoryConfiguration configuration = ConnectionFactoryAdd.createConfiguration(context, name, model);
        ConnectionFactoryService service = new ConnectionFactoryService(configuration);
        ServiceName serviceName = JMSServices.getConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.getExecutorInjector(), (boolean)false);
        newControllers.add(serviceBuilder.install());
    }

    static ConnectionFactoryConfiguration createConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        ModelNode lbcn;
        ModelNode entries = ConnectionFactoryAttributes.Common.ENTRIES.resolveModelAttribute(context, model);
        String[] jndiBindings = JMSServices.getJndiBindings(entries);
        ConnectionFactoryConfigurationImpl config = new ConnectionFactoryConfigurationImpl(name, false, jndiBindings);
        config.setHA(CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean());
        config.setAutoGroup(ConnectionFactoryAttributes.Common.AUTO_GROUP.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnAcknowledge(ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnDurableSend(ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnNonDurableSend(ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        config.setCacheLargeMessagesClient(ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT.resolveModelAttribute(context, model).asBoolean());
        config.setCallTimeout(CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, model).asLong());
        config.setClientFailureCheckPeriod((long)ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD.resolveModelAttribute(context, model).asInt());
        config.setCallFailoverTimeout(CommonAttributes.CALL_FAILOVER_TIMEOUT.resolveModelAttribute(context, model).asLong());
        ModelNode clientId = CommonAttributes.CLIENT_ID.resolveModelAttribute(context, model);
        if (clientId.isDefined()) {
            config.setClientID(clientId.asString());
        }
        config.setCompressLargeMessages(ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES.resolveModelAttribute(context, model).asBoolean());
        config.setConfirmationWindowSize(ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        config.setConnectionTTL(ConnectionFactoryAttributes.Common.CONNECTION_TTL.resolveModelAttribute(context, model).asLong());
        if (model.hasDefined("connector")) {
            ModelNode connectorRefs = model.get("connector");
            ArrayList connectorNames = new ArrayList(connectorRefs.keys());
            config.setConnectorNames(connectorNames);
        }
        config.setConsumerMaxRate(CommonAttributes.CONSUMER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        config.setConsumerWindowSize(ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        ModelNode discoveryGroupName = ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        if (discoveryGroupName.isDefined()) {
            config.setDiscoveryGroupName(discoveryGroupName.asString());
        }
        config.setDupsOKBatchSize(ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        config.setFailoverOnInitialConnection(ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION.resolveModelAttribute(context, model).asBoolean());
        ModelNode groupId = ConnectionFactoryAttributes.Common.GROUP_ID.resolveModelAttribute(context, model);
        if (groupId.isDefined()) {
            config.setGroupID(groupId.asString());
        }
        if ((lbcn = ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model)).isDefined()) {
            config.setLoadBalancingPolicyClassName(lbcn.asString());
        }
        config.setMaxRetryInterval(ConnectionFactoryAttributes.Common.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        config.setMinLargeMessageSize(ConnectionFactoryAttributes.Common.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt());
        config.setPreAcknowledge(ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE.resolveModelAttribute(context, model).asBoolean());
        config.setProducerMaxRate(ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        config.setProducerWindowSize(ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        config.setReconnectAttempts(CommonAttributes.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        config.setRetryInterval(ConnectionFactoryAttributes.Common.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        config.setRetryIntervalMultiplier(ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble());
        config.setScheduledThreadPoolMaxSize(ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        config.setThreadPoolMaxSize(ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        config.setTransactionBatchSize(ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        config.setUseGlobalPools(ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS.resolveModelAttribute(context, model).asBoolean());
        config.setLoadBalancingPolicyClassName(ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model).asString());
        JMSFactoryType jmsFactoryType = ConnectionFactoryType.valueOf(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.resolveModelAttribute(context, model).asString()).getType();
        config.setFactoryType(jmsFactoryType);
        return config;
    }
}

