/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.DeprecatedAttributeWriteHandler;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryAddJndiHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryReadAttributeHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryWriteAttributeHandler;

public class ConnectionFactoryDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"connection-factory");
    public static final AttributeDefinition[] ATTRIBUTES = ConnectionFactoryDefinition.concat(ConnectionFactoryAttributes.Regular.ATTRIBUTES, ConnectionFactoryAttribute.getDefinitions(ConnectionFactoryAttributes.Common.ATTRIBUTES));
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{ConnectionFactoryAttributes.Regular.INITIAL_MESSAGE_PACKET_SIZE};
    private final boolean registerRuntimeOnly;

    static final AttributeDefinition[] concat(AttributeDefinition[] common, AttributeDefinition ... specific) {
        int size = common.length + specific.length;
        AttributeDefinition[] result = new AttributeDefinition[size];
        System.arraycopy(common, 0, result, 0, common.length);
        System.arraycopy(specific, 0, result, common.length, specific.length);
        return result;
    }

    public ConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory"), (AbstractAddStepHandler)ConnectionFactoryAdd.INSTANCE, (OperationStepHandler)ConnectionFactoryRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr == ConnectionFactoryAttributes.Common.DISCOVERY_INITIAL_WAIT_TIMEOUT || attr == ConnectionFactoryAttributes.Common.FAILOVER_ON_SERVER_SHUTDOWN) {
                registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)new DeprecatedAttributeWriteHandler(attr.getName()));
                continue;
            }
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)ConnectionFactoryWriteAttributeHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)ConnectionFactoryReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            SimpleOperationDefinition op = new SimpleOperationDefinition("add-jndi", this.getResourceDescriptionResolver(), new AttributeDefinition[]{ConnectionFactoryAddJndiHandler.JNDI_BINDING});
            registry.registerOperationHandler((OperationDefinition)op, (OperationStepHandler)ConnectionFactoryAddJndiHandler.INSTANCE);
        }
    }
}

