/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JMSQueueAdd
extends AbstractAddStepHandler {
    public static final JMSQueueAdd INSTANCE = new JMSQueueAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : JMSQueueDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ModelNode selectorNode = CommonAttributes.SELECTOR.resolveModelAttribute(context, model);
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        String selector = selectorNode.isDefined() ? selectorNode.asString() : null;
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        String[] jndiBindings = JMSServices.getJndiBindings(entries);
        this.installServices(verificationHandler, newControllers, name, serviceTarget, hqServiceName, selector, durable, jndiBindings);
    }

    public void installServices(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ServiceTarget serviceTarget, ServiceName hqServiceName, String selector, boolean durable, String[] jndiBindings) {
        JMSQueueService service = new JMSQueueService(name, selector, durable, jndiBindings);
        ServiceName serviceName = JMSServices.getJmsQueueBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.ACTIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.getExecutorInjector(), (boolean)false);
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

