/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigProperties;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class PooledConnectionFactoryAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final PooledConnectionFactoryAdd INSTANCE = new PooledConnectionFactoryAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AlternativeAttributeCheckHandler.checkAlternatives(operation, ConnectionFactoryAttributes.Common.CONNECTOR.getName(), ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName(), false);
        for (AttributeDefinition attribute : ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES)) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String txType;
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        ModelNode resolvedModel = model.clone();
        for (AttributeDefinition attribute : ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES)) {
            resolvedModel.get(attribute.getName()).set(attribute.resolveModelAttribute(context, resolvedModel));
        }
        String jndiName = ((ModelNode)resolvedModel.get(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList().get(0)).asString();
        int minPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).asInt();
        int maxPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).asInt();
        String txSupport = resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()) ? ("local".equals(txType = resolvedModel.get(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()).asString()) ? "LocalTransaction" : ("none".equals(txType) ? "NoTransaction" : "XATransaction")) : "XATransaction";
        ServiceTarget serviceTarget = context.getServiceTarget();
        List<String> connectors = PooledConnectionFactoryAdd.getConnectors(resolvedModel);
        String discoveryGroupName = PooledConnectionFactoryAdd.getDiscoveryGroup(resolvedModel);
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(resolvedModel, context);
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(address);
        ServiceName hornetQResourceAdapterService = JMSServices.getPooledConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name});
        PooledConnectionFactoryService resourceAdapterService = new PooledConnectionFactoryService(name, connectors, discoveryGroupName, adapterParams, jndiName, txSupport, minPoolSize, maxPoolSize);
        ServiceBuilder serviceBuilder = serviceTarget.addService(hornetQResourceAdapterService, (Service)resourceAdapterService).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, resourceAdapterService.getTransactionManager()).addDependency(hqServiceName, HornetQServer.class, resourceAdapterService.getHornetQService()).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName)).addListener((ServiceListener)verificationHandler);
        newControllers.add(serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static List<String> getConnectors(ModelNode model) {
        ArrayList<String> connectorNames = new ArrayList<String>();
        if (model.hasDefined("connector")) {
            for (String connectorName : model.get("connector").keys()) {
                connectorNames.add(connectorName);
            }
        }
        return connectorNames;
    }

    static String getDiscoveryGroup(ModelNode model) {
        if (model.hasDefined(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName())) {
            return model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName()).asString();
        }
        return null;
    }

    static List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model, OperationContext context) throws OperationFailedException {
        ArrayList<PooledConnectionFactoryConfigProperties> configs = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (ConnectionFactoryAttribute nodeAttribute : PooledConnectionFactoryDefinition.ATTRIBUTES) {
            AttributeDefinition definition;
            ModelNode node;
            if (!nodeAttribute.isResourceAdapterProperty() || !(node = (definition = nodeAttribute.getDefinition()).resolveModelAttribute(context, model)).isDefined()) continue;
            String value = node.asString();
            configs.add(new PooledConnectionFactoryConfigProperties(nodeAttribute.getPropertyName(), value, nodeAttribute.getClassType()));
        }
        return configs;
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getPooledConnectionFactoryAdd(locale);
    }
}

